/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import java.util.SortedMap;
import org.apache.ratis.BaseTest;
import org.apache.ratis.metrics.impl.RatisMetricRegistryImpl;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.metrics.LeaderElectionMetrics;
import org.apache.ratis.thirdparty.com.codahale.metrics.Gauge;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestLeaderElectionMetrics
extends BaseTest {
    private static LeaderElectionMetrics leaderElectionMetrics;
    private static RatisMetricRegistryImpl ratisMetricRegistry;

    @BeforeAll
    public static void setUp() {
        RaftGroupId raftGroupId = RaftGroupId.randomId();
        RaftPeerId raftPeerId = RaftPeerId.valueOf((String)"TestId");
        RaftGroupMemberId raftGroupMemberId = RaftGroupMemberId.valueOf((RaftPeerId)raftPeerId, (RaftGroupId)raftGroupId);
        leaderElectionMetrics = LeaderElectionMetrics.getLeaderElectionMetrics((RaftGroupMemberId)raftGroupMemberId, () -> 1000L);
        ratisMetricRegistry = (RatisMetricRegistryImpl)leaderElectionMetrics.getRegistry();
    }

    @Test
    public void testOnLeaderElectionCompletion() throws Exception {
        leaderElectionMetrics.onNewLeaderElectionCompletion();
        SortedMap gauges = ratisMetricRegistry.getGauges((s, metric) -> s.contains("lastLeaderElectionElapsedTime"));
        this.LOG.info("{} gauges: {}", (Object)"lastLeaderElectionElapsedTime", (Object)gauges);
        Long leaderElectionLatency = (Long)((Gauge)gauges.values().iterator().next()).getValue();
        Assertions.assertTrue((leaderElectionLatency >= 0L ? 1 : 0) != 0, (String)("leaderElectionLatency = " + leaderElectionLatency));
    }

    @Test
    public void testOnLeaderElectionTimeout() throws Exception {
        long numLeaderElectionTimeouts = ratisMetricRegistry.counter("timeoutCount").getCount();
        Assertions.assertEquals((long)0L, (long)numLeaderElectionTimeouts);
        leaderElectionMetrics.onLeaderElectionTimeout();
        numLeaderElectionTimeouts = ratisMetricRegistry.counter("timeoutCount").getCount();
        Assertions.assertEquals((long)1L, (long)numLeaderElectionTimeouts);
    }
}

