/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.PeerChanges;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.impl.RetryCacheTestUtil;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class RetryCacheTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public static final int NUM_SERVERS = 3;

    @Test
    public void testBasicRetry() throws Exception {
        this.runWithNewCluster(3, this::runTestBasicRetry);
    }

    void runTestBasicRetry(CLUSTER cluster) throws Exception {
        RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = ((MiniRaftCluster)cluster).getLeaderAndSendFirstMessage(false).getId();
        long oldLastApplied = ((MiniRaftCluster)cluster).getLeader().getInfo().getLastAppliedIndex();
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
            RaftClientRpc rpc = client.getClientRpc();
            long callId = 999L;
            RaftClientRequest r = ((MiniRaftCluster)cluster).newRaftClientRequest(client.getId(), leaderId, 999L, new RaftTestUtil.SimpleMessage("message"));
            RetryCacheTests.assertReply(rpc.sendRequest(r), client, 999L);
            for (int i = 0; i < 5; ++i) {
                RetryCacheTests.assertReply(rpc.sendRequest(r), client, 999L);
            }
            this.assertServer((MiniRaftCluster)cluster, client.getId(), 999L, oldLastApplied);
        }
    }

    public static void assertReply(RaftClientReply reply, RaftClient client, long callId) {
        Assertions.assertEquals((Object)client.getId(), (Object)reply.getClientId());
        Assertions.assertEquals((long)callId, (long)reply.getCallId());
        Assertions.assertTrue((boolean)reply.isSuccess());
    }

    public void assertServer(MiniRaftCluster cluster, ClientId clientId, long callId, long oldLastApplied) throws Exception {
        long leaderApplied = cluster.getLeader().getInfo().getLastAppliedIndex();
        for (RaftServer.Division server : cluster.iterateDivisions()) {
            this.LOG.info("check server " + server.getId());
            if (server.getInfo().getLastAppliedIndex() < leaderApplied) {
                Thread.sleep(1000L);
            }
            Assertions.assertEquals((long)2L, (long)server.getRetryCache().getStatistics().size());
            Assertions.assertNotNull((Object)RetryCacheTestUtil.get(server, clientId, callId));
            Assertions.assertEquals((int)1, (int)RetryCacheTests.count(server.getRaftLog(), oldLastApplied + 1L));
        }
    }

    static int count(RaftLog log, long startIndex) throws RaftLogIOException {
        long nextIndex = log.getNextIndex();
        int count = 0;
        for (long i = startIndex; i < nextIndex; ++i) {
            if (!log.get(i).hasStateMachineLogEntry()) continue;
            ++count;
        }
        return count;
    }

    @Test
    public void testRetryOnNewLeader() throws Exception {
        this.runWithNewCluster(3, this::runTestRetryOnNewLeader);
    }

    void runTestRetryOnNewLeader(CLUSTER cluster) throws Exception {
        RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = ((MiniRaftCluster)cluster).getLeaderAndSendFirstMessage(false).getId();
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
            RaftClientRpc rpc = client.getClientRpc();
            long callId = 999L;
            RaftClientRequest r = ((MiniRaftCluster)cluster).newRaftClientRequest(client.getId(), leaderId, 999L, new RaftTestUtil.SimpleMessage("message"));
            RetryCacheTests.assertReply(rpc.sendRequest(r), client, 999L);
            long oldLastApplied = ((MiniRaftCluster)cluster).getLeader().getInfo().getLastAppliedIndex();
            PeerChanges change = ((MiniRaftCluster)cluster).removePeers(2, true, Collections.emptyList());
            List<RaftPeer> allPeers = change.getPeersInNewConf();
            RaftServerTestUtil.runWithMinorityPeers(cluster, allPeers, (CheckedConsumer<List<RaftPeer>, IOException>)((CheckedConsumer)arg_0 -> cluster.setConfiguration(arg_0)));
            RaftPeerId newLeaderId = (RaftPeerId)JavaUtils.attemptRepeatedly(() -> {
                RaftPeerId id = RaftTestUtil.waitForLeader(cluster).getId();
                Assertions.assertNotEquals((Object)leaderId, (Object)id);
                return id;
            }, (int)10, (TimeDuration)TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS), (String)("wait for a leader different than " + leaderId), (Logger)this.LOG);
            Assertions.assertNotEquals((Object)leaderId, (Object)newLeaderId);
            r = ((MiniRaftCluster)cluster).newRaftClientRequest(client.getId(), newLeaderId, 999L, new RaftTestUtil.SimpleMessage("message"));
            rpc.addRaftPeers(change.getAddedPeers());
            for (int i = 0; i < 10; ++i) {
                try {
                    RetryCacheTests.assertReply(rpc.sendRequest(r), client, 999L);
                    this.LOG.info("successfully sent out the retry request_" + i);
                }
                catch (Exception e) {
                    this.LOG.info("hit exception while retrying the same request: " + r, (Throwable)e);
                }
                Thread.sleep(100L);
            }
            Assertions.assertEquals((int)0, (int)RetryCacheTests.count(((MiniRaftCluster)cluster).getLeader().getRaftLog(), oldLastApplied + 1L));
        }
    }

    static {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
    }
}

