/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.client.api.GroupManagementApi;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.AlreadyExistsException;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.BlockRequestHandlingInjection;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedBiConsumer;
import org.apache.ratis.util.function.CheckedConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class GroupManagementBaseTest
extends BaseTest {
    static final Logger LOG = LoggerFactory.getLogger(GroupManagementBaseTest.class);
    static final RaftProperties PROP = new RaftProperties();
    static final CheckedBiConsumer<MiniRaftCluster, RaftGroup, RuntimeException> NOOP;

    public GroupManagementBaseTest() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
    }

    public abstract MiniRaftCluster.Factory<? extends MiniRaftCluster> getClusterFactory();

    public MiniRaftCluster getCluster(int peerNum) {
        return this.getClusterFactory().newCluster(peerNum, PROP);
    }

    @Test
    public void testGroupWithPriority() throws Exception {
        MiniRaftCluster cluster = this.getCluster(0);
        LOG.info("Start testMultiGroup" + cluster.printServers());
        List<RaftPeerId> ids = Arrays.stream(MiniRaftCluster.generateIds(3, 0)).map(RaftPeerId::valueOf).collect(Collectors.toList());
        ids.forEach(id -> cluster.putNewServer((RaftPeerId)id, null, true));
        LOG.info("putNewServer: " + cluster.printServers());
        cluster.start();
        TimeUnit.SECONDS.sleep(1L);
        LOG.info("start: " + cluster.printServers());
        Assertions.assertNull((Object)cluster.getLeader());
        List<RaftPeer> peers = cluster.getPeers();
        Random r = new Random(1L);
        int suggestedLeaderIndex = r.nextInt(peers.size());
        List<RaftPeer> peersWithPriority = RaftTestUtil.getPeersWithPriority(peers, peers.get(suggestedLeaderIndex));
        RaftGroup newGroup = RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), peersWithPriority);
        LOG.info("add new group: " + newGroup);
        try (RaftClient client = cluster.createClient(newGroup);){
            Assertions.assertTrue((client.getLeaderId() == peersWithPriority.get(suggestedLeaderIndex).getId() ? 1 : 0) != 0);
            for (RaftPeer p : newGroup.getPeers()) {
                client.getGroupManagementApi(p.getId()).add(newGroup);
            }
        }
        JavaUtils.attempt(() -> {
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster, newGroup.getGroupId());
            Assertions.assertTrue((leader.getId() == ((RaftPeer)peers.get(suggestedLeaderIndex)).getId() ? 1 : 0) != 0);
        }, (int)10, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS), (String)"testMultiGroupWithPriority", (Logger)LOG);
        String suggestedLeader = peers.get(suggestedLeaderIndex).getId().toString();
        BlockRequestHandlingInjection.getInstance().blockRequestor(suggestedLeader);
        BlockRequestHandlingInjection.getInstance().blockReplier(suggestedLeader);
        cluster.setBlockRequestsFrom(suggestedLeader, true);
        JavaUtils.attempt(() -> {
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster, newGroup.getGroupId());
            Assertions.assertTrue((leader.getId() != ((RaftPeer)peers.get(suggestedLeaderIndex)).getId() ? 1 : 0) != 0);
        }, (int)10, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS), (String)"testMultiGroupWithPriority", (Logger)LOG);
        RaftClient client = cluster.createClient(newGroup);
        Object object = null;
        try {
            for (int i = 0; i < 10; ++i) {
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assertions.assertTrue((boolean)reply.isSuccess());
            }
        }
        catch (Throwable i) {
            object = i;
            throw i;
        }
        finally {
            if (client != null) {
                if (object != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable i) {
                        ((Throwable)object).addSuppressed(i);
                    }
                } else {
                    client.close();
                }
            }
        }
        BlockRequestHandlingInjection.getInstance().unblockRequestor(suggestedLeader);
        BlockRequestHandlingInjection.getInstance().unblockReplier(suggestedLeader);
        cluster.setBlockRequestsFrom(suggestedLeader, false);
        JavaUtils.attempt(() -> {
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster, newGroup.getGroupId());
            Assertions.assertTrue((leader.getId() == ((RaftPeer)peers.get(suggestedLeaderIndex)).getId() ? 1 : 0) != 0);
        }, (int)10, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS), (String)"testMultiGroupWithPriority", (Logger)LOG);
        int newSuggestedLeaderIndex = (suggestedLeaderIndex + 1) % peersWithPriority.size();
        List<RaftPeer> peersWithNewPriority = RaftTestUtil.getPeersWithPriority(peers, peers.get(newSuggestedLeaderIndex));
        try (RaftClient client2 = cluster.createClient(newGroup);){
            RaftClientReply reply = client2.admin().setConfiguration(peersWithNewPriority.toArray(new RaftPeer[0]));
            Assertions.assertTrue((boolean)reply.isSuccess());
        }
        JavaUtils.attempt(() -> {
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster, newGroup.getGroupId());
            Assertions.assertTrue((leader.getId() == ((RaftPeer)peers.get(newSuggestedLeaderIndex)).getId() ? 1 : 0) != 0);
        }, (int)10, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS), (String)"testMultiGroupWithPriority", (Logger)LOG);
        cluster.killServer(peers.get(newSuggestedLeaderIndex).getId());
        JavaUtils.attempt(() -> {
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster, newGroup.getGroupId());
            Assertions.assertTrue((leader.getId() != ((RaftPeer)peers.get(newSuggestedLeaderIndex)).getId() ? 1 : 0) != 0);
        }, (int)10, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS), (String)"testMultiGroupWithPriority", (Logger)LOG);
        cluster.shutdown();
    }

    @Test
    public void testSingleGroupRestart() throws Exception {
        MiniRaftCluster cluster = this.getCluster(0);
        LOG.info("Start testMultiGroup" + cluster.printServers());
        List<RaftPeerId> ids = Arrays.stream(MiniRaftCluster.generateIds(3, 0)).map(RaftPeerId::valueOf).collect(Collectors.toList());
        ids.forEach(id -> cluster.putNewServer((RaftPeerId)id, null, true));
        LOG.info("putNewServer: " + cluster.printServers());
        cluster.start();
        TimeUnit.SECONDS.sleep(1L);
        LOG.info("start: " + cluster.printServers());
        Assertions.assertNull((Object)cluster.getLeader());
        RaftGroup newGroup = RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), cluster.getPeers());
        LOG.info("add new group: " + newGroup);
        try (RaftClient client = cluster.createClient(newGroup);){
            for (RaftPeer p : newGroup.getPeers()) {
                client.getGroupManagementApi(p.getId()).add(newGroup);
            }
        }
        Assertions.assertNotNull((Object)RaftTestUtil.waitForLeader(cluster));
        TimeUnit.SECONDS.sleep(1L);
        LOG.info("restart servers");
        for (RaftPeer p : newGroup.getPeers()) {
            cluster.restartServer(p.getId(), null, false);
        }
        Assertions.assertNotNull((Object)RaftTestUtil.waitForLeader(cluster));
        cluster.shutdown();
    }

    @Test
    public void testMultiGroup5Nodes() throws Exception {
        int[] idIndex = new int[]{3, 4, 5};
        this.runMultiGroupTest(idIndex, 0);
    }

    @Test
    public void testMultiGroup7Nodes() throws Exception {
        int[] idIndex = new int[]{1, 6, 7};
        this.runMultiGroupTest(idIndex, 1);
    }

    @Test
    public void testMultiGroup9Nodes() throws Exception {
        int[] idIndex = new int[]{5, 8, 9};
        this.runMultiGroupTest(idIndex, 2);
    }

    private void runMultiGroupTest(int[] idIndex, int chosen) throws Exception {
        GroupManagementBaseTest.printThreadCount(null, "init");
        GroupManagementBaseTest.runMultiGroupTest(this.getCluster(0), idIndex, chosen, NOOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> void runMultiGroupTest(MiniRaftCluster cluster, int[] idIndex, int chosen, CheckedBiConsumer<MiniRaftCluster, RaftGroup, T> checker) throws IOException, InterruptedException, T {
        if (chosen < 0) {
            chosen = ThreadLocalRandom.current().nextInt(idIndex.length);
        }
        String type = JavaUtils.getClassSimpleName(cluster.getClass()) + Arrays.toString(idIndex) + "chosen=" + chosen;
        LOG.info("\n\nrunMultiGroupTest with " + type + ": " + cluster.printServers());
        RaftGroup emptyGroup = RaftGroup.valueOf((RaftGroupId)cluster.getGroupId(), (RaftPeer[])new RaftPeer[0]);
        List<RaftPeerId> ids = Arrays.stream(MiniRaftCluster.generateIds(idIndex[idIndex.length - 1], 0)).map(RaftPeerId::valueOf).collect(Collectors.toList());
        LOG.info("ids: " + ids);
        ids.forEach(id -> cluster.putNewServer((RaftPeerId)id, emptyGroup, true));
        LOG.info("putNewServer: " + cluster.printServers());
        TimeUnit.SECONDS.sleep(1L);
        cluster.start();
        TimeUnit.SECONDS.sleep(1L);
        LOG.info("start: " + cluster.printServers());
        Assertions.assertNull((Object)cluster.getLeader());
        try {
            int i;
            List<RaftPeer> allPeers = cluster.getPeers();
            Collections.sort(allPeers, Comparator.comparing(p -> p.getId().toString()));
            RaftGroup[] groups = new RaftGroup[idIndex.length];
            for (i = 0; i < idIndex.length; ++i) {
                RaftGroupId gid = RaftGroupId.randomId();
                int previous = i == 0 ? 0 : idIndex[i - 1];
                RaftPeer[] peers2 = allPeers.subList(previous, idIndex[i]).toArray(RaftPeer.emptyArray());
                groups[i] = RaftGroup.valueOf((RaftGroupId)gid, (RaftPeer[])peers2);
                LOG.info(i + ") starting " + groups[i]);
                for (RaftPeer p2 : peers2) {
                    try (RaftClient client = cluster.createClient(p2.getId(), groups[i]);){
                        client.getGroupManagementApi(p2.getId()).add(groups[i]);
                    }
                }
                Assertions.assertNotNull((Object)RaftTestUtil.waitForLeader(cluster, gid));
                checker.accept((Object)cluster, (Object)groups[i]);
            }
            GroupManagementBaseTest.printThreadCount(type, "start groups");
            LOG.info("start groups: " + cluster.printServers());
            LOG.info("chosen = " + chosen + ", " + groups[chosen]);
            for (i = 0; i < groups.length; ++i) {
                if (i == chosen) continue;
                RaftGroup g = groups[i];
                LOG.info(i + ") close " + cluster.printServers(g.getGroupId()));
                for (RaftPeer p3 : g.getPeers()) {
                    RaftClientReply r;
                    RaftServer.Division d = cluster.getDivision(p3.getId(), g.getGroupId());
                    File root = d.getRaftStorage().getStorageDir().getRoot();
                    Assertions.assertTrue((boolean)root.exists());
                    Assertions.assertTrue((boolean)root.isDirectory());
                    try (RaftClient client = cluster.createClient(p3.getId(), g);){
                        r = client.getGroupManagementApi(p3.getId()).remove(g.getGroupId(), true, false);
                    }
                    Assertions.assertTrue((boolean)r.isSuccess());
                    Assertions.assertFalse((boolean)root.exists());
                }
            }
            GroupManagementBaseTest.printThreadCount(type, "close groups");
            LOG.info("close groups: " + cluster.printServers());
            RaftGroup newGroup = RaftGroup.valueOf((RaftGroupId)groups[chosen].getGroupId(), (RaftPeer[])new RaftPeer[0]);
            for (int i2 = 0; i2 < groups.length; ++i2) {
                if (i2 == chosen) continue;
                LOG.info(i2 + ") groupAdd: " + cluster.printServers(groups[i2].getGroupId()));
                for (RaftPeer p3 : groups[i2].getPeers()) {
                    RaftClient client = cluster.createClient(p3.getId(), groups[i2]);
                    Throwable throwable = null;
                    try {
                        client.getGroupManagementApi(p3.getId()).add(newGroup);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (client == null) continue;
                        if (throwable != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        client.close();
                    }
                }
            }
            LOG.info(chosen + ") setConfiguration: " + cluster.printServers(groups[chosen].getGroupId()));
            try (RaftClient client = cluster.createClient(groups[chosen]);){
                RaftServerTestUtil.runWithMinorityPeers(cluster, allPeers, (CheckedConsumer<List<RaftPeer>, IOException>)((CheckedConsumer)peers -> client.admin().setConfiguration(peers.toArray(RaftPeer.emptyArray()))));
            }
            Assertions.assertNotNull((Object)RaftTestUtil.waitForLeader(cluster));
            checker.accept((Object)cluster, (Object)groups[chosen]);
            LOG.info("update groups: " + cluster.printServers());
            GroupManagementBaseTest.printThreadCount(type, "update groups");
        }
        finally {
            cluster.shutdown();
            GroupManagementBaseTest.printThreadCount(type, "shutdown");
        }
    }

    static void printThreadCount(String type, String label) {
        System.out.println("| " + type + " | " + label + " | " + JavaUtils.getRootThreadGroup().activeCount() + " |");
    }

    @Test
    public void testGroupAlreadyExists() throws Exception {
        MiniRaftCluster cluster = this.getCluster(1);
        cluster.start();
        RaftPeer peer = cluster.getPeers().get(0);
        RaftPeerId peerId = peer.getId();
        RaftGroup group = RaftGroup.valueOf((RaftGroupId)cluster.getGroupId(), (RaftPeer[])new RaftPeer[]{peer});
        try (RaftClient client = cluster.createClient();){
            Assertions.assertEquals((Object)group, (Object)cluster.getDivision(peerId).getGroup());
            try {
                client.getGroupManagementApi(peer.getId()).add(group);
            }
            catch (IOException ex) {
                Assertions.assertTrue((boolean)ex.toString().contains(AlreadyExistsException.class.getCanonicalName()));
            }
            Assertions.assertEquals((Object)group, (Object)cluster.getDivision(peerId).getGroup());
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupRemoveWhenRename() throws Exception {
        MiniRaftCluster cluster1 = this.getCluster(1);
        RaftServerConfigKeys.setRemovedGroupsDir((RaftProperties)cluster1.getProperties(), (File)Files.createTempDirectory("groups", new FileAttribute[0]).toFile());
        MiniRaftCluster cluster2 = this.getCluster(3);
        cluster1.start();
        RaftPeer peer1 = cluster1.getPeers().get(0);
        RaftPeerId peerId1 = peer1.getId();
        RaftGroup group1 = RaftGroup.valueOf((RaftGroupId)cluster1.getGroupId(), (RaftPeer[])new RaftPeer[]{peer1});
        RaftGroup group2 = RaftGroup.valueOf((RaftGroupId)cluster2.getGroupId(), (RaftPeer[])new RaftPeer[]{peer1});
        try (RaftClient client = cluster1.createClient();){
            Assertions.assertEquals((Object)group1, (Object)cluster1.getDivision(peerId1).getGroup());
            try {
                GroupManagementApi api1 = client.getGroupManagementApi(peerId1);
                api1.add(group2);
                List groupIds1 = cluster1.getServer(peerId1).getGroupIds();
                Assertions.assertEquals((int)groupIds1.size(), (int)2);
                api1.remove(group2.getGroupId(), false, true);
                groupIds1 = cluster1.getServer(peerId1).getGroupIds();
                Assertions.assertEquals((int)groupIds1.size(), (int)1);
                cluster1.restart(false);
                List groupIdsAfterRestart = cluster1.getServer(peerId1).getGroupIds();
                Assertions.assertEquals((int)groupIds1.size(), (int)groupIdsAfterRestart.size());
                File renamedGroup = new File(RaftServerConfigKeys.removedGroupsDir((RaftProperties)cluster1.getProperties()), group2.getGroupId().getUuid().toString());
                Assertions.assertTrue((boolean)renamedGroup.isDirectory());
            }
            catch (IOException ex) {
                Assertions.fail();
            }
            finally {
                cluster1.shutdown();
                FileUtils.deleteFully((File)RaftServerConfigKeys.removedGroupsDir((RaftProperties)cluster1.getProperties()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupRemoveWhenDelete() throws Exception {
        MiniRaftCluster cluster1 = this.getCluster(1);
        RaftServerConfigKeys.setRemovedGroupsDir((RaftProperties)cluster1.getProperties(), (File)Files.createTempDirectory("groups", new FileAttribute[0]).toFile());
        MiniRaftCluster cluster2 = this.getCluster(3);
        cluster1.start();
        RaftPeer peer1 = cluster1.getPeers().get(0);
        RaftPeerId peerId1 = peer1.getId();
        RaftGroup group1 = RaftGroup.valueOf((RaftGroupId)cluster1.getGroupId(), (RaftPeer[])new RaftPeer[]{peer1});
        RaftGroup group2 = RaftGroup.valueOf((RaftGroupId)cluster2.getGroupId(), (RaftPeer[])new RaftPeer[]{peer1});
        try (RaftClient client = cluster1.createClient();){
            Assertions.assertEquals((Object)group1, (Object)cluster1.getDivision(peerId1).getGroup());
            try {
                GroupManagementApi api1 = client.getGroupManagementApi(peerId1);
                api1.add(group2);
                List groupIds1 = cluster1.getServer(peerId1).getGroupIds();
                Assertions.assertEquals((int)groupIds1.size(), (int)2);
                api1.remove(group2.getGroupId(), true, false);
                groupIds1 = cluster1.getServer(peerId1).getGroupIds();
                Assertions.assertEquals((int)groupIds1.size(), (int)1);
                cluster1.restart(false);
                List groupIdsAfterRestart = cluster1.getServer(peerId1).getGroupIds();
                Assertions.assertEquals((int)groupIds1.size(), (int)groupIdsAfterRestart.size());
            }
            catch (IOException ex) {
                Assertions.fail();
            }
            finally {
                cluster1.shutdown();
                FileUtils.deleteFully((File)RaftServerConfigKeys.removedGroupsDir((RaftProperties)cluster1.getProperties()));
            }
        }
    }

    static {
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)PROP, (TimeDuration)TimeDuration.valueOf((long)1500L, (TimeUnit)TimeUnit.MILLISECONDS));
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)PROP, (TimeDuration)TimeDuration.valueOf((long)2000L, (TimeUnit)TimeUnit.MILLISECONDS));
        RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)PROP, (TimeDuration)TimeDuration.valueOf((long)12L, (TimeUnit)TimeUnit.SECONDS));
        NOOP = (c, g) -> {};
    }
}

