/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.ratis.protocol.RaftPeer;

public class PeerChanges {
    private final List<RaftPeer> peersInNewConf;
    private final List<RaftPeer> addedPeers;
    private final List<RaftPeer> removedPeers;

    PeerChanges(List<RaftPeer> all, List<RaftPeer> addedPeers, List<RaftPeer> removed) {
        this.peersInNewConf = Collections.unmodifiableList(all);
        this.addedPeers = Collections.unmodifiableList(addedPeers);
        this.removedPeers = Collections.unmodifiableList(removed);
    }

    public List<RaftPeer> getPeersInNewConf() {
        return this.peersInNewConf;
    }

    public List<RaftPeer> getAddedPeers() {
        return this.addedPeers;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PeerChanges)) {
            return false;
        }
        PeerChanges that = (PeerChanges)obj;
        return Objects.equals(this.peersInNewConf, that.peersInNewConf) && Objects.equals(this.addedPeers, that.addedPeers) && Objects.equals(this.removedPeers, that.removedPeers);
    }

    public int hashCode() {
        return Objects.hashCode(this.peersInNewConf);
    }

    public String toString() {
        return "PeerChanges{\n  newConf=" + this.peersInNewConf + "\n    added=" + this.addedPeers + "\n  removed=" + this.removedPeers + "\n}";
    }
}

