/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.DataStreamMap;
import org.apache.ratis.server.DataStreamServer;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.ConfigurationManager;
import org.apache.ratis.server.impl.DataStreamMapImpl;
import org.apache.ratis.server.impl.DataStreamServerImpl;
import org.apache.ratis.server.impl.DelayLocalExecutionInjection;
import org.apache.ratis.server.impl.FollowerState;
import org.apache.ratis.server.impl.LeaderStateImpl;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.impl.StateMachineUpdater;
import org.apache.ratis.server.impl.TransactionManager;
import org.apache.ratis.server.impl.WatchRequests;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLog;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedConsumer;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class RaftServerTestUtil {
    static final Logger LOG = LoggerFactory.getLogger(RaftServerTestUtil.class);
    public static final RaftGroupMemberId TEST_MEMBER_ID = RaftGroupMemberId.valueOf((RaftPeerId)RaftPeerId.valueOf((String)"test"), (RaftGroupId)RaftGroupId.emptyGroupId());

    private RaftServerTestUtil() {
    }

    public static DelayLocalExecutionInjection getLogSyncDelay() {
        return new DelayLocalExecutionInjection(RaftServerImpl.LOG_SYNC);
    }

    public static void setStateMachineUpdaterLogLevel(Level level) {
        Slf4jUtils.setLogLevel((Logger)StateMachineUpdater.LOG, (Level)level);
    }

    public static void setWatchRequestsLogLevel(Level level) {
        Slf4jUtils.setLogLevel((Logger)WatchRequests.LOG, (Level)level);
    }

    public static void setPendingRequestsLogLevel(Level level) {
        Slf4jUtils.setLogLevel((Logger)PendingRequests.LOG, (Level)level);
    }

    public static void waitAndCheckNewConf(MiniRaftCluster cluster, List<RaftPeer> peers, int numOfNewPeers, int numOfRemovedPeers, Collection<RaftPeerId> deadPeers) throws Exception {
        TimeDuration sleepTime = cluster.getTimeoutMax().apply(n -> n * (long)(numOfRemovedPeers + numOfNewPeers + 2));
        JavaUtils.attempt(() -> RaftServerTestUtil.waitAndCheckNewConf(cluster, peers, deadPeers), (int)10, (TimeDuration)sleepTime, (String)"waitAndCheckNewConf", (Logger)LOG);
    }

    public static void waitAndCheckNewConf(MiniRaftCluster cluster, List<RaftPeer> peers, int numOfRemovedPeers, Collection<RaftPeerId> deadPeers) throws Exception {
        TimeDuration sleepTime = cluster.getTimeoutMax().apply(n -> n * (long)(numOfRemovedPeers + 2));
        JavaUtils.attempt(() -> RaftServerTestUtil.waitAndCheckNewConf(cluster, peers, deadPeers), (int)10, (TimeDuration)sleepTime, (String)"waitAndCheckNewConf", (Logger)LOG);
    }

    private static void waitAndCheckNewConf(MiniRaftCluster cluster, Collection<RaftPeer> peers, Collection<RaftPeerId> deadPeers) {
        LOG.info("waitAndCheckNewConf: peers={}, deadPeers={}, {}", new Object[]{peers, deadPeers, cluster.printServers()});
        Assertions.assertNotNull((Object)cluster.getLeader());
        int numIncluded = 0;
        int deadIncluded = 0;
        RaftConfigurationImpl current = RaftConfigurationImpl.newBuilder().setConf(peers).setLogEntryIndex(0L).build();
        for (RaftServer.Division d : cluster.iterateDivisions()) {
            RaftServerImpl server = (RaftServerImpl)d;
            LOG.info("checking {}", (Object)server);
            if (deadPeers != null && deadPeers.contains(server.getId())) {
                if (!current.containsInConf(server.getId(), new RaftProtos.RaftPeerRole[0])) continue;
                ++deadIncluded;
                continue;
            }
            RaftConfigurationImpl conf = server.getState().getRaftConf();
            if (current.containsInConf(server.getId(), new RaftProtos.RaftPeerRole[0])) {
                ++numIncluded;
                Assertions.assertTrue((boolean)conf.isStable());
                Assertions.assertTrue((boolean)conf.hasNoChange(peers, Collections.emptyList()));
                continue;
            }
            if (!server.getInfo().isAlive()) continue;
            Assertions.assertTrue((boolean)conf.isStable());
            Assertions.assertFalse((boolean)conf.containsInConf(server.getId(), new RaftProtos.RaftPeerRole[0]));
        }
        Assertions.assertEquals((int)peers.size(), (int)(numIncluded + deadIncluded));
    }

    public static long getNextIndex(RaftServer.Division server) {
        return ((RaftServerImpl)server).getState().getNextIndex();
    }

    public static long getLatestInstalledSnapshotIndex(RaftServer.Division server) {
        return ((RaftServerImpl)server).getState().getLatestInstalledSnapshotIndex();
    }

    static ServerState getState(RaftServer.Division server) {
        return ((RaftServerImpl)server).getState();
    }

    public static ConfigurationManager getConfigurationManager(RaftServer.Division server) {
        return (ConfigurationManager)RaftTestUtil.getDeclaredField(RaftServerTestUtil.getState(server), "configurationManager");
    }

    public static Logger getTransactionContextLog() {
        return TransactionManager.LOG;
    }

    public static Map<TermIndex, MemoizedSupplier<TransactionContext>> getTransactionContextMap(RaftServer.Division server) {
        return ((RaftServerImpl)server).getTransactionContextMapForTesting();
    }

    public static RaftConfiguration newRaftConfiguration(Collection<RaftPeer> peers) {
        return RaftConfigurationImpl.newBuilder().setConf(peers).build();
    }

    public static void setRaftConf(RaftServer proxy, RaftGroupId groupId, RaftConfiguration conf) {
        ((RaftServerImpl)RaftServerTestUtil.getDivision(proxy, groupId)).getState().setRaftConf(conf);
    }

    public static RaftServerRpc getServerRpc(RaftServer.Division server) {
        return ((RaftServerImpl)server).getRaftServer().getServerRpc();
    }

    private static Optional<LeaderStateImpl> getLeaderState(RaftServer.Division server) {
        return ((RaftServerImpl)server).getRole().getLeaderState();
    }

    public static Stream<LogAppender> getLogAppenders(RaftServer.Division server) {
        return RaftServerTestUtil.getLeaderState(server).map(LeaderStateImpl::getLogAppenders).orElse(null);
    }

    public static void assertLeaderLease(RaftServer.Division leader, boolean hasLease) {
        LeaderStateImpl l = RaftServerTestUtil.getLeaderState(leader).orElse(null);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((Object)l.hasLease(), (Object)hasLease);
    }

    public static void restartLogAppenders(RaftServer.Division server) {
        LeaderStateImpl leaderState = RaftServerTestUtil.getLeaderState(server).orElseThrow(() -> new IllegalStateException(server + " is not the leader"));
        leaderState.getLogAppenders().forEach(arg_0 -> ((LeaderStateImpl)leaderState).restart(arg_0));
    }

    public static RaftServer.Division getDivision(RaftServer server, RaftGroupId groupId) {
        return (RaftServer.Division)JavaUtils.callAsUnchecked(() -> server.getDivision(groupId));
    }

    public static DataStreamServer newDataStreamServer(RaftServer server) {
        return new DataStreamServerImpl(server, null);
    }

    public static DataStreamMap newDataStreamMap(Object name) {
        return new DataStreamMapImpl(name);
    }

    public static void assertLostMajorityHeartbeatsRecently(RaftServer.Division leader) {
        FollowerState f = ((RaftServerImpl)leader).getRole().getFollowerState().orElse(null);
        Assertions.assertNotNull((Object)f);
        Assertions.assertTrue((boolean)f.lostMajorityHeartbeatsRecently());
    }

    public static SegmentedRaftLog newSegmentedRaftLog(RaftGroupMemberId memberId, DivisionInfo info, RaftStorage storage, RaftProperties properties) {
        RaftServerImpl server = (RaftServerImpl)Mockito.mock(RaftServerImpl.class);
        Mockito.when((Object)server.getInfo()).thenReturn((Object)info);
        return SegmentedRaftLog.newBuilder().setMemberId(memberId).setServer((RaftServer.Division)server).setNotifyTruncatedLogEntry(arg_0 -> ((RaftServerImpl)server).notifyTruncatedLogEntry(arg_0)).setGetTransactionContext((arg_0, arg_1) -> ((RaftServerImpl)server).getTransactionContext(arg_0, arg_1)).setSubmitUpdateCommitEvent(() -> ((RaftServerImpl)server).submitUpdateCommitEvent()).setStorage(storage).setProperties(properties).build();
    }

    public static boolean isHighestPriority(RaftConfiguration config, RaftPeerId peerId) {
        return ((RaftConfigurationImpl)config).isHighestPriority(peerId);
    }

    public static void runWithMinorityPeers(MiniRaftCluster cluster, List<RaftPeer> peersInNewConf, CheckedConsumer<List<RaftPeer>, IOException> consumer) throws IOException {
        List<RaftPeer> peers = RaftServerTestUtil.parseMinorityPeers(cluster, peersInNewConf);
        while (peers != null) {
            consumer.accept(peers);
            peers = RaftServerTestUtil.parseMinorityPeers(cluster, peersInNewConf);
        }
    }

    private static List<RaftPeer> parseMinorityPeers(MiniRaftCluster cluster, List<RaftPeer> peersInNewConf) {
        RaftConfigurationImpl conf = (RaftConfigurationImpl)cluster.getLeader().getRaftConf();
        HashSet<RaftPeer> peers = new HashSet<RaftPeer>(conf.getCurrentPeers());
        List peersToAdd = peersInNewConf.stream().filter(peer -> !conf.containsInConf(peer.getId(), new RaftProtos.RaftPeerRole[]{RaftProtos.RaftPeerRole.FOLLOWER})).collect(Collectors.toList());
        if (!peersToAdd.isEmpty()) {
            for (RaftPeer peer2 : peersToAdd) {
                if (!peers.add(peer2) || !conf.changeMajority(peers)) continue;
                peers.remove(peer2);
                break;
            }
            return new ArrayList<RaftPeer>(peers);
        }
        List peersToRemove = peers.stream().filter(peer -> !peersInNewConf.contains(peer)).collect(Collectors.toList());
        if (!peersToRemove.isEmpty()) {
            return peersInNewConf;
        }
        return null;
    }
}

