/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.metrics.LongCounter;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.impl.DefaultTimekeeperImpl;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.PeerChanges;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.segmented.LogSegmentPath;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.thirdparty.com.codahale.metrics.Timer;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class RaftSnapshotBaseTest<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    static final Logger LOG = LoggerFactory.getLogger(RaftSnapshotBaseTest.class);
    private static final int SNAPSHOT_TRIGGER_THRESHOLD = 10;

    public RaftSnapshotBaseTest() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.DEBUG);
        RaftProperties p = this.getProperties();
        p.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)p, (long)10L);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)p, (boolean)true);
        RaftServerConfigKeys.LeaderElection.setMemberMajorityAdd((RaftProperties)p, (boolean)true);
    }

    public static List<File> getSnapshotFiles(MiniRaftCluster cluster, long startIndex, long endIndex) {
        RaftServer.Division leader = cluster.getLeader();
        SimpleStateMachineStorage storage = SimpleStateMachine4Testing.get(leader).getStateMachineStorage();
        long term = leader.getInfo().getCurrentTerm();
        return LongStream.range(startIndex, endIndex).mapToObj(i -> storage.getSnapshotFile(term, i)).collect(Collectors.toList());
    }

    public static void assertLeaderContent(MiniRaftCluster cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        RaftSnapshotBaseTest.assertLogContent(leader, true);
    }

    public static void checkMetadataEntry(RaftServer.Division server) throws Exception {
        RaftLog log = server.getRaftLog();
        long lastIndex = log.getLastEntryTermIndex().getIndex();
        RaftProtos.LogEntryProto e = log.get(lastIndex);
        Assertions.assertTrue((boolean)e.hasMetadataEntry());
        Assertions.assertEquals((long)(log.getLastCommittedIndex() - 1L), (long)e.getMetadataEntry().getCommitIndex());
    }

    public static void assertLogContent(RaftServer.Division server, boolean isLeader) throws Exception {
        JavaUtils.attempt(() -> RaftSnapshotBaseTest.checkMetadataEntry(server), (int)50, (TimeDuration)HUNDRED_MILLIS, (String)"checkMetadataEntry", (Logger)LOG);
        SimpleStateMachine4Testing simpleStateMachine = SimpleStateMachine4Testing.get(server);
        if (isLeader) {
            Assertions.assertTrue((boolean)simpleStateMachine.isNotifiedAsLeader(), (String)"Not notified as a leader");
        }
        RaftProtos.LogEntryProto[] entries = simpleStateMachine.getContent();
        long message = 0L;
        for (int i = 0; i < entries.length; ++i) {
            LOG.info("{}) {} {}", new Object[]{i, message, entries[i].toString().replace("\n", ", ")});
            if (!entries[i].hasStateMachineLogEntry()) continue;
            RaftTestUtil.SimpleMessage m = new RaftTestUtil.SimpleMessage("m" + message++);
            Assertions.assertArrayEquals((byte[])m.getContent().toByteArray(), (byte[])entries[i].getStateMachineLogEntry().getLogData().toByteArray());
        }
    }

    @Test
    public void testRestartPeer() throws Exception {
        this.runWithNewCluster(1, this::runTestRestartPeer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestRestartPeer(CLUSTER cluster) throws Exception {
        LOG.info("runTestRestartPeer");
        RaftPeerId leaderId = RaftTestUtil.waitForLeader(cluster).getId();
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
            for (int i = 0; i < 19; ++i) {
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assertions.assertTrue((boolean)reply.isSuccess());
            }
        }
        long nextIndex = ((MiniRaftCluster)cluster).getLeader().getRaftLog().getNextIndex();
        LOG.info("nextIndex = {}", (Object)nextIndex);
        List<File> snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, nextIndex - 10L, nextIndex);
        JavaUtils.attemptRepeatedly(() -> {
            Assertions.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
            return null;
        }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
        ((MiniRaftCluster)cluster).restart(false);
        try {
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
        }
        finally {
            ((MiniRaftCluster)cluster).shutdown();
        }
    }

    public static boolean exists(File f) {
        if (f.exists()) {
            LOG.info("File exists: {}", (Object)f);
            return true;
        }
        return false;
    }

    @Test
    public void testBasicInstallSnapshot() throws Exception {
        this.runWithNewCluster(1, this::runTestBasicInstallSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestBasicInstallSnapshot(CLUSTER cluster) throws Exception {
        List logs;
        int i;
        LOG.info("runTestBasicInstallSnapshot");
        try {
            RaftPeerId leaderId = RaftTestUtil.waitForLeader(cluster).getId();
            try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
                for (i = 0; i < 19; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assertions.assertTrue((boolean)reply.isSuccess());
                }
            }
            long nextIndex = ((MiniRaftCluster)cluster).getLeader().getRaftLog().getNextIndex();
            LOG.info("nextIndex = {}", (Object)nextIndex);
            List<File> snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, nextIndex - 10L, nextIndex);
            JavaUtils.attemptRepeatedly(() -> {
                Assertions.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
                return null;
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
            RaftSnapshotBaseTest.verifyTakeSnapshotMetric(((MiniRaftCluster)cluster).getLeader());
            logs = LogSegmentPath.getLogSegmentPaths((RaftStorage)((MiniRaftCluster)cluster).getLeader().getRaftStorage());
        }
        finally {
            ((MiniRaftCluster)cluster).shutdown();
        }
        for (LogSegmentPath path : logs) {
            FileUtils.delete((Path)path.getPath());
        }
        LOG.info("Restarting the cluster");
        ((MiniRaftCluster)cluster).restart(false);
        try {
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
            RaftClient client = ((MiniRaftCluster)cluster).createClient(((MiniRaftCluster)cluster).getLeader().getId());
            Object path = null;
            try {
                Assertions.assertTrue((boolean)client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i)).isSuccess());
            }
            catch (Throwable throwable) {
                path = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (path != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)path).addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            PeerChanges change = ((MiniRaftCluster)cluster).addNewPeers(1, true);
            RaftServerTestUtil.runWithMinorityPeers(cluster, change.getPeersInNewConf(), (CheckedConsumer<List<RaftPeer>, IOException>)((CheckedConsumer)arg_0 -> cluster.setConfiguration(arg_0)));
            for (RaftPeer newPeer : change.getAddedPeers()) {
                RaftServer.Division s = ((MiniRaftCluster)cluster).getDivision(newPeer.getId());
                SimpleStateMachine4Testing simpleStateMachine = SimpleStateMachine4Testing.get(s);
                Assertions.assertSame((Object)LifeCycle.State.RUNNING, (Object)simpleStateMachine.getLifeCycleState());
            }
            this.verifyInstallSnapshotMetric(((MiniRaftCluster)cluster).getLeader());
            RaftServerTestUtil.waitAndCheckNewConf(cluster, change.getPeersInNewConf(), 0, null);
            Timer timer = RaftSnapshotBaseTest.getTakeSnapshotTimer(((MiniRaftCluster)cluster).getLeader());
            long count = timer.getCount();
            ((MiniRaftCluster)cluster).restartServer(((MiniRaftCluster)cluster).getLeader().getId(), false);
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
            Assertions.assertTrue((count < timer.getCount() ? 1 : 0) != 0);
        }
        finally {
            ((MiniRaftCluster)cluster).shutdown();
        }
    }

    @Test
    public void testInstallSnapshotDuringBootstrap() throws Exception {
        this.runWithNewCluster(1, this::runTestInstallSnapshotDuringBootstrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestInstallSnapshotDuringBootstrap(CLUSTER cluster) throws Exception {
        LOG.info("runTestInstallSnapshotDuringBootstrap");
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = ((MiniRaftCluster)cluster).getLeader().getId();
            try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
                for (int i = 0; i < 19; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assertions.assertTrue((boolean)reply.isSuccess());
                }
            }
            long nextIndex = ((MiniRaftCluster)cluster).getLeader().getRaftLog().getNextIndex();
            LOG.info("nextIndex = {}", (Object)nextIndex);
            List<File> snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, nextIndex - 10L, nextIndex);
            JavaUtils.attemptRepeatedly(() -> {
                Assertions.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
                return null;
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
            RaftSnapshotBaseTest.verifyTakeSnapshotMetric(((MiniRaftCluster)cluster).getLeader());
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
            PeerChanges change = ((MiniRaftCluster)cluster).addNewPeers(1, true);
            RaftServerTestUtil.runWithMinorityPeers(cluster, change.getPeersInNewConf(), (CheckedConsumer<List<RaftPeer>, IOException>)((CheckedConsumer)arg_0 -> cluster.setConfiguration(arg_0)));
            for (RaftPeer newPeer : change.getAddedPeers()) {
                RaftServer.Division s = ((MiniRaftCluster)cluster).getDivision(newPeer.getId());
                SimpleStateMachine4Testing simpleStateMachine = SimpleStateMachine4Testing.get(s);
                Assertions.assertSame((Object)LifeCycle.State.RUNNING, (Object)simpleStateMachine.getLifeCycleState());
            }
            this.verifyInstallSnapshotMetric(((MiniRaftCluster)cluster).getLeader());
            RaftServerTestUtil.waitAndCheckNewConf(cluster, change.getPeersInNewConf(), 0, null);
        }
        finally {
            ((MiniRaftCluster)cluster).shutdown();
        }
    }

    protected void verifyInstallSnapshotMetric(RaftServer.Division leader) {
        LongCounter installSnapshotCounter = ((RaftServerMetricsImpl)leader.getRaftServerMetrics()).getNumInstallSnapshot();
        Assertions.assertNotNull((Object)installSnapshotCounter);
        Assertions.assertTrue((installSnapshotCounter.getCount() >= 1L ? 1 : 0) != 0);
    }

    private static void verifyTakeSnapshotMetric(RaftServer.Division leader) {
        Timer timer = RaftSnapshotBaseTest.getTakeSnapshotTimer(leader);
        Assertions.assertTrue((timer.getCount() > 0L ? 1 : 0) != 0);
    }

    private static Timer getTakeSnapshotTimer(RaftServer.Division leader) {
        MetricRegistryInfo info = new MetricRegistryInfo(leader.getMemberId().toString(), "ratis", "state_machine", "Metrics for State Machine Updater");
        Optional opt = MetricRegistries.global().get(info);
        Assertions.assertTrue((boolean)opt.isPresent());
        RatisMetricRegistry metricRegistry = (RatisMetricRegistry)opt.get();
        Assertions.assertNotNull((Object)metricRegistry);
        return ((DefaultTimekeeperImpl)metricRegistry.timer("takeSnapshot")).getTimer();
    }
}

