/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.client.impl.OrderedAsync;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLog;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class RaftLogTruncateTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public static final int NUM_SERVERS = 5;
    final TimeDuration MIN_TIMEOUT = TimeDuration.valueOf((long)3L, (TimeUnit)TimeUnit.SECONDS);

    public RaftLogTruncateTests() {
        Slf4jUtils.setLogLevel((Logger)RaftServerTestUtil.getTransactionContextLog(), (Level)Level.TRACE);
        Slf4jUtils.setLogLevel((Logger)OrderedAsync.LOG, (Level)Level.ERROR);
        Slf4jUtils.setLogLevel((Logger)RaftServerConfigKeys.LOG, (Level)Level.ERROR);
        Slf4jUtils.setLogLevel((Logger)RaftClientConfigKeys.LOG, (Level)Level.ERROR);
        Slf4jUtils.setLogLevel((Logger)RaftClientConfigKeys.LOG, (Level)Level.ERROR);
        RaftProperties p = this.getProperties();
        p.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)p, (TimeDuration)this.MIN_TIMEOUT);
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)p, (TimeDuration)this.MIN_TIMEOUT.multiply(2.0));
        RaftServerConfigKeys.Rpc.setFirstElectionTimeoutMin((RaftProperties)p, (TimeDuration)TimeDuration.ONE_SECOND);
        RaftServerConfigKeys.Rpc.setFirstElectionTimeoutMax((RaftProperties)p, (TimeDuration)TimeDuration.ONE_SECOND.multiply(2.0));
    }

    static RaftTestUtil.SimpleMessage[] arraycopy(RaftTestUtil.SimpleMessage[] src1, RaftTestUtil.SimpleMessage[] src2) {
        RaftTestUtil.SimpleMessage[] dst = new RaftTestUtil.SimpleMessage[src1.length + src2.length];
        System.arraycopy(src1, 0, dst, 0, src1.length);
        System.arraycopy(src2, 0, dst, src1.length, src2.length);
        return dst;
    }

    public int getGlobalTimeoutSeconds() {
        return 200;
    }

    @Test
    public void testLogTruncate() throws Exception {
        this.runWithNewCluster(5, this::runTestLogTruncate);
    }

    void runTestLogTruncate(MiniRaftCluster cluster) throws Exception {
        int i;
        RaftServer.Division oldLeader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        List oldFollowers = cluster.getFollowers();
        ArrayList<RaftPeerId> killedPeers = new ArrayList<RaftPeerId>();
        ArrayList<RaftPeerId> remainingPeers = new ArrayList<RaftPeerId>();
        int majorityIndex = 3;
        Assertions.assertEquals((int)4, (int)oldFollowers.size());
        Assertions.assertTrue((3 < oldFollowers.size() ? 1 : 0) != 0);
        for (i = 0; i < 3; ++i) {
            killedPeers.add(((RaftServer.Division)oldFollowers.get(i)).getId());
        }
        remainingPeers.add(oldLeader.getId());
        for (i = 3; i < oldFollowers.size(); ++i) {
            remainingPeers.add(((RaftServer.Division)oldFollowers.get(i)).getId());
        }
        try {
            this.runTestLogTruncate(cluster, oldLeader, killedPeers, remainingPeers);
        }
        catch (Throwable e) {
            this.LOG.info("killedPeers   : {}", killedPeers);
            this.LOG.info("remainingPeers: {}", remainingPeers);
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    void runTestLogTruncate(MiniRaftCluster cluster, RaftServer.Division oldLeader, List<RaftPeerId> killedPeers, List<RaftPeerId> remainingPeers) throws Exception {
        Object expectedMessages;
        Object peer22;
        List exceptions = Collections.synchronizedList(new ArrayList());
        long oldLeaderTerm = oldLeader.getInfo().getCurrentTerm();
        this.LOG.info("oldLeader: {}, term={}", (Object)oldLeader.getId(), (Object)oldLeaderTerm);
        this.LOG.info("killedPeers   : {}", killedPeers);
        this.LOG.info("remainingPeers: {}", remainingPeers);
        RaftTestUtil.SimpleMessage[] firstBatch = RaftTestUtil.SimpleMessage.create((int)5, (String)"first");
        RaftTestUtil.SimpleMessage[] secondBatch = RaftTestUtil.SimpleMessage.create((int)4, (String)"second");
        for (Object peer22 : cluster.getGroup().getPeers()) {
            RaftLogTruncateTests.assertEmptyTransactionContextMap(cluster.getDivision(peer22.getId()));
        }
        RaftClient client = cluster.createClient(oldLeader.getId());
        peer22 = null;
        try {
            for (RaftTestUtil.SimpleMessage simpleMessage : firstBatch) {
                RaftClientReply reply = client.io().send((Message)simpleMessage);
                Assertions.assertTrue((boolean)reply.isSuccess());
            }
            for (RaftPeer peer3 : cluster.getGroup().getPeers()) {
                RaftServer.Division division = cluster.getDivision(peer3.getId());
                this.assertLogEntries(division, oldLeaderTerm, firstBatch);
                RaftLogTruncateTests.assertEmptyTransactionContextMap(division);
            }
            this.LOG.info("Before killServer {}: {}", killedPeers, (Object)cluster.printServers());
            for (RaftPeerId f2 : killedPeers) {
                cluster.killServer(f2);
            }
            this.LOG.info("After killServer {}: {}", killedPeers, (Object)cluster.printServers());
            RaftTestUtil.SimpleMessage[] messagesToBeTruncated = RaftTestUtil.SimpleMessage.create((int)3, (String)"messagesToBeTruncated");
            AtomicBoolean done = new AtomicBoolean();
            for (RaftTestUtil.SimpleMessage message : messagesToBeTruncated) {
                client.async().send((Message)message).whenComplete((r, e) -> {
                    if (!done.get()) {
                        exceptions.add(new IllegalStateException(message + " is completed: reply=" + r, (Throwable)e));
                    }
                });
            }
            expectedMessages = RaftLogTruncateTests.arraycopy(firstBatch, messagesToBeTruncated);
            for (RaftPeerId f3 : remainingPeers) {
                RaftServer.Division division = cluster.getDivision(f3);
                this.assertLogEntries(division, oldLeaderTerm, (RaftTestUtil.SimpleMessage[])expectedMessages);
                if (division.getId().equals((Object)oldLeader.getId())) continue;
                RaftLogTruncateTests.assertEntriesInTransactionContextMap(division, messagesToBeTruncated, firstBatch);
            }
            done.set(true);
            this.LOG.info("done");
        }
        catch (Throwable throwable) {
            peer22 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (peer22 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)peer22).addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
        this.LOG.info("Before killServer {}: {}", remainingPeers, (Object)cluster.printServers());
        for (RaftPeerId p : remainingPeers) {
            cluster.killServer(p);
        }
        this.LOG.info("After killServer {}: {}", remainingPeers, (Object)cluster.printServers());
        for (RaftPeerId f4 : killedPeers) {
            cluster.restartServer(f4, false);
        }
        RaftServer.Division newLeader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        this.LOG.info("After restartServer {}: {}", killedPeers, (Object)cluster.printServers());
        long newLeaderTerm = newLeader.getInfo().getCurrentTerm();
        SegmentedRaftLog newLeaderLog = (SegmentedRaftLog)newLeader.getRaftLog();
        this.LOG.info("newLeader: {}, term {}, last={}", new Object[]{newLeader.getId(), newLeaderTerm, newLeaderLog.getLastEntryTermIndex()});
        Assertions.assertTrue((boolean)killedPeers.contains(newLeader.getId()));
        for (RaftPeerId raftPeerId : remainingPeers) {
            cluster.restartServer(raftPeerId, false);
        }
        for (RaftPeerId raftPeerId : remainingPeers) {
            this.assertLogEntries(cluster.getDivision(raftPeerId), oldLeaderTerm, firstBatch);
        }
        Throwable throwable = null;
        try (RaftClient client2 = cluster.createClient(newLeader.getId());){
            for (RaftTestUtil.SimpleMessage batch : secondBatch) {
                RaftClientReply reply = client2.io().send((Message)batch);
                Assertions.assertTrue((boolean)reply.isSuccess());
            }
        }
        catch (Throwable f3) {
            Throwable throwable2 = f3;
            throw f3;
        }
        expectedMessages = RaftLogTruncateTests.arraycopy(firstBatch, secondBatch);
        for (RaftPeer peer4 : cluster.getGroup().getPeers()) {
            RaftServer.Division division = cluster.getDivision(peer4.getId());
            this.assertLogEntries(division, oldLeaderTerm, (RaftTestUtil.SimpleMessage[])expectedMessages);
            String name = "assertEmptyTransactionContextMap:" + division.getId();
            JavaUtils.attempt(() -> RaftLogTruncateTests.assertEmptyTransactionContextMap(division), (int)10, (TimeDuration)HUNDRED_MILLIS, (String)name, (Logger)this.LOG);
        }
        if (!exceptions.isEmpty()) {
            void var15_33;
            this.LOG.info("{} exceptions", (Object)exceptions.size());
            boolean bl = false;
            while (var15_33 < exceptions.size()) {
                this.LOG.info("exception {})", (Object)((int)var15_33), exceptions.get((int)var15_33));
                ++var15_33;
            }
            Assertions.fail();
        }
    }

    static void assertEmptyTransactionContextMap(RaftServer.Division d) {
        Map map = RaftServerTestUtil.getTransactionContextMap((RaftServer.Division)d);
        Assertions.assertTrue((boolean)map.isEmpty(), () -> d.getId() + " TransactionContextMap is non-empty: " + map);
    }

    static void assertEntriesInTransactionContextMap(RaftServer.Division division, RaftTestUtil.SimpleMessage[] existing, RaftTestUtil.SimpleMessage[] nonExisting) {
        RaftLog log = division.getRaftLog();
        RaftLogTruncateTests.assertEntriesInTransactionContextMap(division, RaftTestUtil.getStateMachineLogEntries((RaftLog)log, (RaftTestUtil.SimpleMessage[])existing).values(), RaftTestUtil.getStateMachineLogEntries((RaftLog)log, (RaftTestUtil.SimpleMessage[])nonExisting).values());
    }

    static void assertEntriesInTransactionContextMap(RaftServer.Division division, Collection<RaftProtos.LogEntryProto> existing, Collection<RaftProtos.LogEntryProto> nonExisting) {
        TermIndex termIndex;
        Map map = RaftServerTestUtil.getTransactionContextMap((RaftServer.Division)division);
        for (RaftProtos.LogEntryProto e : existing) {
            termIndex = TermIndex.valueOf((RaftProtos.LogEntryProto)e);
            Assertions.assertTrue((boolean)map.containsKey(termIndex), () -> termIndex + " not found in " + division.getId());
        }
        for (RaftProtos.LogEntryProto e : nonExisting) {
            termIndex = TermIndex.valueOf((RaftProtos.LogEntryProto)e);
            Assertions.assertFalse((boolean)map.containsKey(termIndex), () -> termIndex + " found in " + division.getId());
        }
    }

    private void assertLogEntries(RaftServer.Division server, long term, RaftTestUtil.SimpleMessage[] expectedMessages) throws Exception {
        RaftTestUtil.assertLogEntries((RaftServer.Division)server, (long)term, (RaftTestUtil.SimpleMessage[])expectedMessages, (int)30, (Logger)this.LOG);
    }
}

