/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.simulation.MiniRaftClusterWithSimulatedRpc;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestRaftServerNoLeaderTimeout
extends BaseTest {
    private static final int NUM_SERVERS = 3;
    private static final RaftProperties PROPERTIES;
    private final MiniRaftClusterWithSimulatedRpc cluster = (MiniRaftClusterWithSimulatedRpc)MiniRaftClusterWithSimulatedRpc.FACTORY.newCluster(3, TestRaftServerNoLeaderTimeout.getProperties());

    private static RaftProperties getProperties() {
        RaftServerConfigKeys.Notification.setNoLeaderTimeout((RaftProperties)PROPERTIES, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS));
        PROPERTIES.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        return PROPERTIES;
    }

    @BeforeEach
    public void setup() throws IOException {
        Assertions.assertNull((Object)this.cluster.getLeader());
        this.cluster.start();
    }

    @AfterEach
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testLeaderElectionDetection() throws Exception {
        RaftTestUtil.waitForLeader((MiniRaftCluster)this.cluster);
        TimeDuration noLeaderTimeout = RaftServerConfigKeys.Notification.noLeaderTimeout((RaftProperties)this.cluster.getProperties());
        RaftServer.Division healthyFollower = (RaftServer.Division)this.cluster.getFollowers().get(1);
        RaftServer.Division failedFollower = (RaftServer.Division)this.cluster.getFollowers().get(0);
        this.cluster.killServer(failedFollower.getId());
        this.cluster.killServer(this.cluster.getLeader().getId());
        noLeaderTimeout.sleep();
        noLeaderTimeout.sleep();
        RaftProtos.RoleInfoProto roleInfoProto = SimpleStateMachine4Testing.get((RaftServer.Division)healthyFollower).getLeaderElectionTimeoutInfo();
        Assertions.assertNotNull((Object)roleInfoProto);
        Assertions.assertEquals((Object)roleInfoProto.getRole(), (Object)RaftProtos.RaftPeerRole.CANDIDATE);
        long noLeaderTimeoutMs = noLeaderTimeout.toLong(TimeUnit.MILLISECONDS);
        Assertions.assertTrue((roleInfoProto.getCandidateInfo().getLastLeaderElapsedTimeMs() > noLeaderTimeoutMs ? 1 : 0) != 0);
    }

    static {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
        PROPERTIES = new RaftProperties();
    }
}

