/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.metrics.impl.RatisMetricRegistryImpl;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.apache.ratis.server.simulation.MiniRaftClusterWithSimulatedRpc;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.thirdparty.com.codahale.metrics.Gauge;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@Disabled
public class TestRaftServerSlownessDetection
extends BaseTest {
    public static final int NUM_SERVERS = 3;
    protected static final RaftProperties PROPERTIES;
    private final MiniRaftClusterWithSimulatedRpc cluster = (MiniRaftClusterWithSimulatedRpc)MiniRaftClusterWithSimulatedRpc.FACTORY.newCluster(3, this.getProperties());

    public RaftProperties getProperties() {
        RaftServerConfigKeys.Rpc.setSlownessTimeout((RaftProperties)PROPERTIES, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS));
        PROPERTIES.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        return PROPERTIES;
    }

    @BeforeEach
    public void setup() throws IOException {
        Assertions.assertNull((Object)this.cluster.getLeader());
        this.cluster.start();
    }

    @AfterEach
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testSlownessDetection() throws Exception {
        RaftServer.Division leaderServer = RaftTestUtil.waitForLeader((MiniRaftCluster)this.cluster);
        long slownessTimeout = RaftServerConfigKeys.Rpc.slownessTimeout((RaftProperties)this.cluster.getProperties()).toIntExact(TimeUnit.MILLISECONDS);
        RaftServer.Division failedFollower = (RaftServer.Division)this.cluster.getFollowers().get(0);
        RatisMetricRegistryImpl ratisMetricRegistry = (RatisMetricRegistryImpl)((RaftServerMetricsImpl)leaderServer.getRaftServerMetrics()).getRegistry();
        SortedMap heartbeatElapsedTimeGauges = ratisMetricRegistry.getGauges((s, metric) -> s.contains("lastHeartbeatElapsedTime"));
        String followerId = failedFollower.getId().toString();
        Gauge metric2 = (Gauge)((Map.Entry)heartbeatElapsedTimeGauges.entrySet().parallelStream().filter(e -> ((String)e.getKey()).contains(followerId)).iterator().next()).getValue();
        long followerHeartBeatElapsedMetric = (Long)metric2.getValue();
        this.cluster.killServer(failedFollower.getId());
        Thread.sleep(slownessTimeout * 2L);
        long followerHeartBeatElapsedMetricNew = (Long)metric2.getValue();
        Assertions.assertTrue((followerHeartBeatElapsedMetricNew > followerHeartBeatElapsedMetric ? 1 : 0) != 0);
        for (RaftServer.Division followerServer : this.cluster.getFollowers()) {
            Assertions.assertNull((Object)SimpleStateMachine4Testing.get((RaftServer.Division)followerServer).getSlownessInfo());
        }
        RaftProtos.RoleInfoProto roleInfoProto = SimpleStateMachine4Testing.get((RaftServer.Division)this.cluster.getLeader()).getSlownessInfo();
        Assertions.assertNotNull((Object)roleInfoProto);
        List followers = roleInfoProto.getLeaderInfo().getFollowerInfoList();
        for (RaftProtos.ServerRpcProto serverProto : followers) {
            if (!RaftPeerId.valueOf((ByteString)serverProto.getId().getId()).equals((Object)failedFollower.getId())) continue;
            Assertions.assertTrue((serverProto.getLastRpcElapsedTimeMs() > slownessTimeout ? 1 : 0) != 0);
        }
    }

    static {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        PROPERTIES = new RaftProperties();
    }
}

