/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestClientProtoUtils
extends BaseTest {
    @Test
    public void testToRaftClientRequestProto() throws Exception {
        for (int i = 1; i < 32; i <<= 2) {
            SizeInBytes messageSize = SizeInBytes.valueOf((String)(i + "MB"));
            this.runTestToRaftClientRequestProto(100, messageSize);
        }
    }

    void runTestToRaftClientRequestProto(int n, SizeInBytes messageSize) throws Exception {
        ClientId clientId = ClientId.randomId();
        RaftPeerId leaderId = RaftPeerId.valueOf((String)"s0");
        RaftGroupId groupId = RaftGroupId.randomId();
        TimeDuration toProto = TimeDuration.ZERO;
        TimeDuration toRequest = TimeDuration.ZERO;
        for (int i = 0; i < n; ++i) {
            ByteString bytes = TestClientProtoUtils.newByteString(messageSize.getSizeInt(), i);
            RaftClientRequest request = RaftClientRequest.newBuilder().setClientId(clientId).setServerId(leaderId).setGroupId(groupId).setCallId(1L).setMessage(() -> bytes).setType(RaftClientRequest.writeRequestType()).build();
            Timestamp startTime = Timestamp.currentTime();
            RaftProtos.RaftClientRequestProto proto = ClientProtoUtils.toRaftClientRequestProto((RaftClientRequest)request);
            TimeDuration p = startTime.elapsedTime();
            RaftClientRequest computed = ClientProtoUtils.toRaftClientRequest((RaftProtos.RaftClientRequestProto)proto);
            TimeDuration r = startTime.elapsedTime().subtract(p);
            Assertions.assertEquals((Object)request.getMessage().getContent(), (Object)computed.getMessage().getContent());
            toProto = toProto.add(p);
            toRequest = toRequest.add(r);
        }
        System.out.printf("%nmessageSize=%s, n=%d%n", messageSize, n);
        this.print("toProto  ", toProto, n);
        this.print("toRequest", toRequest, n);
    }

    void print(String name, TimeDuration t, int n) {
        long ns = t.toLong(TimeUnit.NANOSECONDS);
        System.out.printf("%s: avg = %s (total = %s)%n", name, TestClientProtoUtils.ns2String(ns / (long)n), TestClientProtoUtils.ns2String(ns));
    }

    static String ns2String(long ns) {
        return String.format("%.3fms", (double)ns / 1000000.0);
    }

    static ByteString newByteString(int size, int offset) throws IOException {
        try (ByteString.Output out = ByteString.newOutput();){
            for (int i = 0; i < size; ++i) {
                out.write(i + offset);
            }
            ByteString byteString = out.toByteString();
            return byteString;
        }
    }
}

