/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.conf;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.simulation.SimulatedRpc;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConfUtils
extends BaseTest {
    @Test
    public void testLogging() {
        AtomicInteger count = new AtomicInteger();
        Consumer<String> logger = s -> {
            System.out.println("log: " + s);
            count.incrementAndGet();
        };
        RaftProperties properties = new RaftProperties();
        SimulatedRpc simulated = SimulatedRpc.get();
        RpcType defaultType = RaftConfigKeys.Rpc.type((RaftProperties)properties, logger);
        Assertions.assertEquals((int)1, (int)count.get());
        Assertions.assertNotEquals((Object)defaultType, (Object)simulated);
        RaftConfigKeys.Rpc.type((RaftProperties)properties, logger);
        Assertions.assertEquals((int)1, (int)count.get());
        RaftConfigKeys.Rpc.setType((RaftProperties)properties, (RpcType)SimulatedRpc.get());
        RaftConfigKeys.Rpc.type((RaftProperties)properties, logger);
        Assertions.assertEquals((int)2, (int)count.get());
    }

    @Test
    public void testRaftConfigKeys() {
        ConfUtils.printAll(RaftConfigKeys.class);
    }

    @Test
    public void testRaftServerConfigKeys() {
        ConfUtils.printAll(RaftServerConfigKeys.class);
    }

    @Test
    public void testRaftClientConfigKeys() {
        ConfUtils.printAll(RaftClientConfigKeys.class);
    }

    @Test
    public void testGrpcConfigKeys() {
        ConfUtils.printAll(GrpcConfigKeys.class);
    }

    @Test
    public void testNettyConfigKeys() {
        ConfUtils.printAll(NettyConfigKeys.class);
    }
}

