/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.conf;

import org.apache.ratis.conf.RaftProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestRaftProperties {
    static final String KEY = "key";

    static void setUnderscoreValue(RaftProperties p, String valueWithUnderscore) {
        Assertions.assertTrue((boolean)valueWithUnderscore.contains("_"));
        p.set(KEY, valueWithUnderscore);
    }

    static void setNonUnderscoreValue(RaftProperties p, String valueWithoutUnderscore) {
        Assertions.assertFalse((boolean)valueWithoutUnderscore.contains("_"));
        p.set(KEY, valueWithoutUnderscore);
    }

    @Test
    @Timeout(value=1L)
    public void testUnderscore() {
        RaftProperties p = new RaftProperties();
        Assertions.assertNull((Object)p.getBoolean(KEY, null));
        TestRaftProperties.setNonUnderscoreValue(p, "true");
        Assertions.assertTrue((boolean)p.getBoolean(KEY, null));
        TestRaftProperties.setNonUnderscoreValue(p, "false");
        Assertions.assertFalse((boolean)p.getBoolean(KEY, null));
        TestRaftProperties.setUnderscoreValue(p, "fa_lse");
        Assertions.assertNull((Object)p.getBoolean(KEY, null));
        p.unset(KEY);
        Object expected = 1000000;
        Assertions.assertNull((Object)p.getInt(KEY, null));
        TestRaftProperties.setUnderscoreValue(p, "1_000_000");
        Assertions.assertEquals((Integer)expected, (Integer)p.getInt(KEY, null));
        TestRaftProperties.setNonUnderscoreValue(p, "1000000");
        Assertions.assertEquals((Integer)expected, (Integer)p.getInt(KEY, null));
        p.unset(KEY);
        expected = 1000000000000L;
        Assertions.assertNull((Object)p.getLong(KEY, null));
        TestRaftProperties.setUnderscoreValue(p, "1_000_000_000_000");
        Assertions.assertEquals((Long)expected, (Long)p.getLong(KEY, null));
        TestRaftProperties.setNonUnderscoreValue(p, "1000000000000");
        Assertions.assertEquals((Long)expected, (Long)p.getLong(KEY, null));
        p.unset(KEY);
        expected = "1_000_000";
        Assertions.assertNull((Object)p.getFile(KEY, null));
        TestRaftProperties.setUnderscoreValue(p, "1_000_000");
        Assertions.assertEquals((Object)"1_000_000", (Object)p.getFile(KEY, null).getName());
        p.unset(KEY);
        expected = Type.APPEND_ENTRIES;
        Assertions.assertNull((Object)p.getEnum(KEY, Type.class, null));
        TestRaftProperties.setUnderscoreValue(p, ((Enum)expected).name());
        Assertions.assertEquals((Object)expected, (Object)p.getEnum(KEY, Type.class, null));
        p.unset(KEY);
        expected = Request_Vote.class;
        Assertions.assertNull((Object)p.getClass(KEY, null));
        TestRaftProperties.setUnderscoreValue(p, ((Class)expected).getName());
        Assertions.assertEquals((Object)expected, (Object)p.getClass(KEY, null));
        p.unset(KEY);
    }

    static class Request_Vote {
        Request_Vote() {
        }
    }

    static enum Type {
        APPEND_ENTRIES;

    }
}

