/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.datastream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ratis.BaseTest;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.client.impl.DataStreamClientImpl;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.DataStreamTestUtils;
import org.apache.ratis.datastream.impl.DataStreamReplyByteBuffer;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamReply;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.server.DataStreamServer;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;

abstract class DataStreamBaseTest
extends BaseTest {
    protected RaftProperties properties;
    private List<Server> servers;
    private List<RaftPeer> peers;
    private RaftGroup raftGroup;

    DataStreamBaseTest() {
    }

    RaftConfiguration getRaftConf() {
        List peerList = this.servers.stream().map(Server::getPeer).collect(Collectors.toList());
        return RaftServerTestUtil.newRaftConfiguration(peerList);
    }

    Server getPrimaryServer() {
        return this.servers.get(0);
    }

    void setup(RaftGroupId groupId, List<RaftPeer> peerList, List<RaftServer> raftServers) throws Exception {
        this.raftGroup = RaftGroup.valueOf((RaftGroupId)groupId, peerList);
        this.peers = peerList;
        this.servers = new ArrayList<Server>(peerList.size());
        for (int i = 0; i < peerList.size(); ++i) {
            Server server = new Server(peerList.get(i), raftServers.get(i));
            server.addRaftPeers(this.removePeerFromList(peerList.get(i), peerList));
            server.start();
            this.servers.add(server);
        }
    }

    private Collection<RaftPeer> removePeerFromList(RaftPeer peer, List<RaftPeer> peerList) {
        ArrayList<RaftPeer> otherPeers = new ArrayList<RaftPeer>(peerList);
        otherPeers.remove(peer);
        return otherPeers;
    }

    RaftClient newRaftClientForDataStream(ClientId clientId) {
        return RaftClient.newBuilder().setClientId(clientId).setRaftGroup(this.raftGroup).setPrimaryDataStreamServer(this.getPrimaryServer().getPeer()).setProperties(this.properties).build();
    }

    protected void shutdown() throws IOException {
        for (Server server : this.servers) {
            server.close();
        }
    }

    void runTestMockCluster(ClientId clientId, int bufferSize, int bufferNum, Exception expectedException, Exception headerException) throws IOException {
        try (RaftClient client = this.newRaftClientForDataStream(clientId);){
            DataStreamClientImpl.DataStreamOutputImpl out = (DataStreamClientImpl.DataStreamOutputImpl)client.getDataStreamApi().stream(null, DataStreamTestUtils.getRoutingTableChainTopology(this.peers, this.getPrimaryServer().getPeer()));
            if (headerException != null) {
                DataStreamReply headerReply = (DataStreamReply)out.getHeaderFuture().join();
                Assertions.assertFalse((boolean)headerReply.isSuccess());
                RaftClientReply clientReply = ClientProtoUtils.toRaftClientReply((ByteBuffer)((DataStreamReplyByteBuffer)headerReply).slice());
                Assertions.assertTrue((boolean)clientReply.getException().getMessage().contains(headerException.getMessage()));
                return;
            }
            RaftClientReply clientReply = DataStreamTestUtils.writeAndCloseAndAssertReplies(CollectionUtils.as(this.servers, Server::getRaftServer), null, out, bufferSize, bufferNum, client.getId(), false).join();
            if (expectedException != null) {
                Assertions.assertFalse((boolean)clientReply.isSuccess());
                Assertions.assertTrue((boolean)clientReply.getException().getMessage().contains(expectedException.getMessage()));
            } else {
                Assertions.assertTrue((boolean)clientReply.isSuccess());
            }
        }
    }

    static class Server {
        private final RaftPeer peer;
        private final RaftServer raftServer;
        private final DataStreamServer dataStreamServer;

        Server(RaftPeer peer, RaftServer raftServer) {
            this.peer = peer;
            this.raftServer = raftServer;
            this.dataStreamServer = RaftServerTestUtil.newDataStreamServer((RaftServer)raftServer);
        }

        RaftPeer getPeer() {
            return this.peer;
        }

        RaftServer getRaftServer() {
            return this.raftServer;
        }

        void start() throws IOException {
            this.dataStreamServer.getServerRpc().start();
        }

        void addRaftPeers(Collection<RaftPeer> peers) {
            this.dataStreamServer.getServerRpc().addRaftPeers(peers);
        }

        void close() throws IOException {
            this.dataStreamServer.close();
        }
    }
}

