/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.datastream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.DataStreamBaseTest;
import org.apache.ratis.datastream.DataStreamTestUtils;
import org.apache.ratis.datastream.SupportedDataStreamType;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.DataStreamMap;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.util.NetUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Disabled
public class TestNettyDataStreamWithMock
extends DataStreamBaseTest {
    static RaftPeer newRaftPeer(RaftServer server) {
        return RaftPeer.newBuilder().setId(server.getId()).setAddress(NetUtils.localhostWithFreePort()).setDataStreamAddress(NetUtils.localhostWithFreePort()).build();
    }

    @BeforeEach
    public void setup() {
        this.properties = new RaftProperties();
        RaftConfigKeys.DataStream.setType((RaftProperties)this.properties, (SupportedDataStreamType)SupportedDataStreamType.NETTY);
    }

    RaftServer.Division mockDivision(RaftServer server, RaftGroupId groupId) {
        RaftServer.Division division = (RaftServer.Division)Mockito.mock(RaftServer.Division.class);
        Mockito.when((Object)division.getRaftServer()).thenReturn((Object)server);
        Mockito.when((Object)division.getRaftConf()).thenAnswer(i -> this.getRaftConf());
        DataStreamTestUtils.MultiDataStreamStateMachine stateMachine = new DataStreamTestUtils.MultiDataStreamStateMachine();
        try {
            stateMachine.initialize(server, groupId, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        Mockito.when((Object)division.getStateMachine()).thenReturn((Object)stateMachine);
        DataStreamMap streamMap = RaftServerTestUtil.newDataStreamMap((Object)server.getId());
        Mockito.when((Object)division.getDataStreamMap()).thenReturn((Object)streamMap);
        return division;
    }

    private void testMockCluster(int numServers, RaftException leaderException, IllegalStateException submitException) throws Exception {
        this.testMockCluster(numServers, leaderException, submitException, null);
    }

    private void testMockCluster(int numServers, RaftException leaderException, IllegalStateException submitException, IOException getStateMachineException) throws Exception {
        ArrayList<RaftServer> raftServers = new ArrayList<RaftServer>();
        ClientId clientId = ClientId.randomId();
        RaftGroupId groupId = RaftGroupId.randomId();
        for (int i = 0; i < numServers; ++i) {
            RaftServer raftServer = (RaftServer)Mockito.mock(RaftServer.class);
            RaftPeerId peerId = RaftPeerId.valueOf((String)("s" + i));
            RaftProperties properties = new RaftProperties();
            NettyConfigKeys.DataStream.setPort((RaftProperties)properties, (int)NetUtils.getFreePort());
            RaftConfigKeys.DataStream.setType((RaftProperties)properties, (SupportedDataStreamType)SupportedDataStreamType.NETTY);
            Mockito.when((Object)raftServer.getProperties()).thenReturn((Object)properties);
            Mockito.when((Object)raftServer.getId()).thenReturn((Object)peerId);
            Mockito.when((Object)raftServer.getPeer()).thenReturn((Object)RaftPeer.newBuilder().setId(peerId).build());
            if (getStateMachineException == null) {
                RaftServer.Division myDivision = this.mockDivision(raftServer, groupId);
                Mockito.when((Object)raftServer.getDivision((RaftGroupId)Mockito.any(RaftGroupId.class))).thenReturn((Object)myDivision);
            } else {
                Mockito.when((Object)raftServer.getDivision((RaftGroupId)Mockito.any(RaftGroupId.class))).thenThrow(new Throwable[]{getStateMachineException});
            }
            raftServers.add(raftServer);
        }
        this.runTestMockCluster(groupId, raftServers, clientId, 1000000, 10, submitException != null ? submitException : leaderException, getStateMachineException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestMockCluster(RaftGroupId groupId, List<RaftServer> raftServers, ClientId clientId, int bufferSize, int bufferNum, Exception expectedException, Exception headerException) throws Exception {
        try {
            List<RaftPeer> peers = raftServers.stream().map(TestNettyDataStreamWithMock::newRaftPeer).collect(Collectors.toList());
            this.setup(groupId, peers, raftServers);
            this.runTestMockCluster(clientId, bufferSize, bufferNum, expectedException, headerException);
        }
        finally {
            this.shutdown();
        }
    }

    @Test
    public void testCloseStreamPrimary() throws Exception {
        this.testMockCluster(3, null, null);
    }

    @Test
    public void testCloseStreamOneServer() throws Exception {
        this.testMockCluster(1, null, null);
    }

    @Test
    public void testStateMachineExceptionInReply() throws Exception {
        StateMachineException stateMachineException = new StateMachineException("leader throw StateMachineException");
        this.testMockCluster(3, (RaftException)stateMachineException, null);
    }

    @Test
    public void testDataStreamExceptionInReply() throws Exception {
        IllegalStateException submitException = new IllegalStateException("primary throw IllegalStateException");
        this.testMockCluster(3, null, submitException);
    }

    @Test
    public void testDataStreamExceptionGetStateMachine() throws Exception {
        IOException getStateMachineException = new IOException("Failed to get StateMachine");
        this.testMockCluster(1, null, null, getStateMachineException);
    }
}

