/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.grpc.MiniRaftClusterWithGrpc;
import org.apache.ratis.grpc.server.GrpcService;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.impl.JvmMetrics;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGrpcMessageMetrics
extends BaseTest
implements MiniRaftClusterWithGrpc.FactoryGet {
    public static final int NUM_SERVERS = 3;

    @Test
    public void testGrpcMessageMetrics() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            TestGrpcMessageMetrics.sendMessages(cluster);
        }
    }

    static void sendMessages(MiniRaftCluster cluster) throws Exception {
        RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        try (RaftClient client = cluster.createClient();){
            CompletableFuture completableFuture = client.async().send((Message)new RaftTestUtil.SimpleMessage("abc"));
        }
        JavaUtils.attempt(() -> TestGrpcMessageMetrics.assertMessageCount(cluster.getLeader()), (int)100, (TimeDuration)HUNDRED_MILLIS, (String)(cluster.getLeader().getId() + "-assertMessageCount"), null);
    }

    static void assertMessageCount(RaftServer.Division server) {
        String counter_prefix;
        String serverId = server.getId().toString();
        GrpcService service = (GrpcService)RaftServerTestUtil.getServerRpc((RaftServer.Division)server);
        RatisMetricRegistry registry = service.getServerInterceptor().getMetrics().getRegistry();
        Assertions.assertTrue((registry.counter((counter_prefix = serverId + "_ratis.grpc.RaftServerProtocolService") + "_requestVote_OK_completed_total").getCount() > 0L ? 1 : 0) != 0);
    }

    static {
        JvmMetrics.initJvmMetrics((TimeDuration)TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.SECONDS));
    }
}

