/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.LogAppenderTests;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.MiniRaftClusterWithGrpc;
import org.apache.ratis.grpc.metrics.GrpcServerMetrics;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestLogAppenderWithGrpc
extends LogAppenderTests<MiniRaftClusterWithGrpc>
implements MiniRaftClusterWithGrpc.FactoryGet {
    public TestLogAppenderWithGrpc() {
        Slf4jUtils.setLogLevel((Logger)FollowerInfo.LOG, (Level)Level.DEBUG);
    }

    public static Collection<Boolean[]> data() {
        return Arrays.asList({Boolean.FALSE}, {Boolean.TRUE});
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testPendingLimits(Boolean separateHeartbeat) throws IOException, InterruptedException {
        GrpcConfigKeys.Server.setHeartbeatChannel((RaftProperties)this.getProperties(), (boolean)separateHeartbeat);
        int maxAppends = 10;
        RaftProperties properties = new RaftProperties();
        properties.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        GrpcConfigKeys.Server.setLeaderOutstandingAppendsMax((RaftProperties)properties, (int)maxAppends);
        RaftServerConfigKeys.Log.Appender.setBufferElementLimit((RaftProperties)properties, (int)1);
        MiniRaftClusterWithGrpc cluster = (MiniRaftClusterWithGrpc)this.getFactory().newCluster(3, properties);
        cluster.start();
        try (RaftClient client = cluster.createClient(cluster.getGroup());){
            RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
            RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m"));
            client.io().watch(reply.getLogIndex(), RaftProtos.ReplicationLevel.ALL_COMMITTED);
            long initialNextIndex = RaftServerTestUtil.getNextIndex((RaftServer.Division)leader);
            for (RaftServer.Division server : cluster.getFollowers()) {
                SimpleStateMachine4Testing.get((RaftServer.Division)server).blockWriteStateMachineData();
            }
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(maxAppends * 2);
            for (int i = 0; i < maxAppends * 2; ++i) {
                futures.add(client.async().send((Message)new RaftTestUtil.SimpleMessage("m")));
            }
            JavaUtils.attempt(() -> {
                for (long nextIndex : leader.getInfo().getFollowerNextIndices()) {
                    Assertions.assertEquals((long)(initialNextIndex + (long)maxAppends), (long)nextIndex);
                }
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"matching nextIndex", (Logger)this.LOG);
            for (RaftServer.Division server : cluster.getFollowers()) {
                SimpleStateMachine4Testing.get((RaftServer.Division)server).unblockWriteStateMachineData();
            }
            JavaUtils.allOf(futures).join();
            cluster.shutdown();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testRestartLogAppender(Boolean separateHeartbeat) throws Exception {
        GrpcConfigKeys.Server.setHeartbeatChannel((RaftProperties)this.getProperties(), (boolean)separateHeartbeat);
        this.runWithNewCluster(2, this::runTestRestartLogAppender);
    }

    private void runTestRestartLogAppender(MiniRaftClusterWithGrpc cluster) throws Exception {
        Object reply;
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        int messageCount = 0;
        try (RaftClient client = cluster.createClient(leader.getId());){
            for (int i = 0; i < 10; ++i) {
                reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + ++messageCount));
                Assertions.assertTrue((boolean)reply.isSuccess());
            }
        }
        GrpcServerMetrics leaderMetrics = new GrpcServerMetrics(leader.getMemberId().toString());
        String counter = String.format("%s_inconsistency_reply_count", ((RaftServer.Division)cluster.getFollowers().iterator().next()).getMemberId().getPeerId());
        Assertions.assertEquals((long)0L, (long)leaderMetrics.getRegistry().counter(counter).getCount());
        RaftServerTestUtil.restartLogAppenders((RaftServer.Division)leader);
        RaftClient client = cluster.createClient(leader.getId());
        reply = null;
        try {
            for (int i = 0; i < 10; ++i) {
                RaftClientReply reply2 = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + ++messageCount));
                Assertions.assertTrue((boolean)reply2.isSuccess());
            }
        }
        catch (Throwable throwable) {
            reply = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (reply != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)reply).addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
        RaftServer.Division newLeader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        if (leader == newLeader) {
            GrpcServerMetrics newleaderMetrics = new GrpcServerMetrics(leader.getMemberId().toString());
            Assertions.assertTrue((newleaderMetrics.getRegistry().counter(counter).getCount() >= 1L ? 1 : 0) != 0);
        }
    }
}

