/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.util.Optional;
import org.apache.ratis.grpc.MiniRaftClusterWithGrpc;
import org.apache.ratis.metrics.LongCounter;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.statemachine.RaftSnapshotBaseTest;
import org.junit.jupiter.api.Assertions;

public class TestRaftSnapshotWithGrpc
extends RaftSnapshotBaseTest {
    public MiniRaftCluster.Factory<?> getFactory() {
        return MiniRaftClusterWithGrpc.FACTORY;
    }

    protected void verifyInstallSnapshotMetric(RaftServer.Division leader) {
        MetricRegistryInfo info = new MetricRegistryInfo(leader.getMemberId().toString(), "ratis_grpc", "log_appender", "Metrics for Ratis Grpc Log Appender");
        Optional metricRegistry = MetricRegistries.global().get(info);
        Assertions.assertTrue((boolean)metricRegistry.isPresent());
        LongCounter installSnapshotCounter = ((RatisMetricRegistry)metricRegistry.get()).counter("num_install_snapshot");
        Assertions.assertNotNull((Object)installSnapshotCounter);
        Assertions.assertTrue((installSnapshotCounter.getCount() >= 1L ? 1 : 0) != 0);
    }
}

