/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.RaftBasicTests;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.MiniRaftClusterWithGrpc;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.BlockRequestHandlingInjection;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;

public class TestRaftWithGrpc
extends RaftBasicTests<MiniRaftClusterWithGrpc>
implements MiniRaftClusterWithGrpc.FactoryGet {
    public TestRaftWithGrpc() {
        this.getProperties().setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
    }

    @Disabled
    public void testWithLoad() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testWithLoad(boolean separateHeartbeat) throws Exception {
        GrpcConfigKeys.Server.setHeartbeatChannel((RaftProperties)this.getProperties(), (boolean)separateHeartbeat);
        super.testWithLoad();
        BlockRequestHandlingInjection.getInstance().unblockAll();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRequestTimeout(boolean separateHeartbeat) throws Exception {
        GrpcConfigKeys.Server.setHeartbeatChannel((RaftProperties)this.getProperties(), (boolean)separateHeartbeat);
        this.runWithNewCluster(5, cluster -> TestRaftWithGrpc.testRequestTimeout((boolean)false, (MiniRaftCluster)cluster, (Logger)this.LOG));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testUpdateViaHeartbeat(boolean separateHeartbeat) throws Exception {
        GrpcConfigKeys.Server.setHeartbeatChannel((RaftProperties)this.getProperties(), (boolean)separateHeartbeat);
        this.runWithNewCluster(5, this::runTestUpdateViaHeartbeat);
    }

    void runTestUpdateViaHeartbeat(MiniRaftClusterWithGrpc cluster) throws Exception {
        RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        try (RaftClient client = cluster.createClient();){
            cluster.getServerAliveStream().filter(impl -> !impl.getInfo().isLeader()).map(SimpleStateMachine4Testing::get).forEach(SimpleStateMachine4Testing::blockWriteStateMachineData);
            CompletableFuture replyFuture = client.async().send((Message)new RaftTestUtil.SimpleMessage("abc"));
            TimeDuration.valueOf((long)5L, (TimeUnit)TimeUnit.SECONDS).sleep();
            Assertions.assertFalse((boolean)replyFuture.isDone());
            cluster.getServerAliveStream().filter(impl -> !impl.getInfo().isLeader()).map(SimpleStateMachine4Testing::get).forEach(SimpleStateMachine4Testing::unblockWriteStateMachineData);
            RaftLog leaderLog = cluster.getLeader().getRaftLog();
            cluster.getServerAliveStream().filter(impl -> !impl.getInfo().isLeader()).forEach(raftServer -> JavaUtils.runAsUnchecked(() -> JavaUtils.attempt(() -> {
                long leaderNextIndex = leaderLog.getNextIndex();
                Object[] leaderEntries = leaderLog.getEntries(0L, Long.MAX_VALUE);
                RaftLog followerLog = raftServer.getRaftLog();
                Assertions.assertEquals((long)leaderNextIndex, (long)followerLog.getNextIndex());
                Object[] serverEntries = followerLog.getEntries(0L, Long.MAX_VALUE);
                Assertions.assertArrayEquals((Object[])serverEntries, (Object[])leaderEntries);
            }, (int)10, (TimeDuration)HUNDRED_MILLIS, (String)("assertRaftLog-" + raftServer.getId()), (Logger)this.LOG)));
            Thread.sleep(500L);
            RaftServerTestUtil.getLogAppenders((RaftServer.Division)cluster.getLeader()).forEach(logAppender -> JavaUtils.runAsUnchecked(() -> JavaUtils.attempt(() -> {
                long leaderNextIndex = leaderLog.getNextIndex();
                long followerMatchIndex = logAppender.getFollower().getMatchIndex();
                Assertions.assertTrue((followerMatchIndex >= leaderNextIndex - 1L ? 1 : 0) != 0);
                Assertions.assertEquals((long)(followerMatchIndex + 1L), (long)logAppender.getFollower().getNextIndex());
            }, (int)10, (TimeDuration)HUNDRED_MILLIS, (String)("assertRaftLog-" + logAppender.getFollower()), (Logger)this.LOG)));
        }
    }
}

