/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.util.function.Consumer;
import org.apache.ratis.grpc.metrics.GrpcServerMetrics;
import org.apache.ratis.grpc.server.GrpcLogAppender;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.impl.DefaultTimekeeperImpl;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.metrics.ServerMetricsTestUtils;
import org.apache.ratis.thirdparty.com.codahale.metrics.Gauge;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestGrpcServerMetrics {
    private static GrpcServerMetrics grpcServerMetrics;
    private static RatisMetricRegistry ratisMetricRegistry;
    private static RaftGroupId raftGroupId;
    private static RaftPeerId raftPeerId;
    private static RaftPeerId followerId;

    @BeforeAll
    public static void setUp() throws Exception {
        raftGroupId = RaftGroupId.randomId();
        raftPeerId = RaftPeerId.valueOf((String)"TestId");
        followerId = RaftPeerId.valueOf((String)"FollowerId");
        RaftGroupMemberId raftGroupMemberId = RaftGroupMemberId.valueOf((RaftPeerId)raftPeerId, (RaftGroupId)raftGroupId);
        grpcServerMetrics = new GrpcServerMetrics(raftGroupMemberId.toString());
        ratisMetricRegistry = grpcServerMetrics.getRegistry();
    }

    @Test
    public void testGrpcLogAppenderLatencyTimer() throws Exception {
        for (boolean heartbeat : new boolean[]{true, false}) {
            RaftProtos.AppendEntriesRequestProto.Builder proto = RaftProtos.AppendEntriesRequestProto.newBuilder();
            if (!heartbeat) {
                proto.addEntries(RaftProtos.LogEntryProto.newBuilder().build());
            }
            GrpcLogAppender.AppendEntriesRequest req = new GrpcLogAppender.AppendEntriesRequest(proto.build(), followerId, grpcServerMetrics);
            String format = "%s_latency" + GrpcServerMetrics.getHeartbeatSuffix((boolean)heartbeat);
            String name = String.format(format, followerId);
            DefaultTimekeeperImpl t = (DefaultTimekeeperImpl)ratisMetricRegistry.timer(name);
            Assertions.assertEquals((long)0L, (long)t.getTimer().getSnapshot().getMax());
            req.startRequestTimer();
            Thread.sleep(1000L);
            req.stopRequestTimer();
            Assertions.assertTrue((t.getTimer().getSnapshot().getMax() > 1000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGrpcLogRequestTotal() {
        for (boolean heartbeat : new boolean[]{true, false}) {
            long reqTotal = ratisMetricRegistry.counter("num_requests" + GrpcServerMetrics.getHeartbeatSuffix((boolean)heartbeat)).getCount();
            grpcServerMetrics.onRequestCreate(heartbeat);
            Assertions.assertEquals((long)(reqTotal + 1L), (long)ratisMetricRegistry.counter("num_requests" + GrpcServerMetrics.getHeartbeatSuffix((boolean)heartbeat)).getCount());
        }
    }

    @Test
    public void testGrpcLogRequestRetry() {
        Assertions.assertEquals((long)0L, (long)ratisMetricRegistry.counter("num_retries").getCount());
        grpcServerMetrics.onRequestRetry();
        Assertions.assertEquals((long)1L, (long)ratisMetricRegistry.counter("num_retries").getCount());
    }

    @Test
    public void testGrpcLogPendingRequestCount() {
        GrpcLogAppender.RequestMap pendingRequest = (GrpcLogAppender.RequestMap)Mockito.mock(GrpcLogAppender.RequestMap.class);
        Mockito.when((Object)pendingRequest.logRequestsSize()).thenReturn((Object)0);
        grpcServerMetrics.addPendingRequestsCount(raftPeerId.toString(), () -> ((GrpcLogAppender.RequestMap)pendingRequest).logRequestsSize());
        String name = String.format("%s_pending_log_requests_count", raftPeerId);
        Gauge gauge = ServerMetricsTestUtils.getGaugeWithName((String)name, () -> ((GrpcServerMetrics)grpcServerMetrics).getRegistry());
        Assertions.assertEquals((Object)0, (Object)gauge.getValue());
        Mockito.when((Object)pendingRequest.logRequestsSize()).thenReturn((Object)10);
        Assertions.assertEquals((Object)10, (Object)gauge.getValue());
    }

    @Test
    public void testGrpcLogAppenderRequestCounters() {
        this.assertCounterIncremented("%s_not_leader_reply_count", arg_0 -> ((GrpcServerMetrics)grpcServerMetrics).onRequestNotLeader(arg_0));
        this.assertCounterIncremented("%s_inconsistency_reply_count", arg_0 -> ((GrpcServerMetrics)grpcServerMetrics).onRequestInconsistency(arg_0));
        for (boolean heartbeat : new boolean[]{true, false}) {
            this.assertCounterIncremented("%s_success_reply_count" + GrpcServerMetrics.getHeartbeatSuffix((boolean)heartbeat), follower -> grpcServerMetrics.onRequestSuccess(follower, heartbeat));
            this.assertCounterIncremented("%s_append_entry_timeout_count" + GrpcServerMetrics.getHeartbeatSuffix((boolean)heartbeat), follower -> grpcServerMetrics.onRequestTimeout(follower, heartbeat));
        }
    }

    private void assertCounterIncremented(String counterVar, Consumer<String> incFunction) {
        String counter = String.format(counterVar, raftPeerId.toString());
        Assertions.assertEquals((long)0L, (long)ratisMetricRegistry.counter(counter).getCount());
        incFunction.accept(raftPeerId.toString());
        Assertions.assertEquals((long)1L, (long)ratisMetricRegistry.counter(counter).getCount());
    }
}

