/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.apache.ratis.grpc.util.StreamObserverWithTimeout;
import org.apache.ratis.test.proto.GreeterGrpc;
import org.apache.ratis.test.proto.HelloReply;
import org.apache.ratis.test.proto.HelloRequest;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.ClientInterceptor;
import org.apache.ratis.thirdparty.io.grpc.Deadline;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcTestClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcTestClient.class);
    private final ManagedChannel channel;
    private final StreamObserver<HelloRequest> requestHandler;
    private final Queue<CompletableFuture<String>> replies = new ConcurrentLinkedQueue<CompletableFuture<String>>();

    static StreamObserverFactory withDeadline(TimeDuration timeout) {
        Deadline d = Deadline.after((long)timeout.getDuration(), (TimeUnit)timeout.getUnit());
        return (stub, responseHandler) -> ((GreeterGrpc.GreeterStub)stub.withDeadline(d)).hello(responseHandler);
    }

    static StreamObserverFactory withTimeout(TimeDuration timeout) {
        String className = JavaUtils.getClassSimpleName(HelloRequest.class) + ":";
        AtomicBoolean initialized = new AtomicBoolean();
        return (stub, responseHandler) -> StreamObserverWithTimeout.newInstance((String)"test", r -> className + r.getName(), () -> initialized.getAndSet(true) ? timeout : TimeDuration.ONE_MINUTE.add(timeout), (int)2, i -> ((GreeterGrpc.GreeterStub)stub.withInterceptors(new ClientInterceptor[]{i})).hello(responseHandler));
    }

    GrpcTestClient(String host, int port, StreamObserverFactory factory) {
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        GreeterGrpc.GreeterStub asyncStub = GreeterGrpc.newStub((Channel)this.channel);
        StreamObserver<HelloReply> responseHandler = new StreamObserver<HelloReply>(){

            public void onNext(HelloReply helloReply) {
                ((CompletableFuture)GrpcTestClient.this.replies.poll()).complete(helloReply.getMessage());
            }

            public void onError(Throwable throwable) {
                LOG.info("onError", throwable);
                this.completeExceptionally(throwable);
            }

            public void onCompleted() {
                LOG.info("onCompleted");
                this.completeExceptionally(new IllegalStateException("onCompleted"));
            }

            void completeExceptionally(Throwable throwable) {
                GrpcTestClient.this.replies.forEach(f -> f.completeExceptionally(throwable));
                GrpcTestClient.this.replies.clear();
            }
        };
        this.requestHandler = (StreamObserver)factory.apply(asyncStub, responseHandler);
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)"Failed to close", (InterruptedException)e);
        }
    }

    CompletableFuture<String> send(String name) {
        LOG.info("send {}", (Object)name);
        HelloRequest request = HelloRequest.newBuilder().setName(name).build();
        CompletableFuture<String> f = new CompletableFuture<String>();
        try {
            this.requestHandler.onNext((Object)request);
            this.replies.offer(f);
        }
        catch (IllegalStateException e) {
            f.completeExceptionally(e);
        }
        return f;
    }

    @FunctionalInterface
    static interface StreamObserverFactory
    extends BiFunction<GreeterGrpc.GreeterStub, StreamObserver<HelloReply>, StreamObserver<HelloRequest>> {
    }
}

