/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ratis.test.proto.GreeterGrpc;
import org.apache.ratis.test.proto.HelloReply;
import org.apache.ratis.test.proto.HelloRequest;
import org.apache.ratis.thirdparty.io.grpc.BindableService;
import org.apache.ratis.thirdparty.io.grpc.Server;
import org.apache.ratis.thirdparty.io.grpc.ServerBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.thirdparty.io.netty.util.concurrent.ThreadPerTaskExecutor;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcTestServer
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcTestServer.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Server server;

    GrpcTestServer(int port, int warmup, int slow, TimeDuration timeout) {
        this.server = ServerBuilder.forPort((int)port).executor((Executor)new ThreadPerTaskExecutor(r -> Daemon.newBuilder().setName("test-server-" + COUNTER.getAndIncrement()).setRunnable(r).build())).addService((BindableService)new GreeterImpl(warmup, slow, timeout)).build();
    }

    int start() throws IOException {
        this.server.start();
        return this.server.getPort();
    }

    @Override
    public void close() throws IOException {
        try {
            this.server.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)"Failed to close", (InterruptedException)e);
        }
    }

    static class GreeterImpl
    extends GreeterGrpc.GreeterImplBase {
        private final int warmup;
        private final int slow;
        private final TimeDuration shortSleepTime;
        private final TimeDuration longSleepTime;
        private int count = 0;

        static String toReplySuffix(String request) {
            return ") Hello " + request;
        }

        GreeterImpl(int warmup, int slow, TimeDuration timeout) {
            this.warmup = warmup;
            this.slow = slow;
            this.shortSleepTime = timeout.multiply(0.25);
            this.longSleepTime = timeout.multiply(2.0);
        }

        public StreamObserver<HelloRequest> hello(final StreamObserver<HelloReply> responseObserver) {
            return new StreamObserver<HelloRequest>(){

                public void onNext(HelloRequest helloRequest) {
                    String reply = count + GreeterImpl.toReplySuffix(helloRequest.getName());
                    TimeDuration sleepTime = count < warmup ? TimeDuration.ZERO : (count < warmup + slow ? shortSleepTime : longSleepTime);
                    LOG.info("count = {}, slow = {}, sleep {}", new Object[]{reply, slow, sleepTime});
                    try {
                        sleepTime.sleep();
                    }
                    catch (InterruptedException e) {
                        responseObserver.onError((Throwable)e);
                        return;
                    }
                    responseObserver.onNext((Object)HelloReply.newBuilder().setMessage(reply).build());
                    count++;
                }

                public void onError(Throwable throwable) {
                    LOG.error("onError", throwable);
                }

                public void onCompleted() {
                    responseObserver.onCompleted();
                }
            };
        }
    }
}

