/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.ratis.test.proto.BinaryReply;
import org.apache.ratis.test.proto.BinaryRequest;
import org.apache.ratis.test.proto.GreeterGrpc;
import org.apache.ratis.test.proto.HelloReply;
import org.apache.ratis.test.proto.HelloRequest;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcZeroCopyTestClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcZeroCopyTestClient.class);
    private final ManagedChannel channel;
    private final StreamObserver<HelloRequest> helloRequestHandler;
    private final Queue<CompletableFuture<String>> helloReplies = new ConcurrentLinkedQueue<CompletableFuture<String>>();
    private final StreamObserver<BinaryRequest> binaryRequestHandler;
    private final Queue<CompletableFuture<ByteString>> binaryReplies = new ConcurrentLinkedQueue<CompletableFuture<ByteString>>();

    GrpcZeroCopyTestClient(String host, int port) {
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        GreeterGrpc.GreeterStub asyncStub = GreeterGrpc.newStub((Channel)this.channel);
        StreamObserver<HelloReply> helloResponseHandler = new StreamObserver<HelloReply>(){

            public void onNext(HelloReply helloReply) {
                CompletableFuture polled = (CompletableFuture)GrpcZeroCopyTestClient.this.helloReplies.poll();
                Objects.requireNonNull(polled, "polled");
                polled.complete(helloReply.getMessage());
            }

            public void onError(Throwable throwable) {
                LOG.info("onError", throwable);
                this.completeExceptionally(throwable);
            }

            public void onCompleted() {
                LOG.info("onCompleted");
                this.completeExceptionally(new IllegalStateException("onCompleted"));
            }

            void completeExceptionally(Throwable throwable) {
                GrpcZeroCopyTestClient.this.helloReplies.forEach(f -> f.completeExceptionally(throwable));
                GrpcZeroCopyTestClient.this.helloReplies.clear();
            }
        };
        this.helloRequestHandler = asyncStub.hello((StreamObserver)helloResponseHandler);
        StreamObserver<BinaryReply> binaryResponseHandler = new StreamObserver<BinaryReply>(){

            public void onNext(BinaryReply binaryReply) {
                CompletableFuture polled = (CompletableFuture)GrpcZeroCopyTestClient.this.binaryReplies.poll();
                Objects.requireNonNull(polled, "polled");
                polled.complete(binaryReply.getData());
            }

            public void onError(Throwable throwable) {
                LOG.info("onError", throwable);
                this.completeExceptionally(throwable);
            }

            public void onCompleted() {
                LOG.info("onCompleted");
                this.completeExceptionally(new IllegalStateException("onCompleted"));
            }

            void completeExceptionally(Throwable throwable) {
                GrpcZeroCopyTestClient.this.binaryReplies.forEach(f -> f.completeExceptionally(throwable));
                GrpcZeroCopyTestClient.this.binaryReplies.clear();
            }
        };
        this.binaryRequestHandler = asyncStub.binary((StreamObserver)binaryResponseHandler);
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)"Failed to close", (InterruptedException)e);
        }
    }

    CompletableFuture<String> send(String name) {
        LOG.info("send message {}", (Object)name);
        HelloRequest request = HelloRequest.newBuilder().setName(name).build();
        return GrpcZeroCopyTestClient.send(request, this.helloReplies, arg_0 -> this.helloRequestHandler.onNext(arg_0));
    }

    CompletableFuture<ByteString> send(ByteBuffer data) {
        LOG.info("send data: size={}, direct? {}", (Object)data.remaining(), (Object)data.isDirect());
        BinaryRequest request = BinaryRequest.newBuilder().setData(UnsafeByteOperations.unsafeWrap((ByteBuffer)data)).build();
        return GrpcZeroCopyTestClient.send(request, this.binaryReplies, arg_0 -> this.binaryRequestHandler.onNext(arg_0));
    }

    static <REQUEST, REPLY> CompletableFuture<REPLY> send(REQUEST request, Queue<CompletableFuture<REPLY>> queue, Consumer<REQUEST> onNext) {
        CompletableFuture f = new CompletableFuture();
        queue.offer(f);
        try {
            onNext.accept(request);
        }
        catch (Exception e) {
            f.completeExceptionally(e);
            CompletableFuture<REPLY> polled = queue.poll();
            Preconditions.assertSame(f, polled, (String)"future");
        }
        return f;
    }
}

