/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ratis.grpc.util.TestGrpcZeroCopy;
import org.apache.ratis.grpc.util.ZeroCopyMessageMarshaller;
import org.apache.ratis.test.proto.BinaryReply;
import org.apache.ratis.test.proto.BinaryRequest;
import org.apache.ratis.test.proto.GreeterGrpc;
import org.apache.ratis.test.proto.HelloReply;
import org.apache.ratis.test.proto.HelloRequest;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.MessageLite;
import org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;
import org.apache.ratis.thirdparty.io.grpc.Server;
import org.apache.ratis.thirdparty.io.grpc.ServerBuilder;
import org.apache.ratis.thirdparty.io.grpc.ServerMethodDefinition;
import org.apache.ratis.thirdparty.io.grpc.ServerServiceDefinition;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.TraditionalBinaryPrefix;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcZeroCopyTestServer
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcZeroCopyTestServer.class);
    private final Count zeroCopyCount = new Count();
    private final Count nonZeroCopyCount = new Count();
    private final Server server;
    private final ZeroCopyMessageMarshaller<BinaryRequest> marshaller = new ZeroCopyMessageMarshaller((MessageLite)BinaryRequest.getDefaultInstance(), this.zeroCopyCount::inc, this.nonZeroCopyCount::inc);

    GrpcZeroCopyTestServer(int port) {
        GreeterImpl greeter = new GreeterImpl();
        MethodDescriptor binary = GreeterGrpc.getBinaryMethod();
        String binaryFullMethodName = binary.getFullMethodName();
        ServerServiceDefinition service = greeter.bindService();
        ServerMethodDefinition method = service.getMethod(binaryFullMethodName);
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((String)service.getServiceDescriptor().getName());
        builder.addMethod(binary.toBuilder().setRequestMarshaller(this.marshaller).build(), method.getServerCallHandler());
        service.getMethods().stream().filter(m -> !m.getMethodDescriptor().getFullMethodName().equals(binaryFullMethodName)).forEach(arg_0 -> ((ServerServiceDefinition.Builder)builder).addMethod(arg_0));
        this.server = ServerBuilder.forPort((int)port).maxInboundMessageSize(Integer.MAX_VALUE).addService(builder.build()).build();
    }

    Count getZeroCopyCount() {
        return this.zeroCopyCount;
    }

    Count getNonZeroCopyCount() {
        return this.nonZeroCopyCount;
    }

    void assertCounts(int expectNumElements, long expectNumBytes) {
        LOG.info("ZeroCopyCount    = {}", (Object)this.zeroCopyCount);
        LOG.info("nonZeroCopyCount = {}", (Object)this.nonZeroCopyCount);
        Assertions.assertEquals((int)expectNumElements, (int)this.zeroCopyCount.getNumElements(), (String)"zeroCopyCount.getNumElements()");
        Assertions.assertEquals((long)expectNumBytes, (long)this.zeroCopyCount.getNumBytes(), (String)" zeroCopyCount.getNumBytes()");
        Assertions.assertEquals((int)0, (int)this.nonZeroCopyCount.getNumElements(), (String)"nonZeroCopyCount.getNumElements()");
        Assertions.assertEquals((long)0L, (long)this.nonZeroCopyCount.getNumBytes(), (String)"nonZeroCopyCount.getNumBytes()");
    }

    int start() throws IOException {
        this.server.start();
        return this.server.getPort();
    }

    @Override
    public void close() throws IOException {
        try {
            this.server.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)"Failed to close", (InterruptedException)e);
        }
    }

    static String toReply(int i, String request) {
        return i + ") hi " + request;
    }

    class GreeterImpl
    extends GreeterGrpc.GreeterImplBase {
        GreeterImpl() {
        }

        public StreamObserver<HelloRequest> hello(final StreamObserver<HelloReply> responseObserver) {
            final AtomicInteger count = new AtomicInteger();
            return new StreamObserver<HelloRequest>(){

                public void onNext(HelloRequest request) {
                    String reply = GrpcZeroCopyTestServer.toReply(count.getAndIncrement(), request.getName());
                    LOG.info("reply {}", (Object)reply);
                    responseObserver.onNext((Object)HelloReply.newBuilder().setMessage(reply).build());
                }

                public void onError(Throwable throwable) {
                    LOG.error("onError", throwable);
                }

                public void onCompleted() {
                    responseObserver.onCompleted();
                }
            };
        }

        public StreamObserver<BinaryRequest> binary(final StreamObserver<BinaryReply> responseObserver) {
            final AtomicInteger count = new AtomicInteger();
            return new StreamObserver<BinaryRequest>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onNext(BinaryRequest request) {
                    try {
                        ByteString data = request.getData();
                        int i = count.getAndIncrement();
                        LOG.info("Received {}) data.size() = {}", (Object)i, (Object)data.size());
                        TestGrpcZeroCopy.RandomData.verify(i, data);
                        byte[] bytes = new byte[4];
                        ByteBuffer.wrap(bytes).putInt(data.size());
                        responseObserver.onNext((Object)BinaryReply.newBuilder().setData(UnsafeByteOperations.unsafeWrap((byte[])bytes)).build());
                    }
                    finally {
                        GrpcZeroCopyTestServer.this.marshaller.release((MessageLite)request);
                    }
                }

                public void onError(Throwable throwable) {
                    LOG.error("onError", throwable);
                }

                public void onCompleted() {
                    responseObserver.onCompleted();
                }
            };
        }
    }

    static class Count {
        private int numElements;
        private long numBytes;

        Count() {
        }

        synchronized int getNumElements() {
            return this.numElements;
        }

        synchronized long getNumBytes() {
            return this.numBytes;
        }

        synchronized void inc(ByteString data) {
            ++this.numElements;
            this.numBytes += (long)data.size();
        }

        void inc(BinaryRequest request) {
            this.inc(request.getData());
        }

        public synchronized String toString() {
            return this.numElements + ", " + TraditionalBinaryPrefix.long2String((long)this.numBytes) + "B";
        }
    }
}

