/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.util;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.BaseTest;
import org.apache.ratis.grpc.util.GrpcZeroCopyTestClient;
import org.apache.ratis.grpc.util.GrpcZeroCopyTestServer;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.MessageLite;
import org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.ratis.thirdparty.io.grpc.KnownLength;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import org.apache.ratis.util.NetUtils;
import org.apache.ratis.util.TraditionalBinaryPrefix;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class TestGrpcZeroCopy
extends BaseTest {
    private static final boolean IS_ZERO_COPY_READY;

    public static boolean isReady() {
        return IS_ZERO_COPY_READY;
    }

    @Test
    public void testReadiness() {
        Assertions.assertTrue((boolean)TestGrpcZeroCopy.isReady());
    }

    @Test
    public void testZeroCopy() throws Exception {
        this.runTestZeroCopy();
    }

    void runTestZeroCopy() throws Exception {
        try (GrpcZeroCopyTestServer server = new GrpcZeroCopyTestServer(NetUtils.getFreePort());){
            int port = server.start();
            try (GrpcZeroCopyTestClient client = new GrpcZeroCopyTestClient("localhost", port);){
                this.sendMessages(5, client, server);
                this.sendBinaries(11, client, server);
            }
        }
    }

    void sendMessages(int n, GrpcZeroCopyTestClient client, GrpcZeroCopyTestServer server) throws Exception {
        ArrayList<String> messages = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            messages.add("m" + i);
        }
        ArrayList<CompletableFuture<String>> futures = new ArrayList<CompletableFuture<String>>();
        for (String m : messages) {
            futures.add(client.send(m));
        }
        int numElements = server.getZeroCopyCount().getNumElements();
        long numBytes = server.getZeroCopyCount().getNumBytes();
        for (int i = 0; i < futures.size(); ++i) {
            String expected = GrpcZeroCopyTestServer.toReply(i, (String)messages.get(i));
            String reply = (String)((CompletableFuture)futures.get(i)).get();
            Assertions.assertEquals((Object)expected, (Object)reply, (String)("expected = " + expected + " != reply = " + reply));
            server.assertCounts(numElements, numBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendBinaries(int n, GrpcZeroCopyTestClient client, GrpcZeroCopyTestServer server) throws Exception {
        PooledByteBufAllocator allocator = PooledByteBufAllocator.DEFAULT;
        int numElements = server.getZeroCopyCount().getNumElements();
        long numBytes = server.getZeroCopyCount().getNumBytes();
        for (int i = 0; i < n; ++i) {
            CompletableFuture<ByteString> future;
            int size = 16 << 2 * i;
            this.LOG.info("buf {}: {}B", (Object)i, (Object)TraditionalBinaryPrefix.long2String((long)size));
            ByteBuf buf = allocator.directBuffer(size, size);
            try {
                RandomData.fill(i, size, buf);
                future = client.send(buf.nioBuffer(0, buf.capacity()));
            }
            finally {
                buf.release();
            }
            ByteString reply = future.get();
            Assertions.assertEquals((int)4, (int)reply.size());
            Assertions.assertEquals((int)size, (int)reply.asReadOnlyByteBuffer().getInt());
            server.assertCounts(++numElements, numBytes += (long)size);
        }
    }

    static {
        boolean detachableClassExists = false;
        String detachableClassName = KnownLength.class.getPackage().getName() + ".Detachable";
        try {
            Class.forName(detachableClassName);
            detachableClassExists = true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(System.out);
        }
        boolean unsafeByteOperationsClassExists = false;
        String unsafeByteOperationsClassName = MessageLite.class.getPackage().getName() + ".UnsafeByteOperations";
        try {
            Class.forName(unsafeByteOperationsClassName);
            unsafeByteOperationsClassExists = true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(System.out);
        }
        IS_ZERO_COPY_READY = detachableClassExists && unsafeByteOperationsClassExists;
    }

    static class RandomData {
        private static final Random RANDOM = new Random();
        private static final byte[] ARRAY = new byte[4096];

        RandomData() {
        }

        static void fill(long seed, int size, ByteBuf buf) {
            int remaining;
            RANDOM.setSeed(seed);
            for (int offset = 0; offset < size; offset += remaining) {
                remaining = Math.min(size - offset, ARRAY.length);
                RANDOM.nextBytes(ARRAY);
                buf.writeBytes(ARRAY, 0, remaining);
            }
        }

        static void verify(long seed, ByteString b) {
            int remaining;
            RANDOM.setSeed(seed);
            int size = b.size();
            for (int offset = 0; offset < size; offset += remaining) {
                remaining = Math.min(size - offset, ARRAY.length);
                RANDOM.nextBytes(ARRAY);
                ByteString expected = UnsafeByteOperations.unsafeWrap((byte[])ARRAY, (int)0, (int)remaining);
                ByteString computed = b.substring(offset, offset + remaining);
                Assertions.assertEquals((int)expected.size(), (int)computed.size());
                Assertions.assertEquals((Object)expected, (Object)computed);
            }
        }
    }
}

