/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.util;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.ratis.BaseTest;
import org.apache.ratis.grpc.util.GrpcTestClient;
import org.apache.ratis.grpc.util.GrpcTestServer;
import org.apache.ratis.grpc.util.ResponseNotifyClientInterceptor;
import org.apache.ratis.grpc.util.StreamObserverWithTimeout;
import org.apache.ratis.thirdparty.io.grpc.StatusRuntimeException;
import org.apache.ratis.util.NetUtils;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutTimer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestStreamObserverWithTimeout
extends BaseTest {
    public TestStreamObserverWithTimeout() {
        Slf4jUtils.setLogLevel((Logger)ResponseNotifyClientInterceptor.LOG, (Level)Level.TRACE);
        Slf4jUtils.setLogLevel((Logger)StreamObserverWithTimeout.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)TimeoutTimer.LOG, (Level)Level.DEBUG);
    }

    @Test
    public void testWithDeadline() throws Exception {
        this.runTestTimeout(2, Type.WithDeadline);
    }

    @Test
    public void testWithDeadlineFailure() {
        this.testFailureCase("total sleep time is longer than the deadline", () -> this.runTestTimeout(5, Type.WithDeadline), ExecutionException.class, new Class[]{StatusRuntimeException.class});
    }

    @Test
    public void testWithTimeout() throws Exception {
        this.runTestTimeout(5, Type.WithTimeout);
    }

    void runTestTimeout(int slow, Type type) throws Exception {
        this.LOG.info("slow = {}, {}", (Object)slow, (Object)type);
        TimeDuration timeout = ONE_SECOND.multiply(0.5);
        GrpcTestClient.StreamObserverFactory function = type.createFunction(timeout);
        int warmup = type == Type.WithTimeout ? 1 : 0;
        ArrayList<String> messages = new ArrayList<String>();
        for (int i = 0; i < 2 * slow; ++i) {
            messages.add("m" + (i + warmup));
        }
        try (GrpcTestServer server = new GrpcTestServer(NetUtils.getFreePort(), warmup, slow, timeout);){
            int port = server.start();
            try (GrpcTestClient client = new GrpcTestClient("localhost", port, function);){
                String reply;
                int i;
                if (warmup == 1) {
                    client.send("warmup").join();
                }
                ArrayList<CompletableFuture<String>> futures = new ArrayList<CompletableFuture<String>>();
                for (String m : messages) {
                    futures.add(client.send(m));
                }
                for (i = 0; i < slow; ++i) {
                    String expected = i + warmup + GrpcTestServer.GreeterImpl.toReplySuffix((String)messages.get(i));
                    reply = (String)((CompletableFuture)futures.get(i)).get();
                    Assertions.assertEquals((Object)expected, (Object)reply);
                    this.LOG.info("{}) passed", (Object)(i + warmup));
                }
                while (i < messages.size()) {
                    CompletableFuture f = (CompletableFuture)futures.get(i);
                    try {
                        reply = (String)f.get();
                        Assertions.fail((String)(i + warmup + ") reply = " + reply + ", " + StringUtils.completableFuture2String((CompletableFuture)f, (boolean)false)));
                    }
                    catch (ExecutionException e) {
                        this.LOG.info("GOOD! {}) {}", new Object[]{i + warmup, StringUtils.completableFuture2String((CompletableFuture)f, (boolean)true), e});
                    }
                    ++i;
                }
            }
        }
    }

    static enum Type {
        WithDeadline(GrpcTestClient::withDeadline),
        WithTimeout(GrpcTestClient::withTimeout);

        private final Function<TimeDuration, GrpcTestClient.StreamObserverFactory> factory;

        private Type(Function<TimeDuration, GrpcTestClient.StreamObserverFactory> function) {
            this.factory = function;
        }

        GrpcTestClient.StreamObserverFactory createFunction(TimeDuration timeout) {
            return this.factory.apply(timeout);
        }
    }
}

