/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.netty.NettyUtils;
import org.apache.ratis.security.SecurityTestUtils;
import org.apache.ratis.security.TlsConf;
import org.apache.ratis.thirdparty.io.netty.bootstrap.Bootstrap;
import org.apache.ratis.thirdparty.io.netty.bootstrap.ServerBootstrap;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInboundHandler;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelOption;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.socket.SocketChannel;
import org.apache.ratis.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LogLevel;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LoggingHandler;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.ratis.util.JavaUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTlsConfWithNetty {
    private static final Logger LOG = LoggerFactory.getLogger(TestTlsConfWithNetty.class);

    static String buffer2String(ByteBuf buf) {
        try {
            String string = buf.toString(StandardCharsets.UTF_8);
            return string;
        }
        finally {
            buf.release();
        }
    }

    static ByteBuf unpooledBuffer(String s) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(s.getBytes(StandardCharsets.UTF_8));
        return buf;
    }

    static int randomPort() {
        int port = 50000 + ThreadLocalRandom.current().nextInt(10000);
        LOG.info("randomPort: {}", (Object)port);
        return port;
    }

    @Test
    public void testNoSsl() throws Exception {
        TestTlsConfWithNetty.runTest(TestTlsConfWithNetty.randomPort(), null, null);
    }

    @Test
    public void testSsl() throws Exception {
        TlsConf serverTlsConfig = SecurityTestUtils.newServerTlsConfig(true);
        TlsConf clientTlsConfig = SecurityTestUtils.newClientTlsConfig(true);
        TestTlsConfWithNetty.runTest(TestTlsConfWithNetty.randomPort(), serverTlsConfig, clientTlsConfig);
    }

    static void runTest(int port, TlsConf serverSslConf, TlsConf clientSslConf) throws Exception {
        SslContext serverSslContext = serverSslConf == null ? null : NettyUtils.buildSslContextForServer((TlsConf)serverSslConf);
        SslContext clientSslContext = clientSslConf == null ? null : NettyUtils.buildSslContextForClient((TlsConf)clientSslConf);
        String message = "Hey, how are you?";
        String[] words = "Hey, how are you?".split(" ");
        try (NettyTestServer server = new NettyTestServer(port, serverSslContext);
             NettyTestClient client = new NettyTestClient("localhost", port, clientSslContext);){
            ArrayList<CompletableFuture<String>> replyFutures = new ArrayList<CompletableFuture<String>>();
            for (String word : words) {
                ByteBuf buf = TestTlsConfWithNetty.unpooledBuffer(word + " ");
                CompletableFuture<String> f = client.writeAndFlush(buf);
                replyFutures.add(f);
            }
            for (int i = 0; i < replyFutures.size(); ++i) {
                CompletableFuture future = (CompletableFuture)replyFutures.get(i);
                String reply = (String)future.get(3L, TimeUnit.SECONDS);
                LOG.info(reply);
                Assertions.assertEquals((Object)NettyTestServer.toReply(words[i]), (Object)reply);
            }
        }
    }

    static class NettyTestClient
    implements Closeable {
        private static final Logger LOG = LoggerFactory.getLogger(NettyTestClient.class);
        private final EventLoopGroup workerGroup = new NioEventLoopGroup(3);
        private final ChannelFuture channelFuture;
        private final Queue<CompletableFuture<String>> queue = new LinkedList<CompletableFuture<String>>();

        public NettyTestClient(String host, int port, SslContext sslContext) {
            this.channelFuture = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.workerGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(this.getClass(), LogLevel.INFO))).handler(this.newChannelInitializer(sslContext, host, port))).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).connect(host, port).syncUninterruptibly();
        }

        public CompletableFuture<String> writeAndFlush(ByteBuf buf) {
            CompletableFuture<String> reply = new CompletableFuture<String>();
            this.queue.offer(reply);
            this.channelFuture.channel().writeAndFlush((Object)buf);
            return reply;
        }

        private ChannelInitializer<SocketChannel> newChannelInitializer(final SslContext sslContext, final String host, final int port) {
            return new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (sslContext != null) {
                        p.addLast("ssl", (ChannelHandler)sslContext.newHandler(ch.alloc(), host, port));
                    }
                    p.addLast(new ChannelHandler[]{this.getClientHandler()});
                }
            };
        }

        private ChannelInboundHandler getClientHandler() {
            return new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object obj) {
                    String s = TestTlsConfWithNetty.buffer2String((ByteBuf)obj);
                    LOG.info("received: " + s);
                    for (String word : s.split(" ")) {
                        ((CompletableFuture)queue.remove()).complete(word);
                    }
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                    LOG.error(this.getClass().getSimpleName() + ": exceptionCaught", cause);
                    ctx.close();
                }
            };
        }

        @Override
        public void close() {
            this.channelFuture.channel().close();
            this.workerGroup.shutdownGracefully();
        }
    }

    static class NettyTestServer
    implements Closeable {
        private static final Logger LOG = LoggerFactory.getLogger(NettyTestServer.class);
        static final String CLASS_NAME = JavaUtils.getClassSimpleName(NettyTestServer.class);
        private final EventLoopGroup bossGroup = NettyUtils.newEventLoopGroup((String)(CLASS_NAME + "-bossGroup"), (int)3, (boolean)true);
        private final EventLoopGroup workerGroup = NettyUtils.newEventLoopGroup((String)(CLASS_NAME + "-workerGroup"), (int)3, (boolean)true);
        private final ChannelFuture channelFuture;

        public NettyTestServer(int port, SslContext sslContext) {
            this.channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NettyUtils.getServerChannelClass((EventLoopGroup)this.bossGroup))).handler((ChannelHandler)new LoggingHandler(this.getClass(), LogLevel.INFO))).childHandler(this.newChannelInitializer(sslContext)).bind(port).syncUninterruptibly();
        }

        private ChannelInitializer<SocketChannel> newChannelInitializer(final SslContext sslContext) {
            return new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (sslContext != null) {
                        p.addLast("ssl", (ChannelHandler)sslContext.newHandler(ch.alloc()));
                    }
                    p.addLast(new ChannelHandler[]{this.newServerHandler()});
                }
            };
        }

        private ChannelInboundHandler newServerHandler() {
            return new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object obj) {
                    if (obj instanceof ByteBuf) {
                        String s = TestTlsConfWithNetty.buffer2String((ByteBuf)obj);
                        LOG.info("channelRead: " + s);
                        for (String word : s.split(" ")) {
                            ctx.writeAndFlush((Object)TestTlsConfWithNetty.unpooledBuffer(NettyTestServer.toReply(word) + " "));
                        }
                    }
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable throwable) {
                    LOG.error(this.getClass().getSimpleName() + ": exceptionCaught", throwable);
                    ctx.close();
                }
            };
        }

        static String toReply(String request) {
            return "[" + request + "]";
        }

        @Override
        public void close() {
            this.channelFuture.channel().close();
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
        }
    }
}

