/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.UUID;
import org.apache.ratis.BaseTest;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=1L)
public class TestRaftId
extends BaseTest {
    @Test
    public void testRaftId() {
        TestRaftId.assertRaftId(RaftId.ZERO_UUID, RaftId.ZERO_UUID_BYTESTRING);
        TestRaftId.assertRaftId(UUID.randomUUID(), null);
    }

    static void assertRaftId(UUID original, ByteString expected) {
        ByteString bytes = RaftId.toByteString((UUID)original);
        if (expected != null) {
            Assertions.assertEquals((Object)expected, (Object)bytes);
        }
        UUID computed = RaftId.toUuid((ByteString)bytes);
        Assertions.assertEquals((Object)original, (Object)computed);
        Assertions.assertEquals((Object)bytes, (Object)RaftId.toByteString((UUID)computed));
    }

    @Test
    public void testClientId() {
        ClientId id = ClientId.randomId();
        ByteString bytes = id.toByteString();
        Assertions.assertEquals((Object)bytes, (Object)id.toByteString());
        Assertions.assertEquals((Object)id, (Object)ClientId.valueOf((ByteString)bytes));
    }

    @Test
    public void testRaftGroupId() {
        RaftGroupId id = RaftGroupId.randomId();
        ByteString bytes = id.toByteString();
        Assertions.assertEquals((Object)bytes, (Object)id.toByteString());
        Assertions.assertEquals((Object)id, (Object)RaftGroupId.valueOf((ByteString)bytes));
    }

    @Test
    public void testRaftPeerId() {
        RaftPeerId id = RaftPeerId.valueOf((String)"abc");
        ByteString bytes = id.toByteString();
        Assertions.assertEquals((Object)bytes, (Object)id.toByteString());
        Assertions.assertEquals((Object)id, (Object)RaftPeerId.valueOf((ByteString)bytes));
    }
}

