/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import org.apache.ratis.BaseTest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RoutingTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;

@Timeout(value=1L)
public class TestRoutingTable
extends BaseTest {
    private final RaftPeerId[] peers = new RaftPeerId[10];

    public TestRoutingTable() {
        for (int i = 0; i < this.peers.length; ++i) {
            this.peers[i] = RaftPeerId.valueOf((String)("s" + i));
        }
    }

    @Test
    public void testRoutingTableValidation() {
        this.newRoutingTable(new int[0]);
        this.newRoutingTable(0, 1, 1, 2);
        this.newRoutingTable(0, 1, 0, 2);
        this.testFailureCase(" #edges < #vertices - 1", 0, 1, 1, 2, 3, 4);
        this.testFailureCase(" #edges > #vertices - 1", 0, 1, 1, 2, 2, 0);
        this.testFailureCase(">1 predecessors", 0, 1, 1, 2, 3, 4, 4, 1);
        this.testFailureCase("unreachable", 0, 1, 1, 2, 2, 0, 3, 4);
        this.testFailureCase("self-loop", 0, 1, 2, 3, 3, 3);
    }

    RoutingTable newRoutingTable(int ... peerIndices) {
        RoutingTable.Builder b = RoutingTable.newBuilder();
        for (int i = 0; i < peerIndices.length; i += 2) {
            b.addSuccessor(this.peers[peerIndices[i]], this.peers[peerIndices[i + 1]]);
        }
        return b.build();
    }

    void testFailureCase(String name, int ... peerIndices) {
        Assertions.assertEquals((int)0, (int)(peerIndices.length % 2));
        TestRoutingTable.testFailureCase((String)(name + ": " + this.toString(peerIndices)), () -> this.newRoutingTable(peerIndices), IllegalStateException.class, (Logger)this.LOG, (Class[])new Class[0]);
    }

    String toString(int ... peerIndices) {
        Assertions.assertEquals((int)0, (int)(peerIndices.length % 2));
        if (peerIndices.length == 0) {
            return "<empty>";
        }
        StringBuilder b = new StringBuilder();
        b.append(peerIndices[0]).append("->").append(peerIndices[1]);
        for (int i = 2; i < peerIndices.length; i += 2) {
            b.append(", ").append(peerIndices[i]).append("->").append(peerIndices[i + 1]);
        }
        return b.toString();
    }
}

