/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.MiniRaftClusterWithGrpc;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.exceptions.RaftRetryFailureException;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.retry.ExceptionDependentRetry;
import org.apache.ratis.retry.MultipleLinearRandomRetry;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.retry.TestRetryPolicy;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExceptionDependentRetry
extends BaseTest
implements MiniRaftClusterWithGrpc.FactoryGet {
    @Test
    public void testExceptionDependentRetrySuccess() {
        ExceptionDependentRetry.Builder builder = ExceptionDependentRetry.newBuilder();
        int ioExceptionRetries = 1;
        int timeoutExceptionRetries = 2;
        int defaultExceptionRetries = 5;
        long ioExceptionSleepTime = 1L;
        long timeoutExceptionSleepTime = 4L;
        long defaultExceptionSleepTime = 10L;
        int maxAttempts = 3;
        builder.setDefaultPolicy((RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)defaultExceptionRetries, (TimeDuration)TimeDuration.valueOf((long)defaultExceptionSleepTime, (TimeUnit)TimeUnit.SECONDS)));
        builder.setExceptionToPolicy(IOException.class, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)ioExceptionRetries, (TimeDuration)TimeDuration.valueOf((long)ioExceptionSleepTime, (TimeUnit)TimeUnit.SECONDS)));
        builder.setExceptionToPolicy(TimeoutIOException.class, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)timeoutExceptionRetries, (TimeDuration)TimeDuration.valueOf((long)timeoutExceptionSleepTime, (TimeUnit)TimeUnit.SECONDS)));
        builder.setMaxAttempts(maxAttempts);
        ExceptionDependentRetry exceptionDependentRetry = builder.build();
        this.testException(ioExceptionRetries, maxAttempts, exceptionDependentRetry, new IOException(), ioExceptionSleepTime);
        this.testException(timeoutExceptionRetries, maxAttempts, exceptionDependentRetry, (Exception)new TimeoutIOException("time out"), timeoutExceptionSleepTime);
        this.testException(defaultExceptionRetries, maxAttempts, exceptionDependentRetry, new TimeoutException(), defaultExceptionSleepTime);
    }

    @Test
    public void testExceptionDependentRetryFailureWithExceptionDuplicate() {
        try {
            ExceptionDependentRetry.Builder builder = ExceptionDependentRetry.newBuilder();
            builder.setExceptionToPolicy(IOException.class, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)1, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS)));
            builder.setExceptionToPolicy(IOException.class, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)1, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS)));
            Assertions.fail((String)"testExceptionDependentRetryFailure failed");
        }
        catch (Exception ex) {
            Assertions.assertEquals(IllegalStateException.class, ex.getClass());
        }
    }

    @Test
    public void testExceptionDependentRetryFailureWithExceptionMappedToNull() {
        try {
            ExceptionDependentRetry.Builder builder = ExceptionDependentRetry.newBuilder();
            builder.setExceptionToPolicy(IOException.class, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)1, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS)));
            builder.setExceptionToPolicy(IOException.class, null);
            Assertions.fail((String)"testExceptionDependentRetryFailure failed");
        }
        catch (Exception ex) {
            Assertions.assertEquals(IllegalStateException.class, ex.getClass());
        }
    }

    @Test
    public void testExceptionDependentRetryFailureWithNoDefault() {
        ExceptionDependentRetry.Builder builder;
        try {
            builder = ExceptionDependentRetry.newBuilder();
            builder.setExceptionToPolicy(IOException.class, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)1, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS)));
            builder.build();
            Assertions.fail((String)"testExceptionDependentRetryFailureWithNoDefault failed");
        }
        catch (Exception ex) {
            Assertions.assertEquals(IllegalStateException.class, ex.getClass());
        }
        try {
            builder = ExceptionDependentRetry.newBuilder();
            builder.setExceptionToPolicy(IOException.class, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)1, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS)));
            builder.setDefaultPolicy(null);
            Assertions.fail((String)"testExceptionDependentRetryFailureWithNoDefault failed");
        }
        catch (Exception ex) {
            Assertions.assertEquals(IllegalStateException.class, ex.getClass());
        }
    }

    private void testException(int retries, int maxAttempts, ExceptionDependentRetry exceptionDependentRetry, Exception exception, long sleepTime) {
        for (int i = 0; i < retries + 1; ++i) {
            RetryPolicy.Action action = exceptionDependentRetry.handleAttemptFailure((RetryPolicy.Event)TestRetryPolicy.newClientRetryEvent(i, null, exception));
            boolean expected = i < retries && i < maxAttempts;
            Assertions.assertEquals((Object)expected, (Object)action.shouldRetry());
            if (expected) {
                Assertions.assertEquals((long)sleepTime, (long)action.getSleepTime().getDuration());
                continue;
            }
            Assertions.assertEquals((long)0L, (long)action.getSleepTime().getDuration());
        }
    }

    @Test
    public void testExceptionRetryAttempts() throws Exception {
        RaftProperties prop = this.getProperties();
        RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)prop, (TimeDuration)TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS));
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        RaftServerConfigKeys.Write.setElementLimit((RaftProperties)prop, (int)1);
        this.runWithNewCluster(1, this::runTestExceptionRetryAttempts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestExceptionRetryAttempts(MiniRaftClusterWithGrpc cluster) throws Exception {
        int retryCount = 5;
        MultipleLinearRandomRetry timeoutPolicy = MultipleLinearRandomRetry.parseCommaSeparated((String)"1ms, 5");
        ExceptionDependentRetry policy = ExceptionDependentRetry.newBuilder().setExceptionToPolicy(TimeoutIOException.class, (RetryPolicy)timeoutPolicy).setDefaultPolicy(RetryPolicies.retryForeverNoSleep()).build();
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        try (RaftClient client = cluster.createClient((RetryPolicy)policy);){
            client.async().send((Message)new RaftTestUtil.SimpleMessage("1")).get();
        }
        try {
            client = cluster.createClient((RetryPolicy)policy);
            var7_8 = null;
            try {
                SimpleStateMachine4Testing.get((RaftServer.Division)leader).blockWriteStateMachineData();
                client.async().send((Message)new RaftTestUtil.SimpleMessage("2")).get();
                Assertions.fail((String)"Test should have failed.");
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (var7_8 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            var7_8.addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (ExecutionException e) {
            RaftRetryFailureException rrfe = (RaftRetryFailureException)e.getCause();
            int expectedCount = 6;
            Assertions.assertEquals((int)6, (int)rrfe.getAttemptCount());
        }
        finally {
            SimpleStateMachine4Testing.get((RaftServer.Division)leader).unblockWriteStateMachineData();
            cluster.shutdown();
        }
    }
}

