/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.retry.ExponentialBackoffRetry;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExponentialBackoffRetry
extends BaseTest {
    @Test
    public void testExponentialBackoffRetry() {
        TimeDuration baseSleep = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS);
        TimeDuration maxSleep = TimeDuration.valueOf((long)40L, (TimeUnit)TimeUnit.SECONDS);
        ExponentialBackoffRetry retryPolicy = this.createPolicy(baseSleep, null, 1);
        Assertions.assertFalse((boolean)retryPolicy.handleAttemptFailure(() -> 1).shouldRetry());
        try {
            this.createPolicy(null, null, 1);
            Assertions.fail((String)"Policy creation should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        retryPolicy = this.createPolicy(baseSleep, null, 100);
        this.assertSleep(retryPolicy, baseSleep, null);
        retryPolicy = this.createPolicy(baseSleep, maxSleep, 100);
        this.assertSleep(retryPolicy, baseSleep, maxSleep);
    }

    private void assertSleep(ExponentialBackoffRetry retryPolicy, TimeDuration baseSleep, TimeDuration maxSleep) {
        for (int i = 1; i <= 50; ++i) {
            int attempt = i;
            RetryPolicy.Action action = retryPolicy.handleAttemptFailure(() -> attempt);
            long d = (1L << attempt) * baseSleep.toLong(TimeUnit.MILLISECONDS);
            d = Math.min(d, maxSleep != null ? maxSleep.toLong(TimeUnit.MILLISECONDS) : Long.MAX_VALUE);
            long randomizedDuration = action.getSleepTime().toLong(TimeUnit.MILLISECONDS);
            Assertions.assertTrue((boolean)action.shouldRetry());
            Assertions.assertTrue(((double)randomizedDuration >= (double)d * 0.5 ? 1 : 0) != 0);
            Assertions.assertTrue(((double)randomizedDuration <= (double)d * 1.5 ? 1 : 0) != 0);
        }
    }

    private ExponentialBackoffRetry createPolicy(TimeDuration baseSleep, TimeDuration maxSleep, int maxAttempts) {
        return ExponentialBackoffRetry.newBuilder().setBaseSleepTime(baseSleep).setMaxAttempts(maxAttempts).setMaxSleepTime(maxSleep).build();
    }
}

