/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import org.apache.ratis.BaseTest;
import org.apache.ratis.retry.MultipleLinearRandomRetry;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMultipleLinearRandomRetry
extends BaseTest {
    public int getGlobalTimeoutSeconds() {
        return 1;
    }

    @Test
    public void testParseCommaSeparated() {
        TestMultipleLinearRandomRetry.assertIllegalInput("");
        TestMultipleLinearRandomRetry.assertIllegalInput("11");
        TestMultipleLinearRandomRetry.assertIllegalInput("11,22,33");
        TestMultipleLinearRandomRetry.assertIllegalInput("11,22,33,44,55");
        TestMultipleLinearRandomRetry.assertIllegalInput("AA");
        TestMultipleLinearRandomRetry.assertIllegalInput("11,AA");
        TestMultipleLinearRandomRetry.assertIllegalInput("11,22,33,FF");
        TestMultipleLinearRandomRetry.assertIllegalInput("11,-22");
        TestMultipleLinearRandomRetry.assertIllegalInput("-11,22");
        TestMultipleLinearRandomRetry.assertLegalInput("[22x11ms]", "11,22");
        TestMultipleLinearRandomRetry.assertLegalInput("[22x11ms, 44x33s]", "1_1ms,22,33s,4_4");
        TestMultipleLinearRandomRetry.assertLegalInput("[22x11ms, 44x33ms, 66x55ms]", "11,2_2,33_MS,44,55,66");
        TestMultipleLinearRandomRetry.assertLegalInput("[22x11s, 44x33ms, 66x55ms]", "   11s,   22, 33,  44, 55__MS,  6_6   ");
        TestMultipleLinearRandomRetry.assertLegalInput("[10x100ms, 20x1s, 30x5s]", "100,10, 1s,20, 5s,30");
    }

    private static void assertIllegalInput(String input) {
        MultipleLinearRandomRetry computed = MultipleLinearRandomRetry.parseCommaSeparated((String)input);
        Assertions.assertNull((Object)computed);
    }

    private static MultipleLinearRandomRetry assertLegalInput(String expected, String input) {
        MultipleLinearRandomRetry computed = MultipleLinearRandomRetry.parseCommaSeparated((String)input);
        Assertions.assertNotNull((Object)computed);
        Assertions.assertTrue((boolean)computed.toString().endsWith(expected));
        return computed;
    }

    @Test
    public void testMultipleLinearRandomRetry() {
        double precision = 1.0E-8;
        int[] counts = new int[]{10, 20, 30};
        TimeDuration[] times = new TimeDuration[]{HUNDRED_MILLIS, ONE_SECOND, FIVE_SECONDS};
        MultipleLinearRandomRetry r = TestMultipleLinearRandomRetry.assertLegalInput("[10x100ms, 20x1s, 30x5s]", "100ms,10, 1s,20, 5s,30");
        int k = 0;
        for (int i = 0; i < counts.length; ++i) {
            for (int j = 1; j <= counts[i]; ++j) {
                int attempt = ++k;
                RetryPolicy.Action action = r.handleAttemptFailure(() -> attempt);
                Assertions.assertTrue((boolean)action.shouldRetry());
                TimeDuration randomized = action.getSleepTime();
                TimeDuration expected = times[i].to(randomized.getUnit());
                long d = expected.getDuration();
                this.LOG.info("times[{},{}] = {}, randomized={}", new Object[]{i, j, times[i], randomized});
                Assertions.assertTrue(((double)randomized.getDuration() >= (double)d * 0.5 ? 1 : 0) != 0);
                Assertions.assertTrue(((double)randomized.getDuration() < (double)d * 1.5 + precision ? 1 : 0) != 0);
            }
        }
        int attempt = ++k;
        RetryPolicy.Action action = r.handleAttemptFailure(() -> attempt);
        Assertions.assertFalse((boolean)action.shouldRetry());
    }
}

