/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.client.retry.ClientRetryEvent;
import org.apache.ratis.client.retry.RequestTypeDependentRetryPolicy;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.ResourceUnavailableException;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.retry.ExceptionDependentRetry;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRetryPolicy
extends BaseTest {
    public int getGlobalTimeoutSeconds() {
        return 1;
    }

    @Test
    public void testRetryMultipleTimesWithFixedSleep() {
        int n = 4;
        TimeDuration sleepTime = HUNDRED_MILLIS;
        RetryPolicies.RetryLimited policy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)4, (TimeDuration)sleepTime);
        for (int i = 1; i < 8; ++i) {
            int attempt = i;
            RetryPolicy.Event event = () -> attempt;
            RetryPolicy.Action action = policy.handleAttemptFailure(event);
            boolean expected = i < 4;
            Assertions.assertEquals((Object)expected, (Object)action.shouldRetry());
            if (expected) {
                Assertions.assertEquals((Object)sleepTime, (Object)action.getSleepTime());
                continue;
            }
            Assertions.assertEquals((long)0L, (long)action.getSleepTime().getDuration());
        }
    }

    static ClientRetryEvent newClientRetryEvent(int attemptCount, RaftClientRequest request, Throwable cause) {
        return new ClientRetryEvent(attemptCount, request, attemptCount, cause, Timestamp.currentTime());
    }

    @Test
    public void testRequestTypeDependentRetry() {
        RequestTypeDependentRetryPolicy.Builder b = RequestTypeDependentRetryPolicy.newBuilder();
        int n = 4;
        TimeDuration writeSleep = HUNDRED_MILLIS;
        RetryPolicies.RetryLimited writePolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)4, (TimeDuration)writeSleep);
        b.setRetryPolicy(RaftProtos.RaftClientRequestProto.TypeCase.WRITE, (RetryPolicy)writePolicy);
        b.setRetryPolicy(RaftProtos.RaftClientRequestProto.TypeCase.WATCH, RetryPolicies.noRetry());
        RequestTypeDependentRetryPolicy policy = b.build();
        this.LOG.info("policy = {}", (Object)policy);
        RaftClientRequest staleReadRequest = TestRetryPolicy.newRaftClientRequest(RaftClientRequest.staleReadRequestType((long)1L));
        RaftClientRequest readRequest = TestRetryPolicy.newRaftClientRequest(RaftClientRequest.readRequestType());
        RaftClientRequest writeRequest = TestRetryPolicy.newRaftClientRequest(RaftClientRequest.writeRequestType());
        RaftClientRequest watchRequest = TestRetryPolicy.newRaftClientRequest(RaftClientRequest.watchRequestType((long)1L, (RaftProtos.ReplicationLevel)RaftProtos.ReplicationLevel.MAJORITY));
        for (int i = 1; i < 8; ++i) {
            ClientRetryEvent event = TestRetryPolicy.newClientRetryEvent(i, writeRequest, null);
            RetryPolicy.Action action = policy.handleAttemptFailure((RetryPolicy.Event)event);
            boolean expected = i < 4;
            Assertions.assertEquals((Object)expected, (Object)action.shouldRetry());
            if (expected) {
                Assertions.assertEquals((Object)writeSleep, (Object)action.getSleepTime());
            } else {
                Assertions.assertEquals((long)0L, (long)action.getSleepTime().getDuration());
            }
            event = TestRetryPolicy.newClientRetryEvent(i, readRequest, null);
            action = policy.handleAttemptFailure((RetryPolicy.Event)event);
            Assertions.assertTrue((boolean)action.shouldRetry());
            Assertions.assertEquals((long)0L, (long)action.getSleepTime().getDuration());
            event = TestRetryPolicy.newClientRetryEvent(i, staleReadRequest, null);
            action = policy.handleAttemptFailure((RetryPolicy.Event)event);
            Assertions.assertTrue((boolean)action.shouldRetry());
            Assertions.assertEquals((long)0L, (long)action.getSleepTime().getDuration());
            event = TestRetryPolicy.newClientRetryEvent(i, watchRequest, null);
            action = policy.handleAttemptFailure((RetryPolicy.Event)event);
            Assertions.assertFalse((boolean)action.shouldRetry());
            Assertions.assertEquals((long)0L, (long)action.getSleepTime().getDuration());
        }
    }

    @Test
    public void testRequestTypeDependentRetryWithTimeout() throws InterruptedException {
        RetryPolicy.Action action;
        ClientRetryEvent event;
        RequestTypeDependentRetryPolicy.Builder b = RequestTypeDependentRetryPolicy.newBuilder();
        b.setRetryPolicy(RaftProtos.RaftClientRequestProto.TypeCase.WRITE, RetryPolicies.retryForeverNoSleep());
        b.setRetryPolicy(RaftProtos.RaftClientRequestProto.TypeCase.WATCH, RetryPolicies.retryForeverNoSleep());
        TimeDuration timeout = TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        RequestTypeDependentRetryPolicy policy = b.setTimeout(RaftProtos.RaftClientRequestProto.TypeCase.WRITE, timeout).setTimeout(RaftProtos.RaftClientRequestProto.TypeCase.WATCH, timeout).build();
        this.LOG.info("policy = {}", (Object)policy);
        RaftClientRequest writeRequest = TestRetryPolicy.newRaftClientRequest(RaftClientRequest.writeRequestType());
        RaftClientRequest watchRequest = TestRetryPolicy.newRaftClientRequest(RaftClientRequest.watchRequestType((long)1L, (RaftProtos.ReplicationLevel)RaftProtos.ReplicationLevel.MAJORITY));
        RaftClientRequest[] requests = new RaftClientRequest[]{writeRequest, watchRequest};
        RaftClientImpl.PendingClientRequest pending = new RaftClientImpl.PendingClientRequest(){

            public RaftClientRequest newRequestImpl() {
                return null;
            }
        };
        for (RaftClientRequest request : requests) {
            event = pending.newClientRetryEvent(request, (Throwable)new Exception());
            action = policy.handleAttemptFailure((RetryPolicy.Event)event);
            Assertions.assertTrue((boolean)action.shouldRetry());
            Assertions.assertEquals((long)0L, (long)action.getSleepTime().getDuration());
        }
        timeout.sleep();
        for (RaftClientRequest request : requests) {
            event = pending.newClientRetryEvent(request, (Throwable)new Exception());
            action = policy.handleAttemptFailure((RetryPolicy.Event)event);
            Assertions.assertFalse((boolean)action.shouldRetry());
        }
    }

    @Test
    public void testRequestTypeDependentRetryWithExceptionDependentPolicy() throws Exception {
        RequestTypeDependentRetryPolicy.Builder retryPolicy = RequestTypeDependentRetryPolicy.newBuilder();
        HashMap<Class<? extends Throwable>, Pair> exceptionPolicyMap = new HashMap<Class<? extends Throwable>, Pair>();
        exceptionPolicyMap.put(NotLeaderException.class, new Pair(10, 1L));
        exceptionPolicyMap.put(LeaderNotReadyException.class, new Pair(10, 1L));
        exceptionPolicyMap.put(TimeoutIOException.class, new Pair(5, 5L));
        exceptionPolicyMap.put(ResourceUnavailableException.class, new Pair(5, 5L));
        Pair defaultPolicy = new Pair(10, 2L);
        retryPolicy.setRetryPolicy(RaftProtos.RaftClientRequestProto.TypeCase.WRITE, (RetryPolicy)this.buildExceptionBasedRetry(exceptionPolicyMap, defaultPolicy));
        retryPolicy.setRetryPolicy(RaftProtos.RaftClientRequestProto.TypeCase.WATCH, (RetryPolicy)this.buildExceptionBasedRetry(exceptionPolicyMap, defaultPolicy));
        RequestTypeDependentRetryPolicy policy = retryPolicy.build();
        this.LOG.info("policy = {}", (Object)policy);
        RaftClientRequest writeRequest = TestRetryPolicy.newRaftClientRequest(RaftClientRequest.writeRequestType());
        RaftClientRequest watchRequest = TestRetryPolicy.newRaftClientRequest(RaftClientRequest.watchRequestType((long)1L, (RaftProtos.ReplicationLevel)RaftProtos.ReplicationLevel.MAJORITY));
        ArrayList<RaftClientRequest> requests = new ArrayList<RaftClientRequest>();
        requests.add(writeRequest);
        requests.add(watchRequest);
        for (RaftClientRequest raftClientRequest : requests) {
            for (Map.Entry exceptionPolicy : exceptionPolicyMap.entrySet()) {
                Throwable exception = this.createException((Class)exceptionPolicy.getKey());
                for (int j = 1; j < ((Pair)exceptionPolicy.getValue()).retries * 2; ++j) {
                    this.checkEvent(j, (RetryPolicy)policy, raftClientRequest, exception, (Pair)exceptionPolicy.getValue());
                }
            }
        }
        for (RaftClientRequest raftClientRequest : requests) {
            Throwable exception = this.createException(IOException.class);
            for (int j = 1; j < defaultPolicy.retries * 2; ++j) {
                this.checkEvent(j, (RetryPolicy)policy, raftClientRequest, exception, defaultPolicy);
            }
        }
    }

    private void checkEvent(int exceptionAttemptCount, RetryPolicy retryPolicy, RaftClientRequest raftClientRequest, Throwable exception, Pair exceptionPolicyPair) {
        ClientRetryEvent event = TestRetryPolicy.newClientRetryEvent(exceptionAttemptCount, raftClientRequest, exception);
        RetryPolicy.Action action = retryPolicy.handleAttemptFailure((RetryPolicy.Event)event);
        boolean expected = exceptionAttemptCount < exceptionPolicyPair.retries;
        Assertions.assertEquals((Object)expected, (Object)action.shouldRetry());
        if (expected) {
            Assertions.assertEquals((long)exceptionPolicyPair.sleepTime, (long)action.getSleepTime().getDuration());
        } else {
            Assertions.assertEquals((long)0L, (long)action.getSleepTime().getDuration());
        }
    }

    private Throwable createException(Class<? extends Throwable> exception) {
        Object ex = exception.getName().equals(LeaderNotReadyException.class.getName()) ? new LeaderNotReadyException(RaftGroupMemberId.valueOf((RaftPeerId)RaftPeerId.valueOf((String)"node1"), (RaftGroupId)RaftGroupId.randomId())) : (exception.getName().equals(NotLeaderException.class.getName()) ? new NotLeaderException(null, null, null) : (exception.getName().equals(TimeoutIOException.class.getName()) ? new TimeoutIOException("time out") : (exception.getName().equals(ResourceUnavailableException.class.getName()) ? new ResourceUnavailableException("resource unavailable") : new IOException("io exception"))));
        return ex;
    }

    private ExceptionDependentRetry buildExceptionBasedRetry(Map<Class<? extends Throwable>, Pair> exceptionPolicyMap, Pair defaultPolicy) {
        ExceptionDependentRetry.Builder policy = ExceptionDependentRetry.newBuilder();
        exceptionPolicyMap.forEach((k, v) -> policy.setExceptionToPolicy(k, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)((Pair)v).retries, (TimeDuration)TimeDuration.valueOf((long)((Pair)v).sleepTime, (TimeUnit)TimeUnit.SECONDS))));
        policy.setDefaultPolicy((RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)defaultPolicy.retries, (TimeDuration)TimeDuration.valueOf((long)defaultPolicy.sleepTime, (TimeUnit)TimeUnit.SECONDS)));
        return policy.build();
    }

    private static RaftClientRequest newRaftClientRequest(RaftClientRequest.Type type) {
        return RaftClientRequest.newBuilder().setClientId(ClientId.randomId()).setServerId(RaftPeerId.valueOf((String)"s0")).setGroupId(RaftGroupId.randomId()).setCallId(1L).setType(type).build();
    }

    static class Pair {
        private int retries;
        private long sleepTime;

        Pair(int retries, long sleepTime) {
            this.retries = retries;
            this.sleepTime = sleepTime;
        }
    }
}

