/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.security;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.OpenOption;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.ratis.security.TlsConf;
import org.apache.ratis.util.FileUtils;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SecurityTestUtils {
    public static final Logger LOG = LoggerFactory.getLogger(SecurityTestUtils.class);
    public static final ClassLoader CLASS_LOADER = SecurityTestUtils.class.getClassLoader();
    public static final TrustManager EMPTY_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    };

    public static TrustManager emptyTrustManager() {
        return EMPTY_TRUST_MANAGER;
    }

    public static File getResource(String name) {
        File file = Optional.ofNullable(CLASS_LOADER.getResource(name)).map(URL::getFile).map(File::new).orElse(null);
        LOG.info("Getting resource {}: {}", (Object)name, (Object)file);
        return file;
    }

    public static TlsConf newServerTlsConfig(boolean mutualAuthn) {
        LOG.info("newServerTlsConfig: mutualAuthn? {}", (Object)mutualAuthn);
        return new TlsConf.Builder().setName("server").setPrivateKey(new TlsConf.PrivateKeyConf(SecurityTestUtils.getResource("ssl/server.pem"))).setKeyCertificates(new TlsConf.CertificatesConf(SecurityTestUtils.getResource("ssl/server.crt"))).setTrustCertificates(new TlsConf.CertificatesConf(SecurityTestUtils.getResource("ssl/client.crt"))).setMutualTls(mutualAuthn).build();
    }

    public static TlsConf newClientTlsConfig(boolean mutualAuthn) {
        LOG.info("newClientTlsConfig: mutualAuthn? {}", (Object)mutualAuthn);
        return new TlsConf.Builder().setName("client").setPrivateKey(new TlsConf.PrivateKeyConf(SecurityTestUtils.getResource("ssl/client.pem"))).setKeyCertificates(new TlsConf.CertificatesConf(SecurityTestUtils.getResource("ssl/client.crt"))).setTrustCertificates(new TlsConf.CertificatesConf(SecurityTestUtils.getResource("ssl/ca.crt"))).setMutualTls(mutualAuthn).build();
    }

    public static PrivateKey getPrivateKey(String keyPath) {
        try {
            File file = SecurityTestUtils.getResource(keyPath);
            FileReader keyReader = new FileReader(file);
            PemReader pemReader = new PemReader((Reader)keyReader);
            PemObject pemObject = pemReader.readPemObject();
            pemReader.close();
            keyReader.close();
            byte[] content = pemObject.getContent();
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(content);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(privKeySpec);
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to get private key from " + keyPath + ". Error: " + e.getMessage()));
            return null;
        }
    }

    public static X509Certificate[] getCertificate(String certPath) {
        try {
            X509Certificate[] certificate = new X509Certificate[1];
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            try (InputStream is = FileUtils.newInputStream((File)SecurityTestUtils.getResource(certPath), (OpenOption[])new OpenOption[0]);){
                certificate[0] = (X509Certificate)fact.generateCertificate(is);
            }
            return certificate;
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to get certificate from " + certPath + ". Error: " + e.getMessage()));
            return null;
        }
    }

    public static KeyStore getServerKeyStore() {
        try {
            PrivateKey privateKey = SecurityTestUtils.getPrivateKey("ssl/server.pem");
            Certificate[] certificate = SecurityTestUtils.getCertificate("ssl/server.crt");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setKeyEntry("ratis-server-key", privateKey, new char[0], certificate);
            return keyStore;
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to get sever key store " + e.getMessage()));
            return null;
        }
    }

    public static KeyStore getClientKeyStore() {
        try {
            PrivateKey privateKey = SecurityTestUtils.getPrivateKey("ssl/client.pem");
            Certificate[] certificate = SecurityTestUtils.getCertificate("ssl/client.crt");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setKeyEntry("ratis-client-key", privateKey, new char[0], certificate);
            return keyStore;
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to get client key store " + e.getMessage()));
            return null;
        }
    }

    public static KeyStore getTrustStore() {
        try {
            X509Certificate[] certificate = SecurityTestUtils.getCertificate("ssl/ca.crt");
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            for (X509Certificate cert : certificate) {
                trustStore.setCertificateEntry(cert.getSerialNumber().toString(), cert);
            }
            return trustStore;
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to get sever key store " + e.getMessage()));
            return null;
        }
    }

    public static KeyManager getKeyManager(Supplier<KeyStore> supplier) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keyStore = supplier.get();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, new char[0]);
        KeyManager[] managers = keyManagerFactory.getKeyManagers();
        return managers[0];
    }

    public static X509TrustManager getTrustManager(Supplier<KeyStore> supplier) throws KeyStoreException, NoSuchAlgorithmException {
        KeyStore keyStore = supplier.get();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        return (X509TrustManager)trustManagers[0];
    }
}

