/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server;

import java.io.IOException;
import org.apache.ratis.BaseTest;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.util.Preconditions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServerBuilderTest
extends BaseTest {
    @Test
    public void testPeerIdInRaftGroup() throws Exception {
        RaftPeer peer = RaftPeer.newBuilder().setId("n0").build();
        RaftGroup group = RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), (RaftPeer[])new RaftPeer[]{peer});
        RaftServer server = RaftServer.newBuilder().setServerId(peer.getId()).setGroup(group).setStateMachine((StateMachine)new BaseStateMachine()).setProperties(new RaftProperties()).build();
        server.close();
    }

    @Test
    public void testPeerIdNotInRaftGroup() {
        RaftPeer peer = RaftPeer.newBuilder().setId("n0").build();
        RaftGroup group = RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), (RaftPeer[])new RaftPeer[]{peer});
        try {
            RaftServer.newBuilder().setServerId(RaftPeerId.valueOf((String)"n1")).setGroup(group).setStateMachine((StateMachine)new BaseStateMachine()).setProperties(new RaftProperties()).build();
            Assertions.fail((String)"did not get expected exception");
        }
        catch (IOException e) {
            Preconditions.assertInstanceOf((Object)e.getCause(), IllegalStateException.class);
        }
    }

    @Test
    public void testNullPeerIdWithRaftGroup() {
        RaftPeer peer = RaftPeer.newBuilder().setId("n0").build();
        RaftGroup group = RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), (RaftPeer[])new RaftPeer[]{peer});
        try {
            RaftServer.newBuilder().setGroup(group).setStateMachine((StateMachine)new BaseStateMachine()).setProperties(new RaftProperties()).build();
            Assertions.fail((String)"did not get expected exception");
        }
        catch (IOException e) {
            Preconditions.assertInstanceOf((Object)e.getCause(), IllegalStateException.class);
        }
    }

    @Test
    public void testPeerIdWithNullRaftGroup() throws Exception {
        RaftPeer peer = RaftPeer.newBuilder().setId("n0").build();
        RaftServer server = RaftServer.newBuilder().setServerId(peer.getId()).setStateMachine((StateMachine)new BaseStateMachine()).setProperties(new RaftProperties()).build();
        server.close();
    }

    @Test
    public void testNullPeerIdWithNullRaftGroup() throws Exception {
        RaftServer server = RaftServer.newBuilder().setStateMachine((StateMachine)new BaseStateMachine()).setProperties(new RaftProperties()).build();
        server.close();
    }
}

