/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ratis.BaseTest;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRaftServerConfigKeys {
    private static final Supplier<File> ROOT_TEST_DIR = JavaUtils.memoize(() -> new File(BaseTest.getRootTestDir(), JavaUtils.getClassSimpleName(TestRaftServerConfigKeys.class) + Integer.toHexString(ThreadLocalRandom.current().nextInt())));

    @AfterAll
    public static void tearDown() throws IOException {
        FileUtils.deleteFully((File)ROOT_TEST_DIR.get());
    }

    @Test
    public void testStorageDirProperty() {
        File testDir = new File(ROOT_TEST_DIR.get(), UUID.randomUUID().toString());
        ArrayList directories = new ArrayList();
        RaftProperties properties = new RaftProperties();
        IntStream.range(0, 10).mapToObj(i -> new File(testDir, Integer.toString(i))).forEach(directories::add);
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, directories);
        String expected = directories.stream().map(File::getAbsolutePath).collect(Collectors.joining(","));
        String actual = properties.get("raft.server.storage.dir");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testStorageDir() {
        File testDir = new File(ROOT_TEST_DIR.get(), UUID.randomUUID().toString());
        ArrayList directories = new ArrayList();
        IntStream.range(0, 10).mapToObj(i -> new File(testDir, Integer.toString(i))).forEach(directories::add);
        RaftProperties properties = new RaftProperties();
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, directories);
        List storageDirs = RaftServerConfigKeys.storageDir((RaftProperties)properties);
        List expectedDirs = directories.stream().map(File::getAbsolutePath).collect(Collectors.toList());
        List actualDirs = storageDirs.stream().map(File::getAbsolutePath).collect(Collectors.toList());
        actualDirs.removeAll(expectedDirs);
        Assertions.assertEquals((int)directories.size(), (int)storageDirs.size());
        Assertions.assertEquals((int)0, (int)actualDirs.size());
    }

    @Test
    public void testPendingRequestSize() {
        RaftProperties properties = new RaftProperties();
        ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)"raft.server.write.byte-limit", (SizeInBytes)SizeInBytes.valueOf((String)"4gb"), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((long)1L)});
        int pendingRequestMegabyteLimit = Math.toIntExact(RaftServerConfigKeys.Write.byteLimit((RaftProperties)properties).getSize() / SizeInBytes.ONE_MB.getSize());
        Assertions.assertEquals((int)4096, (int)pendingRequestMegabyteLimit);
    }
}

