/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.ratis.BaseTest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.PeerConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPeerConfiguration
extends BaseTest {
    @Test
    public void testPeerConfiguration() {
        RaftPeer[] peers = new RaftPeer[]{RaftPeer.newBuilder().setId("s0").build(), RaftPeer.newBuilder().setId("s1").build(), RaftPeer.newBuilder().setId("s0").build()};
        this.testFailureCase("Duplicated peers", () -> new PeerConfiguration(Arrays.asList(peers)), IllegalArgumentException.class, new Class[0]);
    }

    @Test
    public void testOddNodesQuorum() {
        String localId = "0";
        String node1 = "1";
        String node2 = "2";
        PeerConfiguration conf = new PeerConfiguration(this.raftPeers(localId, node1, node2));
        Assertions.assertTrue((boolean)conf.hasMajority(this.raftPeerIds(node1), RaftPeerId.valueOf((String)localId)));
        Assertions.assertFalse((boolean)conf.majorityRejectVotes(this.raftPeerIds(node1)));
    }

    @Test
    public void testEvenNodeQuorum() {
        String localId = "0";
        String node1 = "1";
        String node2 = "2";
        String node3 = "3";
        PeerConfiguration conf = new PeerConfiguration(this.raftPeers(localId, node1, node2, node3));
        Assertions.assertFalse((boolean)conf.hasMajority(this.raftPeerIds(node1), RaftPeerId.valueOf((String)localId)));
        Assertions.assertTrue((boolean)conf.hasMajority(this.raftPeerIds(node1, node2), RaftPeerId.valueOf((String)localId)));
        Assertions.assertFalse((boolean)conf.majorityRejectVotes(this.raftPeerIds(node1)));
        Assertions.assertTrue((boolean)conf.majorityRejectVotes(this.raftPeerIds(node1, node2)));
    }

    private Collection<RaftPeer> raftPeers(String ... voters) {
        return Arrays.stream(voters).map(id -> RaftPeer.newBuilder().setId(id).build()).collect(Collectors.toSet());
    }

    private Collection<RaftPeerId> raftPeerIds(String ... voters) {
        return Arrays.stream(voters).map(RaftPeerId::valueOf).collect(Collectors.toSet());
    }
}

