/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.ratis.BaseTest;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.impl.PeerConfiguration;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRaftConfiguration
extends BaseTest {
    @Test
    public void testIsHighestPriority() {
        Integer node1 = 0;
        Integer node2 = 1;
        Integer node3 = 2;
        PeerConfiguration peerConfig = new PeerConfiguration(this.raftPeersWithPriority(node1, node2, node3));
        RaftConfigurationImpl config = RaftConfigurationImpl.newBuilder().setConf(peerConfig).build();
        RaftPeer[] allRaftPeers = peerConfig.getPeers(RaftProtos.RaftPeerRole.FOLLOWER).toArray(new RaftPeer[peerConfig.getPeers(RaftProtos.RaftPeerRole.FOLLOWER).size()]);
        Assertions.assertFalse((boolean)RaftServerTestUtil.isHighestPriority((RaftConfiguration)config, (RaftPeerId)allRaftPeers[0].getId()));
        Assertions.assertTrue((boolean)RaftServerTestUtil.isHighestPriority((RaftConfiguration)config, (RaftPeerId)allRaftPeers[allRaftPeers.length - 1].getId()));
        Assertions.assertFalse((boolean)RaftServerTestUtil.isHighestPriority((RaftConfiguration)config, (RaftPeerId)RaftPeerId.valueOf((String)"123456789")));
    }

    private Collection<RaftPeer> raftPeersWithPriority(Integer ... voters) {
        return Arrays.stream(voters).map(id -> RaftPeer.newBuilder().setPriority(id.intValue()).setId(id.toString()).build()).collect(Collectors.toSet());
    }

    @Test
    public void testSingleMode() {
        RaftConfigurationImpl config = RaftConfigurationImpl.newBuilder().setConf(new PeerConfiguration(this.raftPeersWithPriority(1))).build();
        Assertions.assertTrue((boolean)config.isSingleMode(RaftPeerId.valueOf((String)"1")), (String)"Peer is in single mode.");
        config = RaftConfigurationImpl.newBuilder().setConf(new PeerConfiguration(this.raftPeersWithPriority(0, 1))).setOldConf(new PeerConfiguration(this.raftPeersWithPriority(0))).build();
        Assertions.assertTrue((boolean)config.isSingleMode(RaftPeerId.valueOf((String)"0")), (String)"Peer is in single mode.");
        Assertions.assertFalse((boolean)config.isSingleMode(RaftPeerId.valueOf((String)"1")), (String)"Peer is a new peer");
        config = RaftConfigurationImpl.newBuilder().setConf(new PeerConfiguration(this.raftPeersWithPriority(0, 1))).build();
        Assertions.assertFalse((boolean)config.isSingleMode(RaftPeerId.valueOf((String)"0")), (String)"Peer is in ha mode.");
        Assertions.assertFalse((boolean)config.isSingleMode(RaftPeerId.valueOf((String)"1")), (String)"Peer is in ha mode.");
        config = RaftConfigurationImpl.newBuilder().setConf(new PeerConfiguration(this.raftPeersWithPriority(0, 1))).setOldConf(new PeerConfiguration(this.raftPeersWithPriority(2, 3))).build();
        Assertions.assertFalse((boolean)config.isSingleMode(RaftPeerId.valueOf((String)"0")), (String)"Peer is in ha mode.");
        Assertions.assertFalse((boolean)config.isSingleMode(RaftPeerId.valueOf((String)"1")), (String)"Peer is in ha mode.");
        Assertions.assertFalse((boolean)config.isSingleMode(RaftPeerId.valueOf((String)"3")), (String)"Peer is in ha mode.");
        Assertions.assertFalse((boolean)config.isSingleMode(RaftPeerId.valueOf((String)"4")), (String)"Peer is in ha mode.");
    }

    @Test
    public void testChangeMajority() {
        RaftConfigurationImpl config = RaftConfigurationImpl.newBuilder().setConf(new PeerConfiguration(this.raftPeersWithPriority(1))).build();
        Assertions.assertFalse((boolean)config.changeMajority(this.raftPeersWithPriority(1, 2)), (String)"Change from single mode to ha mode is not considered as changing majority.");
        Assertions.assertTrue((boolean)config.changeMajority(this.raftPeersWithPriority(2)));
        config = RaftConfigurationImpl.newBuilder().setConf(new PeerConfiguration(this.raftPeersWithPriority(1, 2, 3))).build();
        Assertions.assertTrue((boolean)config.changeMajority(this.raftPeersWithPriority(1, 2, 4, 5)));
        config = RaftConfigurationImpl.newBuilder().setConf(new PeerConfiguration(this.raftPeersWithPriority(1, 2, 3))).build();
        Assertions.assertTrue((boolean)config.changeMajority(this.raftPeersWithPriority(1, 4, 5)));
        config = RaftConfigurationImpl.newBuilder().setConf(new PeerConfiguration(this.raftPeersWithPriority(1, 2, 3))).build();
        Assertions.assertFalse((boolean)config.changeMajority(this.raftPeersWithPriority(1, 2, 3, 4, 5)));
        config = RaftConfigurationImpl.newBuilder().setConf(new PeerConfiguration(this.raftPeersWithPriority(1, 2, 3, 4, 5))).build();
        Assertions.assertFalse((boolean)config.changeMajority(this.raftPeersWithPriority(1, 2)));
        config = RaftConfigurationImpl.newBuilder().setConf(new PeerConfiguration(this.raftPeersWithPriority(1, 2, 3, 4, 5))).build();
        Assertions.assertFalse((boolean)config.changeMajority(this.raftPeersWithPriority(1, 2, 3)));
        config = RaftConfigurationImpl.newBuilder().setConf(new PeerConfiguration(this.raftPeersWithPriority(1, 2, 3))).build();
        Assertions.assertFalse((boolean)config.changeMajority(this.raftPeersWithPriority(1, 2, 3, 4)));
        config = RaftConfigurationImpl.newBuilder().setConf(new PeerConfiguration(this.raftPeersWithPriority(1, 2, 3, 4, 5))).build();
        Assertions.assertFalse((boolean)config.changeMajority(this.raftPeersWithPriority(1, 2, 3, 4, 6, 7)));
    }
}

