/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerMXBean;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerJmxAdapter;
import org.apache.ratis.server.simulation.MiniRaftClusterWithSimulatedRpc;
import org.apache.ratis.util.JmxRegister;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestRaftServerJmx
extends BaseTest {
    @Test
    @Timeout(value=30L)
    public void testJmxBeans() throws Exception {
        int numServers = 3;
        MiniRaftClusterWithSimulatedRpc cluster = (MiniRaftClusterWithSimulatedRpc)MiniRaftClusterWithSimulatedRpc.FACTORY.newCluster(3, new RaftProperties());
        cluster.start();
        RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectInstance> objectInstances = platformMBeanServer.queryMBeans(new ObjectName("Ratis:*"), null);
        Assertions.assertEquals((int)3, (int)objectInstances.size());
        for (ObjectInstance instance : objectInstances) {
            Object groupId = platformMBeanServer.getAttribute(instance.getObjectName(), "GroupId");
            Assertions.assertEquals((Object)cluster.getGroupId().toString(), (Object)groupId);
        }
        cluster.shutdown();
    }

    @Test
    @Timeout(value=30L)
    public void testRegister() throws JMException {
        JmxRegister jmx = new JmxRegister();
        TestRaftServerJmx.runUnregister(false, jmx);
        TestRaftServerJmx.runRegister(true, "abc", jmx);
        TestRaftServerJmx.runRegister(false, "abc", jmx);
        TestRaftServerJmx.runUnregister(true, jmx);
        TestRaftServerJmx.runUnregister(false, jmx);
        TestRaftServerJmx.runRegister(true, "abc", jmx);
        TestRaftServerJmx.runUnregister(true, jmx);
        TestRaftServerJmx.runUnregister(false, jmx);
        jmx = new JmxRegister();
        TestRaftServerJmx.runRegister(true, "host:1234", jmx);
        TestRaftServerJmx.runUnregister(true, jmx);
        TestRaftServerJmx.runUnregister(false, jmx);
    }

    static void runRegister(boolean expectToSucceed, String name, JmxRegister jmx) {
        RaftServerMXBean mBean = new RaftServerMXBean(){

            public String getId() {
                return null;
            }

            public String getLeaderId() {
                return null;
            }

            public long getCurrentTerm() {
                return 0L;
            }

            public String getGroupId() {
                return null;
            }

            public String getRole() {
                return null;
            }

            public List<String> getFollowers() {
                return null;
            }

            public List<String> getGroups() {
                return null;
            }
        };
        String id = RaftPeerId.valueOf((String)name).toString();
        String groupId = RaftGroupId.randomId().toString();
        boolean succeeded = RaftServerJmxAdapter.registerMBean((String)id, (String)groupId, (RaftServerMXBean)mBean, (JmxRegister)jmx);
        Assertions.assertEquals((Object)expectToSucceed, (Object)succeeded);
    }

    static void runUnregister(boolean expectToSucceed, JmxRegister jmx) throws JMException {
        boolean succeeded = jmx.unregister();
        Assertions.assertEquals((Object)expectToSucceed, (Object)succeeded);
    }
}

