/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongUnaryOperator;
import org.apache.ratis.BaseTest;
import org.apache.ratis.server.raftlog.RaftLogIndex;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRaftLogIndex
extends BaseTest {
    static void assertUpdate(RaftLogIndex index, BiFunction<RaftLogIndex, Long, Boolean> update, long oldValue, long newValue, boolean expectUpdate) {
        TestRaftLogIndex.assertUpdate(index, (RaftLogIndex i, LongUnaryOperator op) -> (Boolean)update.apply((RaftLogIndex)i, newValue), oldValue, old -> newValue, expectUpdate);
    }

    static void assertUpdate(RaftLogIndex index, BiFunction<RaftLogIndex, LongUnaryOperator, Boolean> update, long oldValue, LongUnaryOperator op, boolean expectUpdate) {
        Assertions.assertEquals((long)oldValue, (long)index.get());
        boolean updated = update.apply(index, op);
        Assertions.assertEquals((Object)expectUpdate, (Object)updated);
        Assertions.assertEquals((long)(expectUpdate ? op.applyAsLong(oldValue) : oldValue), (long)index.get());
    }

    @Test
    public void testIndex() {
        int initialValue = 900;
        RaftLogIndex index = new RaftLogIndex((Object)"index", 900L);
        Assertions.assertEquals((long)900L, (long)index.get());
        Consumer<Object> log = System.out::println;
        BiFunction<RaftLogIndex, Object, Boolean> f = (j, n) -> j.updateIncreasingly(n.longValue(), log);
        long i = index.get() + 1L;
        TestRaftLogIndex.assertUpdate(index, f, i - 1L, i, true);
        TestRaftLogIndex.assertUpdate(index, f, i, i, false);
        this.testFailureCase("updateIncreasingly to a smaller value", () -> TestRaftLogIndex.assertUpdate(index, f, i, i - 1L, false), IllegalStateException.class, new Class[0]);
        f = (j, n) -> j.updateToMax(n.longValue(), log);
        i = index.get() + 1L;
        TestRaftLogIndex.assertUpdate(index, f, i - 1L, i, true);
        TestRaftLogIndex.assertUpdate(index, f, i, i, false);
        TestRaftLogIndex.assertUpdate(index, f, i, i - 1L, false);
        f = (j, n) -> j.setUnconditionally(n.longValue(), log);
        i = index.get() + 1L;
        TestRaftLogIndex.assertUpdate(index, f, i - 1L, i, true);
        TestRaftLogIndex.assertUpdate(index, f, i, i, false);
        TestRaftLogIndex.assertUpdate(index, f, i, i - 1L, true);
        f = (j, op) -> j.updateUnconditionally(op, log);
        i = index.get() + 1L;
        TestRaftLogIndex.assertUpdate(index, f, i - 1L, n -> n + 1L, true);
        TestRaftLogIndex.assertUpdate(index, f, i, n -> n, false);
        TestRaftLogIndex.assertUpdate(index, f, i, n -> n - 1L, true);
    }
}

