/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog;

import java.lang.management.ManagementFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;
import org.apache.ratis.metrics.impl.DefaultTimekeeperImpl;
import org.apache.ratis.metrics.impl.JvmMetrics;
import org.apache.ratis.metrics.impl.RatisMetricRegistryImpl;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.metrics.RaftLogMetricsBase;
import org.apache.ratis.server.simulation.MiniRaftClusterWithSimulatedRpc;
import org.apache.ratis.server.storage.RaftStorageTestUtils;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.thirdparty.com.codahale.metrics.Timer;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRaftLogMetrics
extends BaseTest
implements MiniRaftClusterWithSimulatedRpc.FactoryGet {
    public static final int NUM_SERVERS = 3;

    public TestRaftLogMetrics() {
        this.getProperties().setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, MetricsStateMachine.class, StateMachine.class);
    }

    @Test
    public void testRaftLogMetrics() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            TestRaftLogMetrics.runTestRaftLogMetrics(cluster);
        }
    }

    static void runTestRaftLogMetrics(MiniRaftCluster cluster) throws Exception {
        int numMsg = 2;
        RaftTestUtil.SimpleMessage[] messages = RaftTestUtil.SimpleMessage.create((int)numMsg);
        try (RaftClient client = cluster.createClient();){
            for (RaftTestUtil.SimpleMessage message : messages) {
                client.io().send((Message)message);
            }
        }
        TestRaftLogMetrics.assertFlushCount(cluster.getLeader());
        TestRaftLogMetrics.assertRaftLogWritePathMetrics(cluster.getLeader());
        for (RaftServer.Division f : cluster.getFollowers()) {
            JavaUtils.attempt(() -> TestRaftLogMetrics.assertFlushCount(f), (int)10, (TimeDuration)HUNDRED_MILLIS, (String)(f.getId() + "-assertFlushCount"), null);
            TestRaftLogMetrics.assertRaftLogWritePathMetrics(f);
        }
        JavaUtils.attempt(() -> TestRaftLogMetrics.assertCommitCount(cluster.getLeader(), numMsg), (int)10, (TimeDuration)HUNDRED_MILLIS, (String)(cluster.getLeader().getId() + "-assertCommitCount"), null);
    }

    static void assertCommitCount(RaftServer.Division server, int expectedMsgs) {
        RatisMetricRegistry rlm = ((RatisMetrics)server.getRaftLog().getRaftLogMetrics()).getRegistry();
        long stmCount = rlm.counter("stateMachineLogEntryCount").getCount();
        Assertions.assertEquals((long)expectedMsgs, (long)stmCount);
    }

    static RatisMetricRegistryImpl getRegistry(RaftGroupMemberId memberId) {
        return (RatisMetricRegistryImpl)RaftLogMetricsBase.createRegistry((RaftGroupMemberId)memberId);
    }

    static void assertFlushCount(RaftServer.Division server) throws Exception {
        String flushTimeMetric = RaftStorageTestUtils.getLogFlushTimeMetric((String)server.getMemberId().toString());
        RatisMetricRegistryImpl ratisMetricRegistry = TestRaftLogMetrics.getRegistry(server.getMemberId());
        Timer tm = (Timer)ratisMetricRegistry.get("flushTime");
        Assertions.assertNotNull((Object)tm);
        MetricsStateMachine stateMachine = MetricsStateMachine.get(server);
        int expectedFlush = stateMachine.getFlushCount();
        JavaUtils.attemptRepeatedly(() -> {
            Assertions.assertEquals((long)expectedFlush, (long)tm.getCount());
            return null;
        }, (int)50, (TimeDuration)HUNDRED_MILLIS, (String)"expectedFlush == tm.getCount()", null);
        Assertions.assertTrue((tm.getMeanRate() > 0.0 ? 1 : 0) != 0);
        ObjectName oname = new ObjectName("ratis", "name", flushTimeMetric);
        Assertions.assertEquals((int)expectedFlush, (int)((Long)ManagementFactory.getPlatformMBeanServer().getAttribute(oname, "Count")).intValue());
    }

    static void assertRaftLogWritePathMetrics(RaftServer.Division server) throws Exception {
        String syncTimeMetric = RaftStorageTestUtils.getRaftLogFullMetric((String)server.getMemberId().toString(), (String)"syncTime");
        RatisMetricRegistryImpl ratisMetricRegistry = TestRaftLogMetrics.getRegistry(server.getMemberId());
        Timer tm = (Timer)ratisMetricRegistry.get("syncTime");
        Assertions.assertNotNull((Object)tm);
        MetricsStateMachine stateMachine = MetricsStateMachine.get(server);
        int expectedFlush = stateMachine.getFlushCount();
        Assertions.assertEquals((long)expectedFlush, (long)tm.getCount());
        Assertions.assertTrue((tm.getMeanRate() > 0.0 ? 1 : 0) != 0);
        ObjectName oname = new ObjectName("ratis", "name", syncTimeMetric);
        Assertions.assertEquals((int)expectedFlush, (int)((Long)ManagementFactory.getPlatformMBeanServer().getAttribute(oname, "Count")).intValue());
        long cacheMissCount = ratisMetricRegistry.counter("cacheMissCount").getCount();
        Assertions.assertEquals((long)0L, (long)cacheMissCount);
        long cacheHitsCount = ratisMetricRegistry.counter("cacheHitCount").getCount();
        Assertions.assertTrue((cacheHitsCount > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((ratisMetricRegistry.counter("flushCount").getCount() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((ratisMetricRegistry.counter("appendEntryCount").getCount() > 0L ? 1 : 0) != 0);
        DefaultTimekeeperImpl appendEntry = (DefaultTimekeeperImpl)ratisMetricRegistry.timer("appendEntryLatency");
        Assertions.assertTrue((appendEntry.getTimer().getMeanRate() > 0.0 ? 1 : 0) != 0);
        DefaultTimekeeperImpl taskQueue = (DefaultTimekeeperImpl)ratisMetricRegistry.timer("enqueuedTime");
        Assertions.assertTrue((taskQueue.getTimer().getMeanRate() > 0.0 ? 1 : 0) != 0);
        DefaultTimekeeperImpl enqueueDelay = (DefaultTimekeeperImpl)ratisMetricRegistry.timer("queueingDelay");
        Assertions.assertTrue((enqueueDelay.getTimer().getMeanRate() > 0.0 ? 1 : 0) != 0);
        DefaultTimekeeperImpl write = (DefaultTimekeeperImpl)ratisMetricRegistry.timer(String.format("%sExecutionTime", "writelog"));
        Assertions.assertTrue((write.getTimer().getMeanRate() > 0.0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)ratisMetricRegistry.get("dataQueueSize"));
        Assertions.assertNotNull((Object)ratisMetricRegistry.get("workerQueueSize"));
        Assertions.assertNotNull((Object)ratisMetricRegistry.get("syncBatchSize"));
    }

    static {
        JvmMetrics.initJvmMetrics((TimeDuration)TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.SECONDS));
    }

    static class MetricsStateMachine
    extends BaseStateMachine {
        private final AtomicInteger flushCount = new AtomicInteger();

        MetricsStateMachine() {
        }

        static MetricsStateMachine get(RaftServer.Division s) {
            return (MetricsStateMachine)s.getStateMachine();
        }

        int getFlushCount() {
            return this.flushCount.get();
        }

        public CompletableFuture<Void> flush(long index) {
            this.flushCount.incrementAndGet();
            return CompletableFuture.completedFuture(null);
        }
    }
}

