/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.memory;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.BaseTest;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.raftlog.LogEntryHeader;
import org.apache.ratis.server.raftlog.memory.MemoryRaftLog;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.Slf4jUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class MemoryRaftLogTest
extends BaseTest {
    @Test
    public void testEntryDoNotPerformTruncation() throws Exception {
        RaftProperties prop = new RaftProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        RaftPeerId peerId = RaftPeerId.valueOf((String)"s0");
        RaftGroupId groupId = RaftGroupId.randomId();
        RaftGroupMemberId memberId = RaftGroupMemberId.valueOf((RaftPeerId)peerId, (RaftGroupId)groupId);
        MemoryRaftLog raftLog = new MemoryRaftLog(memberId, () -> -1L, prop);
        raftLog.open(-1L, null);
        ArrayList<RaftProtos.LogEntryProto> entries1 = new ArrayList<RaftProtos.LogEntryProto>();
        entries1.add(RaftProtos.LogEntryProto.newBuilder().setIndex(0L).setTerm(0L).build());
        entries1.add(RaftProtos.LogEntryProto.newBuilder().setIndex(1L).setTerm(0L).build());
        raftLog.append(entries1).forEach(CompletableFuture::join);
        ArrayList<RaftProtos.LogEntryProto> entries2 = new ArrayList<RaftProtos.LogEntryProto>();
        entries2.add(RaftProtos.LogEntryProto.newBuilder().setIndex(0L).setTerm(0L).build());
        raftLog.append(entries2).forEach(CompletableFuture::join);
        LogEntryHeader[] termIndices = raftLog.getEntries(0L, 10L);
        Assertions.assertEquals((int)2, (int)termIndices.length);
        for (int i = 0; i < 2; ++i) {
            Assertions.assertEquals((long)((RaftProtos.LogEntryProto)entries1.get(i)).getIndex(), (long)termIndices[i].getIndex());
            Assertions.assertEquals((long)((RaftProtos.LogEntryProto)entries1.get(i)).getTerm(), (long)termIndices[i].getTerm());
        }
    }

    @Test
    public void testEntryPerformTruncation() throws Exception {
        RaftProperties prop = new RaftProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        RaftPeerId peerId = RaftPeerId.valueOf((String)"s0");
        RaftGroupId groupId = RaftGroupId.randomId();
        RaftGroupMemberId memberId = RaftGroupMemberId.valueOf((RaftPeerId)peerId, (RaftGroupId)groupId);
        MemoryRaftLog raftLog = new MemoryRaftLog(memberId, () -> -1L, prop);
        raftLog.open(-1L, null);
        ArrayList<RaftProtos.LogEntryProto> entries1 = new ArrayList<RaftProtos.LogEntryProto>();
        entries1.add(RaftProtos.LogEntryProto.newBuilder().setIndex(0L).setTerm(0L).build());
        entries1.add(RaftProtos.LogEntryProto.newBuilder().setIndex(1L).setTerm(0L).build());
        raftLog.append(entries1).forEach(CompletableFuture::join);
        ArrayList<RaftProtos.LogEntryProto> entries2 = new ArrayList<RaftProtos.LogEntryProto>();
        entries2.add(RaftProtos.LogEntryProto.newBuilder().setIndex(0L).setTerm(2L).build());
        raftLog.append(entries2).forEach(CompletableFuture::join);
        LogEntryHeader[] termIndices = raftLog.getEntries(0L, 10L);
        Assertions.assertEquals((int)1, (int)termIndices.length);
        Assertions.assertEquals((long)((RaftProtos.LogEntryProto)entries2.get(0)).getIndex(), (long)termIndices[0].getIndex());
        Assertions.assertEquals((long)((RaftProtos.LogEntryProto)entries2.get(0)).getTerm(), (long)termIndices[0].getTerm());
    }

    static {
        Slf4jUtils.setLogLevel((Logger)MemoryRaftLog.LOG, (Level)Level.DEBUG);
    }
}

