/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ratis.BaseTest;
import org.apache.ratis.server.raftlog.segmented.BufferedWriteChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBufferedWriteChannel
extends BaseTest {
    static ByteBuffer allocateByteBuffer(int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (int i = 0; i < size; ++i) {
            buffer.put(i, (byte)i);
        }
        return buffer.asReadOnlyBuffer();
    }

    @Test
    public void testWriteToChannel() throws Exception {
        for (int n = 1; n < 0x100000; n <<= 2) {
            this.runTestWriteToChannel(n - 1);
            this.runTestWriteToChannel(n);
            this.runTestWriteToChannel(n + 1);
        }
    }

    void runTestWriteToChannel(int bufferSize) throws Exception {
        ByteBuffer buffer = TestBufferedWriteChannel.allocateByteBuffer(2 * bufferSize);
        FakeFileChannel fake = new FakeFileChannel();
        BufferedWriteChannel out = new BufferedWriteChannel("test", (FileChannel)fake, ByteBuffer.allocate(0));
        fake.assertValues(0L, 0L);
        AtomicInteger pos = new AtomicInteger();
        AtomicInteger force = new AtomicInteger();
        TestBufferedWriteChannel.writeToChannel(out, fake, pos, force, buffer, bufferSize);
        TestBufferedWriteChannel.flush(out, fake, pos, force);
        TestBufferedWriteChannel.writeToChannel(out, fake, pos, force, buffer, bufferSize / 2);
        TestBufferedWriteChannel.flush(out, fake, pos, force);
        int n = bufferSize * 2 / 3;
        TestBufferedWriteChannel.writeToChannel(out, fake, pos, force, buffer, n);
        TestBufferedWriteChannel.writeToChannel(out, fake, pos, force, buffer, n);
        TestBufferedWriteChannel.flush(out, fake, pos, force);
        TestBufferedWriteChannel.writeToChannel(out, fake, pos, force, buffer, bufferSize * 3 / 2);
        TestBufferedWriteChannel.flush(out, fake, pos, force);
    }

    static void writeToChannel(BufferedWriteChannel out, FakeFileChannel fake, AtomicInteger pos, AtomicInteger force, ByteBuffer buffer, int n) throws IOException {
        buffer.position(0).limit(n);
        out.writeToChannel(buffer);
        pos.addAndGet(n);
        fake.assertValues(pos.get(), force.get());
    }

    static void flush(BufferedWriteChannel out, FakeFileChannel fake, AtomicInteger pos, AtomicInteger force) throws IOException {
        int existing = out.writeBufferPosition();
        out.flush();
        Assertions.assertEquals((int)0, (int)out.writeBufferPosition());
        pos.addAndGet(existing);
        force.set(pos.get());
        fake.assertValues(pos.get(), force.get());
    }

    static void writeToBuffer(BufferedWriteChannel out, FakeFileChannel fake, AtomicInteger pos, AtomicInteger force, int bufferCapacity, ByteBuffer buffer, int n) throws IOException {
        int existing = out.writeBufferPosition();
        buffer.position(0).limit(n);
        out.writeToBuffer(n, b -> b.put(buffer));
        if (existing + n > bufferCapacity) {
            pos.addAndGet(existing);
            Assertions.assertEquals((int)n, (int)out.writeBufferPosition());
        } else {
            Assertions.assertEquals((int)(existing + n), (int)out.writeBufferPosition());
        }
        fake.assertValues(pos.get(), force.get());
    }

    @Test
    public void testWriteToBuffer() throws Exception {
        for (int n = 1; n < 0x100000; n <<= 2) {
            this.runTestWriteToBuffer(n - 1);
            this.runTestWriteToBuffer(n);
            this.runTestWriteToBuffer(n + 1);
        }
    }

    void runTestWriteToBuffer(int bufferSize) throws Exception {
        ByteBuffer buffer = TestBufferedWriteChannel.allocateByteBuffer(2 * bufferSize);
        FakeFileChannel fake = new FakeFileChannel();
        BufferedWriteChannel out = new BufferedWriteChannel("test", (FileChannel)fake, ByteBuffer.allocate(bufferSize));
        fake.assertValues(0L, 0L);
        AtomicInteger pos = new AtomicInteger();
        AtomicInteger force = new AtomicInteger();
        TestBufferedWriteChannel.writeToBuffer(out, fake, pos, force, bufferSize, buffer, bufferSize);
        TestBufferedWriteChannel.flush(out, fake, pos, force);
        TestBufferedWriteChannel.writeToBuffer(out, fake, pos, force, bufferSize, buffer, bufferSize / 2);
        TestBufferedWriteChannel.flush(out, fake, pos, force);
        int n = bufferSize * 2 / 3;
        TestBufferedWriteChannel.writeToBuffer(out, fake, pos, force, bufferSize, buffer, n);
        TestBufferedWriteChannel.writeToBuffer(out, fake, pos, force, bufferSize, buffer, n);
        TestBufferedWriteChannel.flush(out, fake, pos, force);
    }

    class FakeFileChannel
    extends FileChannel {
        private long position = 0L;
        private long forcedPosition = 0L;

        FakeFileChannel() {
        }

        void assertValues(long expectedPosition, long expectedForcedPosition) {
            Assertions.assertEquals((long)expectedPosition, (long)this.position);
            Assertions.assertEquals((long)expectedForcedPosition, (long)this.forcedPosition);
        }

        @Override
        public int read(ByteBuffer dst) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(ByteBuffer dst, long pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int write(ByteBuffer src, long pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int write(ByteBuffer src) {
            int remaining = src.remaining();
            TestBufferedWriteChannel.this.LOG.info("write {} bytes", (Object)remaining);
            this.position += (long)remaining;
            return remaining;
        }

        @Override
        public long position() {
            return this.position;
        }

        @Override
        public FileChannel position(long newPosition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileChannel truncate(long newSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void force(boolean metaData) {
            TestBufferedWriteChannel.this.LOG.info("force at position {}", (Object)this.position);
            this.forcedPosition = this.position;
        }

        @Override
        public long transferTo(long pos, long count, WritableByteChannel target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long transferFrom(ReadableByteChannel src, long pos, long count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long pos, long size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileLock lock(long pos, long size, boolean shared) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileLock tryLock(long pos, long size, boolean shared) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void implCloseChannel() {
            throw new UnsupportedOperationException();
        }
    }
}

