/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.segmented.CacheInvalidationPolicy;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLog;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogCache;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogTestUtils;
import org.apache.ratis.server.raftlog.segmented.TestSegmentedRaftLog;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageTestUtils;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCacheEviction
extends BaseTest {
    private static final CacheInvalidationPolicy POLICY = new CacheInvalidationPolicy.CacheInvalidationPolicyDefault();

    static SegmentedRaftLogCache.LogSegmentList prepareSegments(int numSegments, boolean[] cached, long start, long size) {
        Assertions.assertEquals((int)numSegments, (int)cached.length);
        SegmentedRaftLogCache.LogSegmentList segments = new SegmentedRaftLogCache.LogSegmentList((Object)JavaUtils.getClassSimpleName(TestCacheEviction.class));
        for (int i = 0; i < numSegments; ++i) {
            LogSegment s = LogSegment.newCloseSegment(null, (long)start, (long)(start + size - 1L), (SizeInBytes)SegmentedRaftLogTestUtils.MAX_OP_SIZE, null);
            if (cached[i]) {
                s = (LogSegment)Mockito.spy((Object)s);
                Mockito.when((Object)s.hasCache()).thenReturn((Object)true);
            }
            segments.add(s);
            start += size;
        }
        return segments;
    }

    @Test
    public void testBasicEviction() throws Exception {
        int maxCached = 5;
        SegmentedRaftLogCache.LogSegmentList segments = TestCacheEviction.prepareSegments(5, new boolean[]{true, true, true, true, true}, 0L, 10L);
        List evicted = POLICY.evict(null, 5L, 15L, segments, 5);
        Assertions.assertEquals((int)0, (int)evicted.size());
        evicted = POLICY.evict(null, 25L, 30L, segments, 5);
        Assertions.assertEquals((int)2, (int)evicted.size());
        Assertions.assertSame(evicted.get(0), (Object)segments.get(0));
        Assertions.assertSame(evicted.get(1), (Object)segments.get(1));
        evicted = POLICY.evict(null, 25L, 15L, segments, 5);
        Assertions.assertEquals((int)1, (int)evicted.size());
        Assertions.assertSame(evicted.get(0), (Object)segments.get(0));
        evicted = POLICY.evict(null, 35L, 5L, segments, 5);
        Assertions.assertEquals((int)1, (int)evicted.size());
        Assertions.assertSame(evicted.get(0), (Object)segments.get(2));
        Mockito.when((Object)segments.get(2).hasCache()).thenReturn((Object)false);
        evicted = POLICY.evict(null, 35L, 5L, segments, 5);
        Assertions.assertEquals((int)1, (int)evicted.size());
        Assertions.assertSame(evicted.get(0), (Object)segments.get(1));
        Mockito.when((Object)segments.get(1).hasCache()).thenReturn((Object)false);
        evicted = POLICY.evict(null, 35L, 5L, segments, 5);
        Assertions.assertEquals((int)0, (int)evicted.size());
    }

    @Test
    public void testEvictionWithFollowerIndices() throws Exception {
        int maxCached = 6;
        SegmentedRaftLogCache.LogSegmentList segments = TestCacheEviction.prepareSegments(6, new boolean[]{true, true, true, true, true, true}, 0L, 10L);
        List evicted = POLICY.evict(new long[]{20L, 40L, 40L}, 5L, 15L, segments, 6);
        Assertions.assertEquals((int)0, (int)evicted.size());
        evicted = POLICY.evict(new long[]{30L, 40L, 45L}, 25L, 30L, segments, 6);
        Assertions.assertEquals((int)2, (int)evicted.size());
        Assertions.assertSame(evicted.get(0), (Object)segments.get(0));
        Assertions.assertSame(evicted.get(1), (Object)segments.get(1));
        evicted = POLICY.evict(new long[]{30L, 40L, 45L}, 25L, 15L, segments, 6);
        Assertions.assertEquals((int)1, (int)evicted.size());
        Assertions.assertSame(evicted.get(0), (Object)segments.get(0));
        evicted = POLICY.evict(new long[]{15L, 45L, 45L}, 55L, 50L, segments, 6);
        Assertions.assertEquals((int)1, (int)evicted.size());
        Assertions.assertSame(evicted.get(0), (Object)segments.get(0));
        Mockito.when((Object)segments.get(0).hasCache()).thenReturn((Object)false);
        evicted = POLICY.evict(new long[]{15L, 45L, 45L}, 55L, 50L, segments, 6);
        Assertions.assertEquals((int)1, (int)evicted.size());
        Assertions.assertSame(evicted.get(0), (Object)segments.get(2));
        Mockito.when((Object)segments.get(2).hasCache()).thenReturn((Object)false);
        evicted = POLICY.evict(new long[]{15L, 45L, 45L}, 55L, 50L, segments, 6);
        Assertions.assertEquals((int)1, (int)evicted.size());
        Assertions.assertSame(evicted.get(0), (Object)segments.get(3));
        Mockito.when((Object)segments.get(3).hasCache()).thenReturn((Object)false);
        evicted = POLICY.evict(new long[]{15L, 45L, 45L}, 55L, 50L, segments, 6);
        Assertions.assertEquals((int)0, (int)evicted.size());
    }

    @Test
    public void testEvictionInSegmentedLog() throws Exception {
        RaftProperties prop = new RaftProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)prop, (SizeInBytes)SizeInBytes.valueOf((String)"8KB"));
        RaftServerConfigKeys.Log.setPreallocatedSize((RaftProperties)prop, (SizeInBytes)SizeInBytes.valueOf((String)"8KB"));
        RaftPeerId peerId = RaftPeerId.valueOf((String)"s0");
        RaftGroupId groupId = RaftGroupId.randomId();
        RaftGroupMemberId memberId = RaftGroupMemberId.valueOf((RaftPeerId)peerId, (RaftGroupId)groupId);
        int maxCachedNum = RaftServerConfigKeys.Log.segmentCacheNumMax((RaftProperties)prop);
        File storageDir = this.getTestDir();
        RaftServerConfigKeys.setStorageDir((RaftProperties)prop, Collections.singletonList(storageDir));
        RaftStorage storage = RaftStorageTestUtils.newRaftStorage((File)storageDir);
        DivisionInfo info = (DivisionInfo)Mockito.mock(DivisionInfo.class);
        Mockito.when((Object)info.getLastAppliedIndex()).thenReturn((Object)0L);
        Mockito.when((Object)info.getFollowerNextIndices()).thenReturn((Object)new long[0]);
        SegmentedRaftLog raftLog = RaftServerTestUtil.newSegmentedRaftLog((RaftGroupMemberId)memberId, (DivisionInfo)info, (RaftStorage)storage, (RaftProperties)prop);
        raftLog.open(-1L, null);
        List<TestSegmentedRaftLog.SegmentRange> slist = TestSegmentedRaftLog.prepareRanges(0, maxCachedNum, 7, 0L);
        List<RaftProtos.LogEntryProto> entries = this.generateEntries(slist);
        raftLog.append(entries).forEach(CompletableFuture::join);
        Assertions.assertEquals((long)(maxCachedNum - 1), (long)raftLog.getRaftLogCache().getCachedSegmentNum());
        Mockito.when((Object)info.getLastAppliedIndex()).thenReturn((Object)35L);
        Mockito.when((Object)info.getFollowerNextIndices()).thenReturn((Object)new long[]{21L, 40L, 40L});
        slist = TestSegmentedRaftLog.prepareRanges(maxCachedNum, maxCachedNum + 2, 7, 7 * maxCachedNum);
        entries = this.generateEntries(slist);
        raftLog.append(entries).forEach(CompletableFuture::join);
        Assertions.assertEquals((long)(maxCachedNum + 1 - 3), (long)raftLog.getRaftLogCache().getCachedSegmentNum());
    }

    private List<RaftProtos.LogEntryProto> generateEntries(List<TestSegmentedRaftLog.SegmentRange> slist) {
        ArrayList<RaftProtos.LogEntryProto> eList = new ArrayList<RaftProtos.LogEntryProto>();
        for (TestSegmentedRaftLog.SegmentRange range : slist) {
            for (long index = range.start; index <= range.end; ++index) {
                RaftTestUtil.SimpleOperation m = new RaftTestUtil.SimpleOperation(new String(new byte[1024]));
                eList.add(LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)m.getLogEntryContent(), (long)range.term, (long)index));
            }
        }
        return eList;
    }
}

