/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.metrics.impl.DefaultTimekeeperImpl;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.metrics.SegmentedRaftLogMetrics;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.LogSegmentPath;
import org.apache.ratis.server.raftlog.segmented.LogSegmentStartEnd;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogFormat;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogInputStream;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogOutputStream;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogTestUtils;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageTestUtils;
import org.apache.ratis.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TraditionalBinaryPrefix;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestLogSegment
extends BaseTest {
    public static final LogSegmentStartEnd ZERO_START_NULL_END = LogSegmentStartEnd.valueOf((long)0L);
    private File storageDir;
    private long segmentMaxSize;
    private long preallocatedSize;
    private int bufferSize;

    @BeforeEach
    public void setup() {
        RaftProperties properties = new RaftProperties();
        this.storageDir = this.getTestDir();
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, Collections.singletonList(this.storageDir));
        this.segmentMaxSize = RaftServerConfigKeys.Log.segmentSizeMax((RaftProperties)properties).getSize();
        this.preallocatedSize = RaftServerConfigKeys.Log.preallocatedSize((RaftProperties)properties).getSize();
        this.bufferSize = RaftServerConfigKeys.Log.writeBufferSize((RaftProperties)properties).getSizeInt();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.storageDir != null) {
            FileUtils.deleteFully((File)this.storageDir.getParentFile());
        }
    }

    File prepareLog(boolean isOpen, long startIndex, int numEntries, long term, boolean isLastEntryPartiallyWritten) throws IOException {
        if (!isOpen) {
            Preconditions.assertTrue((!isLastEntryPartiallyWritten ? 1 : 0) != 0, (Object)"For closed log, the last entry cannot be partially written.");
        }
        RaftStorage storage = RaftStorageTestUtils.newRaftStorage((File)this.storageDir);
        File file = LogSegmentStartEnd.valueOf((long)startIndex, (long)(startIndex + (long)numEntries - 1L), (boolean)isOpen).getFile(storage);
        RaftProtos.LogEntryProto[] entries = new RaftProtos.LogEntryProto[numEntries];
        try (SegmentedRaftLogOutputStream out = new SegmentedRaftLogOutputStream(file, false, this.segmentMaxSize, this.preallocatedSize, ByteBuffer.allocateDirect(this.bufferSize));){
            for (int i = 0; i < entries.length; ++i) {
                RaftTestUtil.SimpleOperation op = new RaftTestUtil.SimpleOperation("m" + i);
                entries[i] = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)op.getLogEntryContent(), (long)term, (long)((long)i + startIndex));
                out.write(entries[i]);
                this.LOG.info("Write entry with size {}", (Object)TestLogSegment.size(entries[i]));
            }
        }
        if (isLastEntryPartiallyWritten) {
            int entrySize = TestLogSegment.size(entries[entries.length - 1]);
            int truncatedEntrySize = ThreadLocalRandom.current().nextInt(entrySize - 1) + 1;
            long fileLength = file.length();
            long truncatedFileLength = fileLength - (long)(entrySize - truncatedEntrySize);
            Assertions.assertTrue((truncatedFileLength < fileLength ? 1 : 0) != 0);
            this.LOG.info("truncate last entry: entry(size={}, truncated={}), file(length={}, truncated={})", new Object[]{entrySize, truncatedEntrySize, fileLength, truncatedFileLength});
            FileUtils.truncateFile((File)file, (long)truncatedFileLength);
            Assertions.assertEquals((long)truncatedFileLength, (long)file.length());
        }
        storage.close();
        return file;
    }

    static int size(RaftProtos.LogEntryProto entry) {
        int n = entry.getSerializedSize();
        return CodedOutputStream.computeUInt32SizeNoTag((int)n) + n + 4;
    }

    static void checkLogSegment(LogSegment segment, long start, long end, boolean isOpen, long totalSize, long term) throws Exception {
        Assertions.assertEquals((long)start, (long)segment.getStartIndex());
        Assertions.assertEquals((long)end, (long)segment.getEndIndex());
        Assertions.assertEquals((Object)isOpen, (Object)segment.isOpen());
        Assertions.assertEquals((long)totalSize, (long)segment.getTotalFileSize());
        long offset = SegmentedRaftLogFormat.getHeaderLength();
        for (long i = start; i <= end; ++i) {
            LogSegment.LogRecord record = segment.getLogRecord(i);
            TermIndex ti = record.getTermIndex();
            Assertions.assertEquals((long)i, (long)ti.getIndex());
            Assertions.assertEquals((long)term, (long)ti.getTerm());
            Assertions.assertEquals((long)offset, (long)record.getOffset());
            RaftProtos.LogEntryProto entry = segment.getEntryFromCache(ti);
            if (entry == null) {
                entry = segment.loadCache(record);
            }
            offset += LogSegment.getEntrySize((RaftProtos.LogEntryProto)entry, (LogSegment.Op)LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE);
        }
    }

    @Test
    public void testLoadLogSegment() throws Exception {
        this.testLoadSegment(true, false);
    }

    @Test
    public void testLoadLogSegmentLastEntryPartiallyWritten() throws Exception {
        this.testLoadSegment(true, true);
    }

    @Test
    public void testLoadCache() throws Exception {
        this.testLoadSegment(false, false);
    }

    @Test
    public void testLoadCacheLastEntryPartiallyWritten() throws Exception {
        this.testLoadSegment(false, true);
    }

    private void testLoadSegment(boolean loadInitial, boolean isLastEntryPartiallyWritten) throws Exception {
        File openSegmentFile = this.prepareLog(true, 0L, 100, 0L, isLastEntryPartiallyWritten);
        RaftStorage storage = RaftStorageTestUtils.newRaftStorage((File)this.storageDir);
        LogSegment openSegment = LogSegment.loadSegment((RaftStorage)storage, (File)openSegmentFile, (LogSegmentStartEnd)ZERO_START_NULL_END, (SizeInBytes)SegmentedRaftLogTestUtils.MAX_OP_SIZE, (boolean)loadInitial, null, null);
        int delta = isLastEntryPartiallyWritten ? 1 : 0;
        TestLogSegment.checkLogSegment(openSegment, 0L, 99 - delta, true, openSegmentFile.length(), 0L);
        storage.close();
        Assertions.assertEquals((int)0, (int)openSegment.getLoadingTimes());
        File closedSegmentFile = this.prepareLog(false, 1000L, 100, 1L, false);
        LogSegment closedSegment = LogSegment.loadSegment((RaftStorage)storage, (File)closedSegmentFile, (LogSegmentStartEnd)LogSegmentStartEnd.valueOf((long)1000L, (Long)1099L), (SizeInBytes)SegmentedRaftLogTestUtils.MAX_OP_SIZE, (boolean)loadInitial, null, null);
        TestLogSegment.checkLogSegment(closedSegment, 1000L, 1099L, false, closedSegment.getTotalFileSize(), 1L);
        Assertions.assertEquals((int)(loadInitial ? 0 : 1), (int)closedSegment.getLoadingTimes());
    }

    @Test
    public void testAppendEntries() throws Exception {
        RaftProtos.LogEntryProto entry;
        long size;
        long start = 1000L;
        LogSegment segment = LogSegment.newOpenSegment(null, (long)1000L, (SizeInBytes)SegmentedRaftLogTestUtils.MAX_OP_SIZE, null);
        long max = 0x800000L;
        TestLogSegment.checkLogSegment(segment, 1000L, 999L, true, size, 0L);
        long term = 0L;
        int i = 0;
        for (size = (long)SegmentedRaftLogFormat.getHeaderLength(); size < 0x800000L; size += LogSegment.getEntrySize((RaftProtos.LogEntryProto)entry, (LogSegment.Op)LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE)) {
            RaftTestUtil.SimpleOperation op = new RaftTestUtil.SimpleOperation("m" + i);
            entry = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)op.getLogEntryContent(), (long)term, (long)((long)i++ + 1000L));
            segment.appendToOpenSegment(entry, LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE);
        }
        Assertions.assertTrue((segment.getTotalFileSize() >= 0x800000L ? 1 : 0) != 0);
        TestLogSegment.checkLogSegment(segment, 1000L, (long)(i - 1) + 1000L, true, size, term);
    }

    @Test
    public void testAppendEntryMetric() throws Exception {
        SegmentedRaftLogMetrics raftLogMetrics = new SegmentedRaftLogMetrics(RaftServerTestUtil.TEST_MEMBER_ID);
        File openSegmentFile = this.prepareLog(true, 0L, 100, 0L, true);
        RaftStorage storage = RaftStorageTestUtils.newRaftStorage((File)this.storageDir);
        LogSegment openSegment = LogSegment.loadSegment((RaftStorage)storage, (File)openSegmentFile, (LogSegmentStartEnd)ZERO_START_NULL_END, (SizeInBytes)SegmentedRaftLogTestUtils.MAX_OP_SIZE, (boolean)true, null, (SegmentedRaftLogMetrics)raftLogMetrics);
        TestLogSegment.checkLogSegment(openSegment, 0L, 98L, true, openSegmentFile.length(), 0L);
        storage.close();
        DefaultTimekeeperImpl readEntryTimer = (DefaultTimekeeperImpl)raftLogMetrics.getReadEntryTimer();
        Assertions.assertNotNull((Object)readEntryTimer);
        Assertions.assertEquals((long)100L, (long)readEntryTimer.getTimer().getCount());
        Assertions.assertTrue((readEntryTimer.getTimer().getMeanRate() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testAppendWithGap() throws Exception {
        RaftProtos.LogEntryProto entry2;
        LogSegment segment = LogSegment.newOpenSegment(null, (long)1000L, (SizeInBytes)SegmentedRaftLogTestUtils.MAX_OP_SIZE, null);
        RaftTestUtil.SimpleOperation op = new RaftTestUtil.SimpleOperation("m");
        RaftProtos.StateMachineLogEntryProto m = op.getLogEntryContent();
        try {
            entry2 = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)m, (long)0L, (long)1001L);
            segment.appendToOpenSegment(entry2, LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE);
            Assertions.fail((String)"should fail since the entry's index needs to be 1000");
        }
        catch (IllegalStateException entry2) {
            // empty catch block
        }
        entry2 = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)m, (long)0L, (long)1000L);
        segment.appendToOpenSegment(entry2, LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE);
        try {
            entry2 = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)m, (long)0L, (long)1002L);
            segment.appendToOpenSegment(entry2, LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE);
            Assertions.fail((String)"should fail since the entry's index needs to be 1001");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testTruncate() throws Exception {
        long term = 1L;
        long start = 1000L;
        LogSegment segment = LogSegment.newOpenSegment(null, (long)1000L, (SizeInBytes)SegmentedRaftLogTestUtils.MAX_OP_SIZE, null);
        for (int i = 0; i < 100; ++i) {
            RaftProtos.LogEntryProto entry = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)new RaftTestUtil.SimpleOperation("m" + i).getLogEntryContent(), (long)1L, (long)((long)i + 1000L));
            segment.appendToOpenSegment(entry, LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE);
        }
        long newSize = segment.getLogRecord(1080L).getOffset();
        segment.truncate(1080L);
        Assertions.assertEquals((int)80, (int)segment.numOfEntries());
        TestLogSegment.checkLogSegment(segment, 1000L, 1079L, false, newSize, 1L);
        newSize = segment.getLogRecord(1050L).getOffset();
        segment.truncate(1050L);
        Assertions.assertEquals((int)50, (int)segment.numOfEntries());
        TestLogSegment.checkLogSegment(segment, 1000L, 1049L, false, newSize, 1L);
        segment.truncate(1000L);
        Assertions.assertEquals((int)0, (int)segment.numOfEntries());
        TestLogSegment.checkLogSegment(segment, 1000L, 999L, false, SegmentedRaftLogFormat.getHeaderLength(), 1L);
    }

    @Test
    public void testPreallocateSegment() throws Exception {
        long size;
        RaftStorage storage = RaftStorageTestUtils.newRaftStorage((File)this.storageDir);
        File file = ZERO_START_NULL_END.getFile(storage);
        int[] maxSizes = new int[]{1024, 1025, 1048575, 0x100000, 0x100001, 0x1FFFFF, 0x200000, 0x200001, 0x800000};
        int[] preallocated = new int[]{512, 1024, 1025, 0x100000, 0x100001, 0x200000};
        for (int max : maxSizes) {
            for (int a : preallocated) {
                try (SegmentedRaftLogOutputStream ignored = new SegmentedRaftLogOutputStream(file, false, (long)max, (long)a, ByteBuffer.allocateDirect(this.bufferSize));){
                    Assertions.assertEquals((long)file.length(), (long)Math.min(max, a), (String)("max=" + max + ", a=" + a));
                }
                var14_22 = null;
                try (SegmentedRaftLogInputStream in = SegmentedRaftLogTestUtils.newSegmentedRaftLogInputStream((File)file, (long)0L, (long)-1L, (boolean)true);){
                    RaftProtos.LogEntryProto entry = in.nextEntry();
                    Assertions.assertNull((Object)entry);
                }
                catch (Throwable throwable) {
                    var14_22 = throwable;
                    throw throwable;
                }
            }
        }
        byte[] content = new byte[2048];
        Arrays.fill(content, (byte)1);
        SegmentedRaftLogOutputStream out = new SegmentedRaftLogOutputStream(file, false, 1024L, 1024L, ByteBuffer.allocateDirect(this.bufferSize));
        Object object = null;
        try {
            RaftTestUtil.SimpleOperation op = new RaftTestUtil.SimpleOperation(new String(content));
            RaftProtos.LogEntryProto entry = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)op.getLogEntryContent(), (long)0L, (long)0L);
            size = LogSegment.getEntrySize((RaftProtos.LogEntryProto)entry, (LogSegment.Op)LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE);
            out.write(entry);
        }
        catch (Throwable op) {
            object = op;
            throw op;
        }
        finally {
            if (out != null) {
                if (object != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable op) {
                        ((Throwable)object).addSuppressed(op);
                    }
                } else {
                    out.close();
                }
            }
        }
        Assertions.assertEquals((long)file.length(), (long)(size + (long)SegmentedRaftLogFormat.getHeaderLength()));
        SegmentedRaftLogInputStream in = SegmentedRaftLogTestUtils.newSegmentedRaftLogInputStream((File)file, (long)0L, (long)-1L, (boolean)true);
        object = null;
        try {
            RaftProtos.LogEntryProto entry = in.nextEntry();
            Assertions.assertArrayEquals((byte[])content, (byte[])entry.getStateMachineLogEntry().getLogData().toByteArray());
            Assertions.assertNull((Object)in.nextEntry());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (object != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
    }

    @Test
    public void testPreallocationAndAppend() throws Exception {
        SizeInBytes max = SizeInBytes.valueOf((long)2L, (TraditionalBinaryPrefix)TraditionalBinaryPrefix.MEGA);
        RaftStorage storage = RaftStorageTestUtils.newRaftStorage((File)this.storageDir);
        File file = ZERO_START_NULL_END.getFile(storage);
        byte[] content = new byte[1024];
        Arrays.fill(content, (byte)1);
        RaftTestUtil.SimpleOperation op = new RaftTestUtil.SimpleOperation(new String(content));
        RaftProtos.LogEntryProto entry = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)op.getLogEntryContent(), (long)0L, (long)0L);
        long entrySize = LogSegment.getEntrySize((RaftProtos.LogEntryProto)entry, (LogSegment.Op)LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE);
        long totalSize = SegmentedRaftLogFormat.getHeaderLength();
        long preallocated = 16384L;
        try (SegmentedRaftLogOutputStream out = new SegmentedRaftLogOutputStream(file, false, max.getSize(), 16384L, ByteBuffer.allocateDirect(10240));){
            Assertions.assertEquals((long)preallocated, (long)file.length());
            while (totalSize + entrySize < max.getSize()) {
                out.write(entry);
                if ((totalSize += entrySize) <= preallocated) continue;
                Assertions.assertEquals((long)(preallocated + 16384L), (long)file.length(), (String)("totalSize==" + totalSize));
                preallocated += 16384L;
            }
        }
        Assertions.assertEquals((long)totalSize, (long)file.length());
    }

    @Test
    public void testZeroSizeInProgressFile() throws Exception {
        RaftStorage storage = RaftStorageTestUtils.newRaftStorage((File)this.storageDir);
        File file = ZERO_START_NULL_END.getFile(storage);
        storage.close();
        this.LOG.info("file: " + file);
        Assertions.assertTrue((boolean)file.createNewFile());
        Path path = file.toPath();
        Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        Assertions.assertEquals((long)0L, (long)Files.size(path));
        List logs = LogSegmentPath.getLogSegmentPaths((RaftStorage)storage);
        Assertions.assertEquals((int)0, (int)logs.size());
        Assertions.assertFalse((boolean)Files.exists(path, new LinkOption[0]));
    }
}

