/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.exceptions.ChecksumException;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogFormat;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogInputStream;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogOutputStream;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogTestUtils;
import org.apache.ratis.server.raftlog.segmented.TestLogSegment;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageTestUtils;
import org.apache.ratis.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.ratis.util.FileUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRaftLogReadWrite
extends BaseTest {
    private File storageDir;
    private long segmentMaxSize;
    private long preallocatedSize;
    private int bufferSize;

    @BeforeEach
    public void setup() {
        this.storageDir = this.getTestDir();
        RaftProperties properties = new RaftProperties();
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, Collections.singletonList(this.storageDir));
        this.segmentMaxSize = RaftServerConfigKeys.Log.segmentSizeMax((RaftProperties)properties).getSize();
        this.preallocatedSize = RaftServerConfigKeys.Log.preallocatedSize((RaftProperties)properties).getSize();
        this.bufferSize = RaftServerConfigKeys.Log.writeBufferSize((RaftProperties)properties).getSizeInt();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.storageDir != null) {
            FileUtils.deleteFully((File)this.storageDir.getParentFile());
        }
    }

    private RaftProtos.LogEntryProto[] readLog(File file, long startIndex, long endIndex, boolean isOpen) throws IOException {
        ArrayList<RaftProtos.LogEntryProto> list = new ArrayList<RaftProtos.LogEntryProto>();
        try (SegmentedRaftLogInputStream in = SegmentedRaftLogTestUtils.newSegmentedRaftLogInputStream((File)file, (long)startIndex, (long)endIndex, (boolean)isOpen);){
            RaftProtos.LogEntryProto entry;
            while ((entry = in.nextEntry()) != null) {
                list.add(entry);
            }
        }
        return list.toArray(new RaftProtos.LogEntryProto[list.size()]);
    }

    private long writeMessages(RaftProtos.LogEntryProto[] entries, SegmentedRaftLogOutputStream out) throws IOException {
        long size = 0L;
        for (int i = 0; i < entries.length; ++i) {
            RaftTestUtil.SimpleOperation m = new RaftTestUtil.SimpleOperation("m" + i);
            entries[i] = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)m.getLogEntryContent(), (long)0L, (long)i);
            int s = entries[i].getSerializedSize();
            size += (long)(CodedOutputStream.computeUInt32SizeNoTag((int)s) + s + 4);
            out.write(entries[i]);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWriteLog() throws IOException {
        SegmentedRaftLogOutputStream out;
        RaftStorage storage = RaftStorageTestUtils.newRaftStorage((File)this.storageDir);
        File openSegment = TestLogSegment.ZERO_START_NULL_END.getFile(storage);
        long size = SegmentedRaftLogFormat.getHeaderLength();
        Object[] entries = new RaftProtos.LogEntryProto[100];
        try {
            out = new SegmentedRaftLogOutputStream(openSegment, false, this.segmentMaxSize, this.preallocatedSize, ByteBuffer.allocateDirect(this.bufferSize));
            Throwable throwable = null;
            try {
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        finally {
            storage.close();
        }
        Assertions.assertEquals((long)(size += this.writeMessages((RaftProtos.LogEntryProto[])entries, out)), (long)openSegment.length());
        Object[] readEntries = this.readLog(openSegment, 0L, -1L, true);
        Assertions.assertArrayEquals((Object[])entries, (Object[])readEntries);
    }

    @Test
    public void testAppendLog() throws IOException {
        RaftTestUtil.SimpleOperation m;
        int i;
        RaftStorage storage = RaftStorageTestUtils.newRaftStorage((File)this.storageDir);
        File openSegment = TestLogSegment.ZERO_START_NULL_END.getFile(storage);
        Object[] entries = new RaftProtos.LogEntryProto[200];
        try (SegmentedRaftLogOutputStream out = new SegmentedRaftLogOutputStream(openSegment, false, this.segmentMaxSize, this.preallocatedSize, ByteBuffer.allocateDirect(this.bufferSize));){
            for (i = 0; i < 100; ++i) {
                m = new RaftTestUtil.SimpleOperation("m" + i);
                entries[i] = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)m.getLogEntryContent(), (long)0L, (long)i);
                out.write(entries[i]);
            }
        }
        out = new SegmentedRaftLogOutputStream(openSegment, true, this.segmentMaxSize, this.preallocatedSize, ByteBuffer.allocateDirect(this.bufferSize));
        var5_5 = null;
        try {
            for (i = 100; i < 200; ++i) {
                m = new RaftTestUtil.SimpleOperation("m" + i);
                entries[i] = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)m.getLogEntryContent(), (long)0L, (long)i);
                out.write((RaftProtos.LogEntryProto)entries[i]);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var5_5 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
        Object[] readEntries = this.readLog(openSegment, 0L, -1L, true);
        Assertions.assertArrayEquals((Object[])entries, (Object[])readEntries);
        storage.close();
    }

    @Test
    public void testReadWithPadding() throws IOException {
        RaftStorage storage = RaftStorageTestUtils.newRaftStorage((File)this.storageDir);
        File openSegment = TestLogSegment.ZERO_START_NULL_END.getFile(storage);
        long size = SegmentedRaftLogFormat.getHeaderLength();
        Object[] entries = new RaftProtos.LogEntryProto[100];
        SegmentedRaftLogOutputStream out = new SegmentedRaftLogOutputStream(openSegment, false, this.segmentMaxSize, this.preallocatedSize, ByteBuffer.allocateDirect(this.bufferSize));
        size += this.writeMessages((RaftProtos.LogEntryProto[])entries, out);
        out.flush();
        Assertions.assertEquals((long)RaftServerConfigKeys.Log.PREALLOCATED_SIZE_DEFAULT.getSize(), (long)openSegment.length());
        Object[] readEntries = this.readLog(openSegment, 0L, -1L, true);
        Assertions.assertArrayEquals((Object[])entries, (Object[])readEntries);
        out.close();
        Assertions.assertEquals((long)size, (long)openSegment.length());
    }

    @Test
    public void testReadWithCorruptPadding() throws IOException {
        Object array2;
        Object m;
        RaftStorage storage = RaftStorageTestUtils.newRaftStorage((File)this.storageDir);
        File openSegment = TestLogSegment.ZERO_START_NULL_END.getFile(storage);
        Object[] entries = new RaftProtos.LogEntryProto[10];
        SegmentedRaftLogOutputStream out = new SegmentedRaftLogOutputStream(openSegment, false, 0x1000000L, 0x400000L, ByteBuffer.allocateDirect(this.bufferSize));
        for (int i = 0; i < 10; ++i) {
            m = new RaftTestUtil.SimpleOperation("m" + i);
            entries[i] = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)m.getLogEntryContent(), (long)0L, (long)i);
            out.write(entries[i]);
        }
        out.flush();
        Assertions.assertEquals((long)0x400000L, (long)openSegment.length());
        FileChannel fout = FileUtils.newFileChannel((File)openSegment, (OpenOption[])new OpenOption[]{StandardOpenOption.WRITE});
        m = null;
        try {
            array2 = new byte[]{-1, 1};
            int written = fout.write(ByteBuffer.wrap((byte[])array2), 0xFFFFF6L);
            Assertions.assertEquals((int)((byte[])array2).length, (int)written);
        }
        catch (Throwable array2) {
            m = array2;
            throw array2;
        }
        finally {
            if (fout != null) {
                if (m != null) {
                    try {
                        fout.close();
                    }
                    catch (Throwable array2) {
                        ((Throwable)m).addSuppressed(array2);
                    }
                } else {
                    fout.close();
                }
            }
        }
        ArrayList<RaftProtos.LogEntryProto> list = new ArrayList<RaftProtos.LogEntryProto>();
        try {
            SegmentedRaftLogInputStream in = SegmentedRaftLogTestUtils.newSegmentedRaftLogInputStream((File)openSegment, (long)0L, (long)-1L, (boolean)true);
            array2 = null;
            try {
                RaftProtos.LogEntryProto entry;
                while ((entry = in.nextEntry()) != null) {
                    list.add(entry);
                }
                Assertions.fail((String)"should fail since we corrupt the padding");
            }
            catch (Throwable throwable) {
                array2 = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (array2 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)array2).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            boolean findVerifyTerminator = false;
            for (StackTraceElement s : e.getStackTrace()) {
                if (!s.getMethodName().equals("verifyTerminator")) continue;
                findVerifyTerminator = true;
                break;
            }
            Assertions.assertTrue((boolean)findVerifyTerminator);
        }
        Assertions.assertArrayEquals((Object[])entries, (Object[])list.toArray(new RaftProtos.LogEntryProto[list.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWithEntryCorruption() throws IOException {
        Throwable throwable;
        RaftStorage storage = RaftStorageTestUtils.newRaftStorage((File)this.storageDir);
        File openSegment = TestLogSegment.ZERO_START_NULL_END.getFile(storage);
        try {
            throwable = null;
            try (SegmentedRaftLogOutputStream out = new SegmentedRaftLogOutputStream(openSegment, false, this.segmentMaxSize, this.preallocatedSize, ByteBuffer.allocateDirect(this.bufferSize));){
                for (int i = 0; i < 100; ++i) {
                    RaftProtos.LogEntryProto entry = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)new RaftTestUtil.SimpleOperation("m" + i).getLogEntryContent(), (long)0L, (long)i);
                    out.write(entry);
                }
            }
            catch (Throwable i) {
                throwable = i;
                throw i;
            }
        }
        finally {
            storage.close();
        }
        throwable = null;
        try (RandomAccessFile raf = new RandomAccessFile(openSegment.getCanonicalFile(), "rw");){
            raf.seek(100L);
            int correctValue = raf.read();
            raf.seek(100L);
            raf.write(correctValue + 1);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        try {
            this.readLog(openSegment, 0L, -1L, true);
            Assertions.fail((String)"The read of corrupted log file should fail");
        }
        catch (ChecksumException e) {
            this.LOG.info("Caught ChecksumException as expected", (Throwable)e);
        }
    }
}

