/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.IOException;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.metrics.impl.RatisMetricRegistryImpl;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.metrics.SegmentedRaftLogMetrics;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogEntryHeader;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogCache;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogTestUtils;
import org.apache.ratis.thirdparty.com.codahale.metrics.Gauge;
import org.apache.ratis.util.SizeInBytes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSegmentedRaftLogCache {
    private static final RaftProperties PROP = new RaftProperties();
    private SegmentedRaftLogCache cache;
    private SegmentedRaftLogMetrics raftLogMetrics;
    private RatisMetricRegistryImpl ratisMetricRegistry;

    @BeforeEach
    public void setup() {
        this.raftLogMetrics = new SegmentedRaftLogMetrics(RaftServerTestUtil.TEST_MEMBER_ID);
        this.ratisMetricRegistry = (RatisMetricRegistryImpl)this.raftLogMetrics.getRegistry();
        this.cache = new SegmentedRaftLogCache(null, null, PROP, this.raftLogMetrics);
    }

    @AfterEach
    public void clear() {
        this.raftLogMetrics.unregister();
    }

    private LogSegment prepareLogSegment(long start, long end, boolean isOpen) {
        LogSegment s = LogSegment.newOpenSegment(null, (long)start, (SizeInBytes)SegmentedRaftLogTestUtils.MAX_OP_SIZE, null);
        for (long i = start; i <= end; ++i) {
            RaftTestUtil.SimpleOperation m = new RaftTestUtil.SimpleOperation("m" + i);
            RaftProtos.LogEntryProto entry = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)m.getLogEntryContent(), (long)0L, (long)i);
            s.appendToOpenSegment(entry, LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE);
        }
        if (!isOpen) {
            s.close();
        }
        return s;
    }

    private void checkCache(long start, long end, int segmentSize) {
        long[] offsets;
        Assertions.assertEquals((long)start, (long)this.cache.getStartIndex());
        Assertions.assertEquals((long)end, (long)this.cache.getEndIndex());
        for (long index = start; index <= end; ++index) {
            LogSegment segment = this.cache.getSegment(index);
            LogSegment.LogRecord record = segment.getLogRecord(index);
            RaftProtos.LogEntryProto entry = segment.getEntryFromCache(record.getTermIndex());
            Assertions.assertEquals((long)index, (long)entry.getIndex());
        }
        for (long offset : offsets = new long[]{start, start + 1L, start + (end - start) / 2L, end - 1L, end}) {
            this.checkCacheEntries(offset, (int)(end - offset + 1L), end);
            this.checkCacheEntries(offset, 1, end);
            this.checkCacheEntries(offset, 20, end);
            this.checkCacheEntries(offset, segmentSize, end);
            this.checkCacheEntries(offset, segmentSize - 1, end);
        }
    }

    private void checkCacheEntries(long offset, int size, long end) {
        LogEntryHeader[] entries = this.cache.getTermIndices(offset, offset + (long)size);
        long realEnd = offset + (long)size > end + 1L ? end + 1L : offset + (long)size;
        Assertions.assertEquals((long)(realEnd - offset), (long)entries.length);
        for (long i = offset; i < realEnd; ++i) {
            Assertions.assertEquals((long)i, (long)entries[(int)(i - offset)].getIndex());
        }
    }

    @Test
    public void testAddSegments() throws Exception {
        LogSegment s3;
        LogSegment s1 = this.prepareLogSegment(1L, 100L, false);
        this.cache.addSegment(s1);
        this.checkCache(1L, 100L, 100);
        try {
            LogSegment s2 = this.prepareLogSegment(102L, 103L, true);
            this.cache.addSegment(s2);
            Assertions.fail((String)"should fail since there is gap between two segments");
        }
        catch (IllegalStateException s2) {
            // empty catch block
        }
        LogSegment s2 = this.prepareLogSegment(101L, 200L, true);
        this.cache.addSegment(s2);
        this.checkCache(1L, 200L, 100);
        try {
            s3 = this.prepareLogSegment(201L, 202L, true);
            this.cache.addSegment(s3);
            Assertions.fail((String)"should fail since there is still an open segment in cache");
        }
        catch (IllegalStateException s3) {
            // empty catch block
        }
        this.cache.rollOpenSegment(false);
        this.checkCache(1L, 200L, 100);
        try {
            s3 = this.prepareLogSegment(202L, 203L, true);
            this.cache.addSegment(s3);
            Assertions.fail((String)"should fail since there is gap between two segments");
        }
        catch (IllegalStateException s4) {
            // empty catch block
        }
        LogSegment s3 = this.prepareLogSegment(201L, 300L, true);
        this.cache.addSegment(s3);
        Assertions.assertNotNull((Object)this.cache.getOpenSegment());
        this.checkCache(1L, 300L, 100);
        this.cache.rollOpenSegment(true);
        Assertions.assertNotNull((Object)this.cache.getOpenSegment());
        this.checkCache(1L, 300L, 100);
    }

    @Test
    public void testAppendEntry() throws Exception {
        LogSegment closedSegment = this.prepareLogSegment(0L, 99L, false);
        this.cache.addSegment(closedSegment);
        RaftTestUtil.SimpleOperation m = new RaftTestUtil.SimpleOperation("m");
        try {
            RaftProtos.LogEntryProto entry = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)m.getLogEntryContent(), (long)0L, (long)0L);
            this.cache.appendEntry(entry, LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE);
            Assertions.fail((String)"the open segment is null");
        }
        catch (IllegalStateException entry) {
            // empty catch block
        }
        LogSegment openSegment = this.prepareLogSegment(100L, 100L, true);
        this.cache.addSegment(openSegment);
        for (long index = 101L; index < 200L; ++index) {
            RaftProtos.LogEntryProto entry = LogProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)m.getLogEntryContent(), (long)0L, (long)index);
            this.cache.appendEntry(entry, LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE);
        }
        Assertions.assertNotNull((Object)this.cache.getOpenSegment());
        this.checkCache(0L, 199L, 100);
    }

    @Test
    public void testTruncate() throws Exception {
        long start = 0L;
        for (int i = 0; i < 5; ++i) {
            LogSegment s = this.prepareLogSegment(start, start + 99L, false);
            this.cache.addSegment(s);
            start += 100L;
        }
        LogSegment s = this.prepareLogSegment(start, start + 99L, true);
        this.cache.addSegment(s);
        long end = this.cache.getEndIndex();
        Assertions.assertEquals((long)599L, (long)end);
        int numOfSegments = 6;
        for (int i = 0; i < 10; ++i) {
            SegmentedRaftLogCache.TruncationSegments ts = this.cache.truncate((end -= 37L) + 1L);
            this.checkCache(0L, end, 100);
            int currentNum = (int)(end / 100L + 1L);
            if (currentNum < numOfSegments) {
                Assertions.assertEquals((int)1, (int)ts.getToDelete().length);
                numOfSegments = currentNum;
                continue;
            }
            Assertions.assertEquals((int)0, (int)ts.getToDelete().length);
        }
        SegmentedRaftLogCache.TruncationSegments ts = this.cache.truncate(200L);
        this.checkCache(0L, 199L, 100);
        Assertions.assertEquals((int)1, (int)ts.getToDelete().length);
        Assertions.assertEquals((long)200L, (long)ts.getToDelete()[0].getStartIndex());
        Assertions.assertEquals((long)229L, (long)ts.getToDelete()[0].getEndIndex());
        Assertions.assertEquals((long)0L, (long)ts.getToDelete()[0].getTargetLength());
        Assertions.assertFalse((boolean)ts.getToDelete()[0].isOpen());
        Assertions.assertNull((Object)ts.getToTruncate());
        LogSegment newOpen = this.prepareLogSegment(200L, 249L, true);
        this.cache.addSegment(newOpen);
        ts = this.cache.truncate(200L);
        this.checkCache(0L, 199L, 100);
        Assertions.assertEquals((int)1, (int)ts.getToDelete().length);
        Assertions.assertEquals((long)200L, (long)ts.getToDelete()[0].getStartIndex());
        Assertions.assertEquals((long)249L, (long)ts.getToDelete()[0].getEndIndex());
        Assertions.assertEquals((long)0L, (long)ts.getToDelete()[0].getTargetLength());
        Assertions.assertTrue((boolean)ts.getToDelete()[0].isOpen());
        Assertions.assertNull((Object)ts.getToTruncate());
        newOpen = this.prepareLogSegment(200L, 249L, true);
        this.cache.addSegment(newOpen);
        ts = this.cache.truncate(220L);
        this.checkCache(0L, 219L, 100);
        Assertions.assertNull((Object)this.cache.getOpenSegment());
        Assertions.assertEquals((int)0, (int)ts.getToDelete().length);
        Assertions.assertTrue((boolean)ts.getToTruncate().isOpen());
        Assertions.assertEquals((long)219L, (long)ts.getToTruncate().getNewEndIndex());
        Assertions.assertEquals((long)200L, (long)ts.getToTruncate().getStartIndex());
        Assertions.assertEquals((long)249L, (long)ts.getToTruncate().getEndIndex());
    }

    @Test
    public void testOpenSegmentPurge() {
        int start = 0;
        int end = 5;
        int segmentSize = 100;
        this.populatedSegment(start, end, segmentSize, false);
        int sIndex = (end - start) * segmentSize;
        this.populatedSegment(end, end + 1, segmentSize, true);
        int purgeIndex = sIndex;
        SegmentedRaftLogCache.TruncationSegments ts = this.cache.purge((long)purgeIndex);
        Assertions.assertNull((Object)ts.getToTruncate());
        Assertions.assertEquals((int)(end - start), (int)ts.getToDelete().length);
        Assertions.assertEquals((long)sIndex, (long)this.cache.getStartIndex());
    }

    @Test
    public void testCloseSegmentPurge() {
        int start = 0;
        int end = 5;
        int segmentSize = 100;
        this.populatedSegment(start, end, segmentSize, false);
        int purgeIndex = (end - start) * segmentSize - 1;
        SegmentedRaftLogCache.TruncationSegments ts = this.cache.purge((long)(purgeIndex - 1));
        Assertions.assertNull((Object)ts.getToTruncate());
        Assertions.assertEquals((int)(end - start - 1), (int)ts.getToDelete().length);
        Assertions.assertEquals((int)1, (int)this.cache.getNumOfSegments());
    }

    private void populatedSegment(int start, int end, int segmentSize, boolean isOpen) {
        IntStream.range(start, end).forEach(x -> {
            int startIndex = x * segmentSize;
            int endIndex = startIndex + segmentSize - 1;
            LogSegment s = this.prepareLogSegment(startIndex, endIndex, isOpen);
            this.cache.addSegment(s);
        });
    }

    private void testIterator(long startIndex) throws IOException {
        Iterator iterator = this.cache.iterator(startIndex);
        TermIndex prev = null;
        while (iterator.hasNext()) {
            TermIndex termIndex = (TermIndex)iterator.next();
            Assertions.assertEquals((Object)this.cache.getLogRecord(termIndex.getIndex()).getTermIndex(), (Object)termIndex);
            if (prev != null) {
                Assertions.assertEquals((long)(prev.getIndex() + 1L), (long)termIndex.getIndex());
            }
            prev = termIndex;
        }
        if (startIndex <= this.cache.getEndIndex()) {
            Assertions.assertNotNull(prev);
            Assertions.assertEquals((long)this.cache.getEndIndex(), (long)prev.getIndex());
        }
    }

    @Test
    public void testIterator() throws Exception {
        long start = 0L;
        for (int i = 0; i < 2; ++i) {
            LogSegment s = this.prepareLogSegment(start, start + 99L, false);
            this.cache.addSegment(s);
            start += 100L;
        }
        LogSegment s = this.prepareLogSegment(start, start + 99L, true);
        this.cache.addSegment(s);
        for (long startIndex = 0L; startIndex < 300L; startIndex += 50L) {
            this.testIterator(startIndex);
        }
        this.testIterator(299L);
        Iterator iterator = this.cache.iterator(300L);
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testCacheMetric() {
        this.cache.addSegment(this.prepareLogSegment(0L, 99L, false));
        this.cache.addSegment(this.prepareLogSegment(100L, 200L, false));
        this.cache.addSegment(this.prepareLogSegment(201L, 300L, true));
        Long closedSegmentsNum = (Long)((Gauge)this.ratisMetricRegistry.getGauges((s, metric) -> s.contains("closedSegmentsNum")).values().iterator().next()).getValue();
        Assertions.assertEquals((long)2L, (long)closedSegmentsNum);
        Long closedSegmentsSizeInBytes = (Long)((Gauge)this.ratisMetricRegistry.getGauges((s, metric) -> s.contains("closedSegmentsSizeInBytes")).values().iterator().next()).getValue();
        Assertions.assertEquals((long)closedSegmentsSizeInBytes, (long)this.cache.getClosedSegmentsSizeInBytes());
        Long openSegmentSizeInBytes = (Long)((Gauge)this.ratisMetricRegistry.getGauges((s, metric) -> s.contains("openSegmentSizeInBytes")).values().iterator().next()).getValue();
        Assertions.assertEquals((long)openSegmentSizeInBytes, (long)this.cache.getOpenSegmentSizeInBytes());
    }
}

