/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.ratis.BaseTest;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageImpl;
import org.apache.ratis.server.storage.StorageImplUtils;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStorageImplUtils
extends BaseTest {
    private static final Supplier<File> ROOT_TEST_DIR = JavaUtils.memoize(() -> new File(BaseTest.getRootTestDir(), JavaUtils.getClassSimpleName(TestStorageImplUtils.class) + Integer.toHexString(ThreadLocalRandom.current().nextInt())));

    static File chooseNewStorageDir(List<File> volumes, String sub) throws IOException {
        HashMap numDirPerVolume = new HashMap();
        StorageImplUtils.getExistingStorageSubs(volumes, (String)sub, numDirPerVolume);
        File vol = StorageImplUtils.chooseMin(numDirPerVolume);
        return new File(vol, sub);
    }

    @AfterAll
    public static void tearDown() throws IOException {
        FileUtils.deleteFully((File)ROOT_TEST_DIR.get());
    }

    @Test
    public void testChooseStorageDirWithOneVolume() throws IOException {
        File testDir = new File(ROOT_TEST_DIR.get(), UUID.randomUUID().toString());
        List<File> directories = Collections.singletonList(testDir);
        String subDirOne = UUID.randomUUID().toString();
        String subDirTwo = UUID.randomUUID().toString();
        File storageDirOne = TestStorageImplUtils.chooseNewStorageDir(directories, subDirOne);
        File storageDirTwo = TestStorageImplUtils.chooseNewStorageDir(directories, subDirTwo);
        File expectedOne = new File(testDir, subDirOne);
        File expectedTwo = new File(testDir, subDirTwo);
        Assertions.assertEquals((Object)expectedOne.getCanonicalPath(), (Object)storageDirOne.getCanonicalPath());
        Assertions.assertEquals((Object)expectedTwo.getCanonicalPath(), (Object)storageDirTwo.getCanonicalPath());
    }

    @Test
    public void testChooseStorageDirWithMultipleVolumes() throws IOException {
        File testDir = new File(ROOT_TEST_DIR.get(), UUID.randomUUID().toString());
        ArrayList<File> directories = new ArrayList<File>();
        IntStream.range(0, 10).mapToObj(i -> new File(testDir, Integer.toString(i))).forEach(dir -> {
            try {
                FileUtils.createDirectories((File)dir);
                directories.add((File)dir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        directories.stream().filter(dir -> Integer.parseInt(dir.getName()) != 6).forEach(dir -> {
            try {
                FileUtils.createDirectories((File)new File((File)dir, UUID.randomUUID().toString()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        String subDir = UUID.randomUUID().toString();
        File storageDirectory = TestStorageImplUtils.chooseNewStorageDir(directories, subDir);
        File expected = new File((File)directories.get(6), subDir);
        Assertions.assertEquals((Object)expected.getCanonicalPath(), (Object)storageDirectory.getCanonicalPath());
    }

    @Test
    public void testChooseStorageDirWithNoVolume() {
        try {
            TestStorageImplUtils.chooseNewStorageDir(Collections.emptyList(), UUID.randomUUID().toString());
            Assertions.fail();
        }
        catch (IOException ex) {
            String expectedErrMsg = "No storage directory found.";
            Assertions.assertEquals((Object)expectedErrMsg, (Object)ex.getMessage());
        }
    }

    @Test
    public void testAutoFormatSingleDirectory() throws Exception {
        File testDir = new File(ROOT_TEST_DIR.get(), UUID.randomUUID().toString());
        FileUtils.createDirectories((File)testDir);
        RaftProperties properties = new RaftProperties();
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, Collections.singletonList(testDir));
        RaftStorageImpl storage = StorageImplUtils.initRaftStorage((String)"group-1", (RaftStorage.StartupOption)RaftStorage.StartupOption.RECOVER, (RaftProperties)properties);
        Assertions.assertNotNull((Object)storage);
        storage.close();
    }

    @Test
    public void testAutoFormatMultiDirectories() throws Exception {
        File testDir = new File(ROOT_TEST_DIR.get(), UUID.randomUUID().toString());
        ArrayList directories = new ArrayList();
        IntStream.range(0, 3).mapToObj(i -> new File(testDir, Integer.toString(i))).forEach(dir -> {
            try {
                FileUtils.createDirectories((File)dir);
                directories.add(dir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        RaftProperties properties = new RaftProperties();
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, directories);
        Throwable ioe = this.testFailureCase("Do not auto format multi directories", () -> StorageImplUtils.initRaftStorage((String)"group-1", (RaftStorage.StartupOption)RaftStorage.StartupOption.RECOVER, (RaftProperties)properties), IOException.class, new Class[0]);
        Assertions.assertTrue((boolean)ioe.getMessage().contains("Failed to RECOVER: Storage directory not found"));
    }
}

