/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh;

import java.util.concurrent.TimeUnit;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.shell.cli.sh.AbstractCommandIntegrationTestWithGrpc;
import org.apache.ratis.shell.cli.sh.RatisShell;
import org.apache.ratis.shell.cli.sh.StringPrintStream;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class ElectionCommandIntegrationTest<CLUSTER extends MiniRaftCluster>
extends AbstractCommandIntegrationTestWithGrpc
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public ElectionCommandIntegrationTest() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.WARN);
        Slf4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.WARN);
        Slf4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.WARN);
        RaftProperties prop = this.getProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)prop, (SizeInBytes)SizeInBytes.valueOf((String)"8KB"));
    }

    @Test
    public void testElectionTransferCommand() throws Exception {
        this.runWithNewCluster(3, this::runTestElectionTransferCommand);
    }

    void runTestElectionTransferCommand(MiniRaftCluster cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        String address = this.getClusterAddress(cluster);
        RaftServer.Division newLeader = (RaftServer.Division)cluster.getFollowers().get(0);
        StringPrintStream out = new StringPrintStream();
        RatisShell shell = new RatisShell(out.getPrintStream());
        Assertions.assertNotEquals((Object)cluster.getLeader().getId(), (Object)newLeader.getId());
        int ret = shell.run(new String[]{"election", "transfer", "-peers", address, "-address", newLeader.getPeer().getAddress()});
        Assertions.assertEquals((int)0, (int)ret);
        JavaUtils.attempt(() -> Assertions.assertEquals((Object)cluster.getLeader().getId(), (Object)newLeader.getId()), (int)10, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS), (String)"testElectionTransferCommand", (Logger)this.LOG);
    }

    @Test
    public void testElectionTransferCommandToHigherPriority() throws Exception {
        this.runWithNewCluster(3, this::runTestElectionTransferCommandToHigherPriority);
    }

    void runTestElectionTransferCommandToHigherPriority(MiniRaftCluster cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        String address = this.getClusterAddress(cluster);
        RaftServer.Division newLeader = (RaftServer.Division)cluster.getFollowers().get(0);
        StringPrintStream out = new StringPrintStream();
        RatisShell shell = new RatisShell(out.getPrintStream());
        Assertions.assertTrue((boolean)cluster.getFollowers().contains(newLeader));
        int ret = shell.run(new String[]{"peer", "setPriority", "-peers", address, "-addressPriority", leader.getPeer().getAddress() + "|" + 2});
        Assertions.assertEquals((int)0, (int)ret);
        ret = shell.run(new String[]{"election", "transfer", "-peers", address, "-address", newLeader.getPeer().getAddress(), "-timeout", "1"});
        Assertions.assertEquals((int)0, (int)ret);
        JavaUtils.attempt(() -> Assertions.assertEquals((Object)cluster.getLeader().getId(), (Object)newLeader.getId()), (int)10, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS), (String)"testElectionTransferLeaderCommand", (Logger)this.LOG);
        ret = shell.run(new String[]{"group", "info", "-peers", address});
        Assertions.assertEquals((int)0, (int)ret);
        String expected = String.format("\"%s\"%n  priority: %d", newLeader.getPeer().getAddress(), 2);
        String expected2 = String.format("\"%s\"%n  priority: %d", leader.getPeer().getAddress(), 2);
        Assertions.assertTrue((boolean)out.toString().contains(expected));
        Assertions.assertTrue((boolean)out.toString().contains(expected2));
    }

    @Test
    public void testElectionPauseResumeCommand() throws Exception {
        this.runWithNewCluster(3, this::runTestElectionPauseResumeCommand);
    }

    void runTestElectionPauseResumeCommand(MiniRaftCluster cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        String sb = this.getClusterAddress(cluster);
        RaftServer.Division newLeader = (RaftServer.Division)cluster.getFollowers().get(0);
        StringPrintStream out = new StringPrintStream();
        RatisShell shell = new RatisShell(out.getPrintStream());
        Assertions.assertNotEquals((Object)cluster.getLeader().getId(), (Object)newLeader.getId());
        int ret = shell.run(new String[]{"election", "pause", "-peers", sb.toString(), "-address", newLeader.getPeer().getAddress()});
        Assertions.assertEquals((int)0, (int)ret);
        ret = shell.run(new String[]{"peer", "setPriority", "-peers", sb.toString(), "-addressPriority", newLeader.getPeer().getAddress() + "|" + 2});
        Assertions.assertEquals((int)0, (int)ret);
        JavaUtils.attempt(() -> Assertions.assertNotEquals((Object)cluster.getLeader().getId(), (Object)newLeader.getId()), (int)10, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS), (String)"testElectionPauseResumeCommand", (Logger)this.LOG);
        ret = shell.run(new String[]{"election", "resume", "-peers", sb.toString(), "-address", newLeader.getPeer().getAddress()});
        Assertions.assertEquals((int)0, (int)ret);
        JavaUtils.attempt(() -> Assertions.assertEquals((Object)cluster.getLeader().getId(), (Object)newLeader.getId()), (int)10, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS), (String)"testElectionPauseResumeCommand", (Logger)this.LOG);
    }

    @Test
    public void testElectionStepDownCommand() throws Exception {
        this.runWithNewCluster(3, this::runTestElectionStepDownCommand);
    }

    void runTestElectionStepDownCommand(MiniRaftCluster cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        String sb = this.getClusterAddress(cluster);
        RaftServer.Division newLeader = (RaftServer.Division)cluster.getFollowers().get(0);
        StringPrintStream out = new StringPrintStream();
        RatisShell shell = new RatisShell(out.getPrintStream());
        Assertions.assertNotEquals((Object)cluster.getLeader().getId(), (Object)newLeader.getId());
        Assertions.assertEquals((int)2, (int)cluster.getFollowers().size());
        int ret = shell.run(new String[]{"election", "stepDown", "-peers", sb.toString()});
        Assertions.assertEquals((int)0, (int)ret);
        Assertions.assertEquals((int)3, (int)cluster.getFollowers().size());
    }
}

