/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh;

import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.shell.cli.sh.AbstractCommandIntegrationTestWithGrpc;
import org.apache.ratis.shell.cli.sh.RatisShell;
import org.apache.ratis.shell.cli.sh.StringPrintStream;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.Slf4jUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class GroupCommandIntegrationTest<CLUSTER extends MiniRaftCluster>
extends AbstractCommandIntegrationTestWithGrpc
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    static final String NEW_LINE = System.lineSeparator();

    public GroupCommandIntegrationTest() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.WARN);
        Slf4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.WARN);
        Slf4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.WARN);
        RaftProperties prop = this.getProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)prop, (SizeInBytes)SizeInBytes.valueOf((String)"8KB"));
    }

    @Test
    public void testGroupListCommand() throws Exception {
        this.runWithNewCluster(3, this::runTestGroupListCommand);
    }

    void runTestGroupListCommand(MiniRaftCluster cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        String address = this.getClusterAddress(cluster);
        StringPrintStream out = new StringPrintStream();
        RatisShell shell = new RatisShell(out.getPrintStream());
        int ret = shell.run(new String[]{"group", "list", "-peers", address, "-peerId", leader.getPeer().getId().toString()});
        Assertions.assertEquals((int)0, (int)ret);
        String info = out.toString().trim();
        String expected = String.format("The peerId %s (server %s) is in 1 groups, and the groupIds is: [%s]", leader.getId(), leader.getPeer().getAddress(), leader.getGroup().getGroupId());
        Assertions.assertEquals((Object)expected, (Object)info);
    }

    @Test
    public void testGroupInfoCommand() throws Exception {
        this.runWithNewCluster(3, this::runTestGroupInfoCommand);
    }

    void runTestGroupInfoCommand(MiniRaftCluster cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        String address = this.getClusterAddress(cluster);
        StringPrintStream out = new StringPrintStream();
        RatisShell shell = new RatisShell(out.getPrintStream());
        int ret = shell.run(new String[]{"group", "info", "-peers", address});
        Assertions.assertEquals((int)0, (int)ret);
        String result = out.toString().trim();
        String hearder = String.format("group id: %s%sleader info: %s(%s)%s%s", cluster.getGroupId().getUuid(), NEW_LINE, leader.getId(), cluster.getLeader().getPeer().getAddress(), NEW_LINE, NEW_LINE);
        String info = result.substring(0, hearder.length());
        Assertions.assertEquals((Object)hearder, (Object)info);
    }

    @Test
    public void testGroupInfoCommandIncludesCorrectLogInfo() throws Exception {
        this.runWithNewCluster(1, this::runTestGroupInfoCommandWithLogInfoVerification);
    }

    void runTestGroupInfoCommandWithLogInfoVerification(MiniRaftCluster cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        try (RaftClient client = cluster.createClient(leader.getId());){
            int i = 0;
            while ((long)i < RaftServerConfigKeys.Snapshot.creationGap((RaftProperties)this.getProperties())) {
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assertions.assertTrue((boolean)reply.isSuccess());
                ++i;
            }
        }
        leader.getStateMachine().takeSnapshot();
        String address = this.getClusterAddress(cluster);
        StringPrintStream out = new StringPrintStream();
        RatisShell shell = new RatisShell(out.getPrintStream());
        int ret = shell.run(new String[]{"group", "info", "-peers", address});
        Assertions.assertEquals((int)0, (int)ret);
        String result = out.toString().trim();
        String hearder = String.format("group id: %s%sleader info: %s(%s)%s%s", cluster.getGroupId().getUuid(), NEW_LINE, leader.getId(), cluster.getLeader().getPeer().getAddress(), NEW_LINE, NEW_LINE);
        String info = result.substring(0, hearder.length());
        Assertions.assertEquals((Object)hearder, (Object)info);
        long currentTerm = leader.getInfo().getCurrentTerm();
        String logInfoProtoFormat = "%s {" + NEW_LINE + "  term: " + currentTerm + NEW_LINE + "  index: %s";
        Assertions.assertTrue((boolean)result.contains(String.format(logInfoProtoFormat, "applied", leader.getStateMachine().getLastAppliedTermIndex().getIndex())));
        Assertions.assertTrue((boolean)result.contains(String.format(logInfoProtoFormat, "committed", leader.getRaftLog().getLastCommittedIndex())));
        Assertions.assertTrue((boolean)result.contains(String.format(logInfoProtoFormat, "lastSnapshot", leader.getStateMachine().getLatestSnapshot().getIndex())));
        Assertions.assertTrue((boolean)result.contains(String.format(logInfoProtoFormat, "lastEntry", leader.getRaftLog().getLastCommittedIndex())));
    }
}

