/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.shell.cli.sh.RatisShell;
import org.apache.ratis.shell.cli.sh.StringPrintStream;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class LocalCommandIntegrationTest {
    private static final String RAFT_META_CONF = "raft-meta.conf";
    private static final String NEW_RAFT_META_CONF = "new-raft-meta.conf";
    private static Pattern p = Pattern.compile("(?:\\w+\\|\\w+:\\d+,?)+");

    @Test
    public void testDuplicatedPeerAddresses() throws Exception {
        String[] duplicatedAddressesList = new String[]{"peer1_ID1|host1:9872,peer2_ID|host2:9872,peer1_ID2|host1:9872", "host1:9872,host2:9872,host1:9872"};
        this.testDuplicatedPeers(duplicatedAddressesList, "address", "host1:9872");
    }

    @Test
    public void testDuplicatedPeerIds() throws Exception {
        String[] duplicatedIdsList = new String[]{"peer1_ID1|host1:9872,peer2_ID|host2:9872,peer1_ID1|host3:9872"};
        this.testDuplicatedPeers(duplicatedIdsList, "ID", "peer1_ID1");
    }

    private void testDuplicatedPeers(String[] peersList, String expectedErrorMessagePart, String expectedDuplicatedValue) throws Exception {
        for (String peersStr : peersList) {
            StringPrintStream out = new StringPrintStream();
            RatisShell shell = new RatisShell(out.getPrintStream());
            int ret = shell.run(new String[]{"local", "raftMetaConf", "-peers", peersStr, "-path", "test"});
            Assertions.assertEquals((int)-1, (int)ret);
            String message = out.toString().trim();
            Assertions.assertEquals((Object)String.format("Found duplicated %s: %s. Please make sure the %s of peer have no duplicated value.", expectedErrorMessagePart, expectedDuplicatedValue, expectedErrorMessagePart), (Object)message);
        }
    }

    @Test
    public void testRunMethod(@TempDir Path tempDir) throws Exception {
        String[] testPeersListArray;
        int index = 1;
        this.generateRaftConf(tempDir.resolve(RAFT_META_CONF), index);
        for (String peersListStr : testPeersListArray = new String[]{"peer1_ID|localhost:9872,peer2_ID|host2:9872,peer3_ID|host3:9872", "host1:9872,host2:9872,host3:9872"}) {
            List peers;
            long indexFromNewConf;
            this.generateRaftConf(tempDir.resolve(RAFT_META_CONF), index);
            StringPrintStream out = new StringPrintStream();
            RatisShell shell = new RatisShell(out.getPrintStream());
            int ret = shell.run(new String[]{"local", "raftMetaConf", "-peers", peersListStr, "-path", tempDir.toString()});
            Assertions.assertEquals((int)0, (int)ret);
            try (InputStream in = Files.newInputStream(tempDir.resolve(NEW_RAFT_META_CONF), new OpenOption[0]);){
                RaftProtos.LogEntryProto logEntry = ((RaftProtos.LogEntryProto.Builder)RaftProtos.LogEntryProto.newBuilder().mergeFrom(in)).build();
                indexFromNewConf = logEntry.getIndex();
                peers = logEntry.getConfigurationEntry().getPeersList();
            }
            Assertions.assertEquals((long)(index + 1), (long)indexFromNewConf);
            String addressRegex = "^[a-zA-Z0-9.-]+:\\d+$";
            Pattern pattern = Pattern.compile(addressRegex);
            peers.forEach(peerProto -> Assertions.assertTrue((boolean)pattern.matcher(peerProto.getAddress()).matches()));
            String peersListStrFromNewMetaConf = this.containsPeerId(peersListStr) ? peers.stream().map(peer -> peer.getId().toStringUtf8() + "|" + peer.getAddress()).collect(Collectors.joining(",")) : peers.stream().map(RaftProtos.RaftPeerProto::getAddress).collect(Collectors.joining(","));
            Assertions.assertEquals((Object)peersListStr, (Object)peersListStrFromNewMetaConf);
        }
    }

    private void generateRaftConf(Path path, int index) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("peer1_ID", "host1:9872");
        map.put("peer2_ID", "host2:9872");
        map.put("peer3_ID", "host3:9872");
        map.put("peer4_ID", "host4:9872");
        ArrayList<RaftProtos.RaftPeerProto> raftPeerProtos = new ArrayList<RaftProtos.RaftPeerProto>();
        for (Map.Entry en : map.entrySet()) {
            raftPeerProtos.add(RaftProtos.RaftPeerProto.newBuilder().setId(ByteString.copyFrom((byte[])((String)en.getKey()).getBytes(StandardCharsets.UTF_8))).setAddress((String)en.getValue()).setStartupRole(RaftProtos.RaftPeerRole.FOLLOWER).build());
        }
        RaftProtos.LogEntryProto generateLogEntryProto = RaftProtos.LogEntryProto.newBuilder().setConfigurationEntry(RaftProtos.RaftConfigurationProto.newBuilder().addAllPeers(raftPeerProtos).build()).setIndex((long)index).build();
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            generateLogEntryProto.writeTo(out);
        }
    }

    private boolean containsPeerId(String str) {
        return p.matcher(str).find();
    }
}

